/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParametersList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ParamsGroup
implements Cloneable {
    private final String myGroupId;
    private final ParametersList myParamList;

    public ParamsGroup(@NotNull String groupId) {
        this(groupId, new ParametersList());
    }

    private ParamsGroup(@NotNull String groupId, @NotNull ParametersList paramList) {
        this.myGroupId = groupId;
        this.myParamList = paramList;
    }

    @NotNull
    public String getId() {
        return this.myGroupId;
    }

    public void addParameter(@NotNull String parameter) {
        this.myParamList.add(parameter);
    }

    public void addParameterAt(int index, @NotNull String parameter) {
        this.myParamList.addAt(index, parameter);
    }

    public void addParameters(String ... parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(@NotNull List<String> parameters) {
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParametersString(@NotNull String parametersString) {
        this.addParameters(ParametersList.parse(parametersString));
    }

    public List<String> getParameters() {
        return this.myParamList.getList();
    }

    public ParametersList getParametersList() {
        return this.myParamList;
    }

    public ParamsGroup clone() {
        return new ParamsGroup(this.myGroupId, this.myParamList.clone());
    }

    public String toString() {
        return this.myGroupId + ":" + this.myParamList;
    }
}

