/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchFromHereAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getScratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runScratch", "scratchFile", "Companion", "kotlin.jvm"})
public final class ScratchFileAutoRunner
implements DocumentListener {
    private final Alarm myAlarm;
    private final Project project;
    public static final int AUTO_RUN_DELAY_IN_SECONDS = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026event.document) ?: return");
        VirtualFile file = virtualFile;
        if (this.project.isDisposed()) {
            return;
        }
        ScratchFile scratchFile = this.getScratchFile(file, this.project);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        if (!scratchFile2.getOptions().isInteractiveMode()) {
            return;
        }
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"event.newFragment");
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            this.runScratch(scratchFile2);
        }
    }

    private final void runScratch(ScratchFile scratchFile) {
        this.myAlarm.cancelAllRequests();
        if (ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile) && !scratchFile.getOptions().isRepl()) {
            ScratchCompilationSupport.INSTANCE.forceStop();
        }
        this.myAlarm.addRequest(new Runnable(scratchFile){
            final /* synthetic */ ScratchFile $scratchFile;

            public final void run() {
                PsiFile psiFile2 = this.$scratchFile.getPsiFile();
                if (psiFile2 != null && psiFile2.isValid() && !this.$scratchFile.hasErrors()) {
                    if (this.$scratchFile.getOptions().isRepl()) {
                        RunScratchFromHereAction.Companion.doAction(this.$scratchFile);
                    } else {
                        RunScratchAction.Companion.doAction(this.$scratchFile, true);
                    }
                }
            }
            {
                this.$scratchFile = scratchFile;
            }
        }, 2000, true);
    }

    private final ScratchFile getScratchFile(VirtualFile file, Project project) {
        TextEditor editor;
        TextEditor textEditor;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        if (!(fileEditor instanceof TextEditor)) {
            fileEditor = null;
        }
        return (textEditor = (editor = (TextEditor)fileEditor)) != null && (textEditor = KtScratchFileEditorProviderKt.findScratchFileEditorWithPreview(textEditor)) != null ? textEditor.getScratchFile() : null;
    }

    public ScratchFileAutoRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.project);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion;", "", "()V", "AUTO_RUN_DELAY_IN_SECONDS", "", "addListener", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getInstance", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "kotlin.jvm.PlatformType", "kotlin.jvm"})
    public static final class Companion {
        public final void addListener(@NotNull Project project, @NotNull TextEditor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (ScratchUtilsKt.getScratchFile(editor) != null) {
                Editor editor2 = editor.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor.editor");
                editor2.getDocument().addDocumentListener((DocumentListener)this.getInstance(project));
                Disposer.register((Disposable)((Disposable)editor), (Disposable)new Disposable(editor, project){
                    final /* synthetic */ TextEditor $editor;
                    final /* synthetic */ Project $project;

                    public final void dispose() {
                        Editor editor = this.$editor.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor.editor");
                        editor.getDocument().removeDocumentListener((DocumentListener)org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner$Companion.access$getInstance(ScratchFileAutoRunner.Companion, this.$project));
                    }
                    {
                        this.$editor = textEditor;
                        this.$project = project;
                    }
                });
            }
        }

        private final ScratchFileAutoRunner getInstance(Project project) {
            return (ScratchFileAutoRunner)ServiceManager.getService((Project)project, ScratchFileAutoRunner.class);
        }

        private Companion() {
        }

        public static final /* synthetic */ ScratchFileAutoRunner access$getInstance(Companion $this, Project project) {
            return $this.getInstance(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

