/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIJavaVisitor;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIKotlinVisitor;
import org.jetbrains.kotlin.idea.inspections.api.ProblemsCache;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "problems", "", "Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Problem;", "getProblems", "()Ljava/util/List;", "setProblems", "(Ljava/util/List;)V", "problemsCache", "Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;", "addProblem", "", "reference", "", "reason", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "readSettings", "node", "Lorg/jdom/Element;", "Companion", "Problem", "kotlin.jvm"})
public final class IncompatibleAPIInspection
extends LocalInspectionTool {
    @NotNull
    private List<Problem> problems;
    private final ProblemsCache problemsCache;
    @NotNull
    public static final String SHORT_NAME = "IncompatibleAPI";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Problem> getProblems() {
        return this.problems;
    }

    public final void setProblems(@NotNull List<Problem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.problems = list;
    }

    public final void addProblem(@NotNull String reference, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.problems = CollectionsKt.plus((Collection)this.problems, (Object)new Problem(reference, reason));
        this.problemsCache.update(this.problems);
    }

    public void readSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super.readSettings(node);
        this.problemsCache.update(this.problems);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (this.problems.isEmpty()) {
            PsiElementVisitor psiElementVisitor2 = super.buildVisitor(holder, isOnTheFly);
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"super.buildVisitor(holder, isOnTheFly)");
            return psiElementVisitor2;
        }
        PsiFile psiFile2 = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"holder.file");
        Language language = psiFile2.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            psiElementVisitor = (PsiElementVisitor)new IncompatibleAPIKotlinVisitor(holder, this.problemsCache);
        } else if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            psiElementVisitor = (PsiElementVisitor)new IncompatibleAPIJavaVisitor(holder, this.problemsCache);
        } else {
            PsiElementVisitor psiElementVisitor3 = super.buildVisitor(holder, isOnTheFly);
            psiElementVisitor = psiElementVisitor3;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor3, (String)"super.buildVisitor(holder, isOnTheFly)");
        }
        return psiElementVisitor;
    }

    public IncompatibleAPIInspection() {
        boolean bl = false;
        this.problems = new ArrayList();
        this.problemsCache = new ProblemsCache();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R \u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Problem;", "", "reference", "", "reason", "(Ljava/lang/String;Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "setReason", "(Ljava/lang/String;)V", "getReference", "setReference", "kotlin.jvm"})
    public static final class Problem {
        @Attribute
        @Nullable
        private String reference;
        @Attribute
        @Nullable
        private String reason;

        @Nullable
        public final String getReference() {
            return this.reference;
        }

        public final void setReference(@Nullable String string) {
            this.reference = string;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        public final void setReason(@Nullable String string) {
            this.reason = string;
        }

        public Problem(@Nullable String reference, @Nullable String reason) {
            this.reference = reference;
            this.reason = reason;
        }

        public /* synthetic */ Problem(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        public Problem() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Companion;", "", "()V", "DEFAULT_REASON", "", "getDEFAULT_REASON", "()Ljava/lang/String;", "SHORT_NAME", "kotlin.jvm"})
    public static final class Companion {
        @NotNull
        public final String getDEFAULT_REASON() {
            return KotlinJvmBundle.message("reason.incompatible.api", new Object[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

