/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.inspections.AddKotlinLibQuickFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix;", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getFamilyName", "", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "getText", "Companion", "kotlin.jvm"})
public final class AddTestLibQuickFix
extends AddKotlinLibQuickFix {
    @NotNull
    private static final Set<String> KOTLIN_TEST_UNRESOLVED;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return KotlinJvmBundle.message("classpath.add.kotlin.test", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected AddKotlinLibQuickFix.MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = KotlinVersionInfoProviderKt.getCleanRuntimeLibraryVersion((Module)module);
        if (string == null) {
            string = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        }
        return new AddKotlinLibQuickFix.MavenExternalLibraryDescriptor("org.jetbrains.kotlin", "kotlin-test", string);
    }

    public AddTestLibQuickFix(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element, CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.TEST_JAR, LibraryJarDescriptor.TEST_SRC_JAR}));
    }

    static {
        Companion = new Companion(null);
        KOTLIN_TEST_UNRESOLVED = SetsKt.setOf((Object[])new String[]{"Asserter", "assertFailsWith", "currentStackTrace", "failsWith", "todo", "assertEquals", "assertFails", "assertNot", "assertNotEquals", "assertNotNull", "assertNull", "assertTrue", "expect", "fail", "fails"});
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "KOTLIN_TEST_UNRESOLVED", "", "", "getKOTLIN_TEST_UNRESOLVED", "()Ljava/util/Set;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.jvm"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public final Set<String> getKOTLIN_TEST_UNRESOLVED() {
            return KOTLIN_TEST_UNRESOLVED;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 unresolvedReference = (DiagnosticWithParameters1)Errors.UNRESOLVED_REFERENCE.cast((UnboundDiagnostic)diagnostic);
            if (PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), KtImportDirective.class) != null) {
                return null;
            }
            DiagnosticWithParameters1 diagnosticWithParameters1 = unresolvedReference;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticWithParameters1, (String)"unresolvedReference");
            Object object = diagnosticWithParameters1.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unresolvedReference.a");
            String unresolvedText = ((KtReferenceExpression)object).getText();
            if (this.getKOTLIN_TEST_UNRESOLVED().contains(unresolvedText)) {
                void $this$filterTo$iv$iv;
                PsiFile psiFile2 = diagnostic.getPsiElement().getContainingFile();
                if (!(psiFile2 instanceof KtFile)) {
                    psiFile2 = null;
                }
                KtFile ktFile = (KtFile)psiFile2;
                if (ktFile == null) {
                    return null;
                }
                KtFile ktFile2 = ktFile;
                FqName exactImportFqName = new FqName("kotlin.test." + unresolvedText);
                FqName kotlinTestAllUnder = new FqName("kotlin.test");
                boolean hasExactImport = false;
                boolean hasKotlinTestAllUnder = false;
                Iterable $this$filter$iv = ktFile2.getImportDirectives();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtImportDirective it = (KtImportDirective)element$iv$iv;
                    boolean bl = false;
                    String string = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"kotlin.test.", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (KtImportDirective importDirective : (List)destination$iv$iv) {
                    if (Intrinsics.areEqual((Object)importDirective.getImportedFqName(), (Object)exactImportFqName)) {
                        hasExactImport = true;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)importDirective.getImportedFqName(), (Object)kotlinTestAllUnder) || !importDirective.isAllUnder()) continue;
                    hasKotlinTestAllUnder = true;
                    break;
                }
                if (hasExactImport || hasKotlinTestAllUnder) {
                    KotlinQuickFixAction kotlinQuickFixAction;
                    Diagnostic $this$createIntentionForFirstParentOfType$iv = diagnostic;
                    boolean $i$f$createIntentionForFirstParentOfType = false;
                    PsiElement $this$getNonStrictParentOfType$iv$iv = $this$createIntentionForFirstParentOfType$iv.getPsiElement();
                    boolean $i$f$getNonStrictParentOfType = false;
                    PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtElement.class, (boolean)false);
                    if (psiElement != null) {
                        PsiElement psiElement2 = psiElement;
                        boolean bl = false;
                        boolean bl2 = false;
                        KtElement p1 = (KtElement)psiElement2;
                        boolean bl3 = false;
                        kotlinQuickFixAction = new AddTestLibQuickFix(p1);
                    } else {
                        kotlinQuickFixAction = null;
                    }
                    return (IntentionAction)kotlinQuickFixAction;
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

