/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.util.ProgressIndicatorUtils;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigureKotlinInProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getApplicableConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm"})
public abstract class ConfigureKotlinInProjectAction
extends AnAction {
    @NotNull
    public abstract Collection<KotlinProjectConfigurator> getApplicableConfigurators(@NotNull Project var1);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean bl;
        Collection configurators;
        Project project;
        block9: {
            void modules;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
            project = project2;
            Pair pair = (Pair)ProgressIndicatorUtils.underModalProgress((Project)project, (String)KotlinJvmBundle.message("lookup.project.configurators.progress.text", new Object[0]), (Function0)((Function0)new Function0<Pair<? extends List<? extends ModuleSourceRootGroup>, ? extends Collection<? extends KotlinProjectConfigurator>>>(this, project){
                final /* synthetic */ ConfigureKotlinInProjectAction this$0;
                final /* synthetic */ Project $project;

                @NotNull
                public final Pair<List<ModuleSourceRootGroup>, Collection<KotlinProjectConfigurator>> invoke() {
                    boolean bl;
                    List<ModuleSourceRootGroup> modules;
                    block4: {
                        modules = ConfigureKotlinInProjectUtilsKt.getConfigurableModules(this.$project);
                        Iterable $this$all$iv = modules;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                ModuleSourceRootGroup p1 = (ModuleSourceRootGroup)element$iv;
                                boolean bl2 = false;
                                if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p1)) continue;
                                bl = false;
                                break block4;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return TuplesKt.to(modules, (Object)CollectionsKt.emptyList());
                    }
                    Collection<KotlinProjectConfigurator> configurators = this.this$0.getApplicableConfigurators(this.$project);
                    return TuplesKt.to(modules, configurators);
                }
                {
                    this.this$0 = configureKotlinInProjectAction;
                    this.$project = project;
                    super(0);
                }
            }));
            List list = (List)pair.component1();
            configurators = (Collection)pair.component2();
            Iterable $this$all$iv = (Iterable)modules;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModuleSourceRootGroup p1 = (ModuleSourceRootGroup)element$iv;
                    boolean bl2 = false;
                    if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(p1)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            String string = KotlinJvmBundle.message("all.modules.with.kotlin.files.are.configured", new Object[0]);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            String string2 = presentation.getText();
            Intrinsics.checkNotNull((Object)string2);
            Messages.showInfoMessage((String)string, (String)string2);
            return;
        }
        if (configurators.size() == 1) {
            ((KotlinProjectConfigurator)CollectionsKt.first((Iterable)configurators)).configure(project, CollectionsKt.emptyList());
        } else if (configurators.isEmpty()) {
            String string = KotlinJvmBundle.message("there.aren.t.configurators.available", new Object[0]);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            String string3 = presentation.getText();
            Intrinsics.checkNotNull((Object)string3);
            Messages.showErrorDialog((String)string, (String)string3);
        } else {
            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(project, CollectionsKt.toList((Iterable)configurators));
            configuratorsPopup.showInBestPositionFor(e.getDataContext());
        }
    }
}

