/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.pico.ComponentParameter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

@Deprecated
public final class CachingConstructorInjectionComponentAdapter
implements ComponentAdapter {
    private static final ThreadLocal<Set<Class<?>>> ourGuard = new ThreadLocal();
    private Object myInstance;
    private final Object key;
    private final Class<?> componentImplementation;

    public CachingConstructorInjectionComponentAdapter(@NotNull Object key, @NotNull Class<?> componentImplementation) {
        this.key = key;
        this.componentImplementation = componentImplementation;
    }

    @Override
    public Object getComponentKey() {
        return this.key;
    }

    @Override
    public Class<?> getComponentImplementation() {
        return this.componentImplementation;
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.key + "]";
    }

    @Override
    public Object getComponentInstance(@NotNull PicoContainer container) {
        Object instance = this.myInstance;
        if (instance == null) {
            this.myInstance = instance = CachingConstructorInjectionComponentAdapter.instantiateGuarded(this, container, this.getComponentImplementation());
        }
        return instance;
    }

    @NotNull
    public static Object instantiateGuarded(@Nullable CachingConstructorInjectionComponentAdapter adapter, @NotNull PicoContainer container, @NotNull Class<?> componentImplementation) {
        Set<Class<Object>> currentStack = ourGuard.get();
        if (currentStack == null) {
            currentStack = Collections.newSetFromMap(new IdentityHashMap(1));
            ourGuard.set(currentStack);
        }
        if (!currentStack.add(componentImplementation)) {
            throw new CyclicDependencyException(componentImplementation);
        }
        try {
            Object object = CachingConstructorInjectionComponentAdapter.doGetComponentInstance(adapter, (DefaultPicoContainer)container, componentImplementation);
            return object;
        }
        catch (CyclicDependencyException e) {
            e.push(componentImplementation);
            throw e;
        }
        finally {
            currentStack.remove(componentImplementation);
        }
    }

    @NotNull
    private static Object doGetComponentInstance(@Nullable ComponentAdapter adapter, @NotNull DefaultPicoContainer container, @NotNull Class<?> componentImplementation) {
        Constructor<?> constructor;
        try {
            constructor = CachingConstructorInjectionComponentAdapter.getGreediestSatisfiableConstructor(adapter, container, componentImplementation);
        }
        catch (AmbiguousComponentResolutionException e) {
            e.setComponent(componentImplementation);
            throw e;
        }
        try {
            constructor.setAccessible(true);
            if (constructor.getParameterCount() == 0) {
                return constructor.newInstance(new Object[0]);
            }
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] result = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                ComponentAdapter componentAdapter = ComponentParameter.resolveAdapter(container, adapter, parameterTypes[i]);
                if (componentAdapter == null) continue;
                result[i] = container.getComponentInstance(componentAdapter.getComponentKey());
            }
            return constructor.newInstance(result);
        }
        catch (InvocationTargetException e) {
            ExceptionUtilRt.rethrowUnchecked((Throwable)e.getTargetException());
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException("Should never get here");
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }

    @NotNull
    private static Constructor<?> getGreediestSatisfiableConstructor(@Nullable ComponentAdapter adapter, @NotNull DefaultPicoContainer container, @NotNull Class<?> componentImplementation) throws PicoIntrospectionException, AssignabilityRegistrationException {
        HashSet conflicts = new HashSet();
        HashSet<Class<?>[]> unsatisfiableDependencyTypes = new HashSet<Class<?>[]>();
        Constructor<?>[] constructors = componentImplementation.getDeclaredConstructors();
        Arrays.sort(constructors, (arg0, arg1) -> arg1.getParameterCount() - arg0.getParameterCount());
        Constructor<?> greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class<?> unsatisfiedDependencyType = null;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes;
            if (constructor.isSynthetic() || CachingConstructorInjectionComponentAdapter.isNonInjectable(constructor)) continue;
            boolean failedDependency = false;
            for (Class<?> type : parameterTypes = constructor.getParameterTypes()) {
                if (ComponentParameter.resolveAdapter(container, adapter, type) != null) continue;
                unsatisfiableDependencyTypes.add(parameterTypes);
                unsatisfiedDependencyType = type;
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(componentImplementation, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container);
        }
        if (greediestConstructor == null) {
            HashSet nonMatching = new HashSet(Arrays.asList(componentImplementation.getDeclaredConstructors()));
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + nonMatching + " or the constructors were not accessible for '" + componentImplementation + "'");
        }
        return greediestConstructor;
    }

    private static boolean isNonInjectable(@NotNull Constructor<?> constructor) {
        for (Annotation o : constructor.getAnnotations()) {
            String name = o.annotationType().getName();
            if (!"com.intellij.serviceContainer.NonInjectable".equals(name) && !"java.lang.Deprecated".equals(name)) continue;
            return true;
        }
        return false;
    }
}

