/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.XmlExtensionAdapter;
import java.util.HashSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InterfaceExtensionPoint<T>
extends ExtensionPointImpl<T> {
    InterfaceExtensionPoint(@NotNull String name, @NotNull Class<T> clazz, @NotNull PluginDescriptor pluginDescriptor) {
        super(name, clazz.getName(), pluginDescriptor, clazz, false);
    }

    public InterfaceExtensionPoint(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, boolean dynamic) {
        super(name, className, pluginDescriptor, null, dynamic);
    }

    @Override
    @NotNull
    public ExtensionPointImpl<T> cloneFor(@NotNull ComponentManager manager) {
        InterfaceExtensionPoint<T> result = new InterfaceExtensionPoint<T>(this.getName(), this.getClassName(), this.getPluginDescriptor(), this.isDynamic());
        result.setComponentManager(manager);
        return result;
    }

    @Override
    @NotNull
    protected ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        String implementationClassName = extensionElement.getAttributeValue("implementation");
        if (implementationClassName == null && (implementationClassName = extensionElement.getAttributeValue("implementationClass")) == null) {
            throw componentManager.createError("Attribute \"implementation\" is not specified for \"" + this.getName() + "\" extension", pluginDescriptor.getPluginId());
        }
        String orderId = extensionElement.getAttributeValue("id");
        LoadingOrder order = LoadingOrder.readOrder(extensionElement.getAttributeValue("order"));
        Element effectiveElement = InterfaceExtensionPoint.shouldDeserializeInstance(extensionElement) ? extensionElement : null;
        return new XmlExtensionAdapter.SimpleConstructorInjectionAdapter(implementationClassName, pluginDescriptor, orderId, order, effectiveElement);
    }

    @Override
    void unregisterExtensions(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<Element> elements, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        HashSet<String> implementationClassNames = new HashSet<String>();
        for (Element element : elements) {
            implementationClassNames.add(element.getAttributeValue("implementation"));
        }
        this.unregisterExtensions((x, adapter) -> !implementationClassNames.contains(adapter.getAssignableToClassName()), false, priorityListenerCallbacks, listenerCallbacks);
    }

    private static boolean shouldDeserializeInstance(@NotNull Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "implementationClass".equals(name) || "id".equals(name) || "order".equals(name) || "os".equals(name)) continue;
            return true;
        }
        return false;
    }
}

