/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtensionComponentAdapter
implements LoadingOrder.Orderable {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    @NotNull
    private final PluginDescriptor myPluginDescriptor;
    @NotNull
    Object myImplementationClassOrName;
    private final String myOrderId;
    private final LoadingOrder myOrder;

    ExtensionComponentAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order) {
        this.myImplementationClassOrName = implementationClassName;
        this.myPluginDescriptor = pluginDescriptor;
        this.myOrderId = orderId;
        this.myOrder = order;
    }

    abstract boolean isInstanceCreated();

    @NotNull
    public <T> T createInstance(@NotNull ComponentManager componentManager) {
        Class<T> aClass;
        try {
            aClass = this.getImplementationClass();
        }
        catch (ClassNotFoundException e) {
            throw componentManager.createError(e, this.myPluginDescriptor.getPluginId());
        }
        T instance = this.instantiateClass(aClass, componentManager);
        if (instance instanceof PluginAware) {
            ((PluginAware)instance).setPluginDescriptor(this.myPluginDescriptor);
        }
        return instance;
    }

    @NotNull
    protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
        return componentManager.instantiateClass(aClass, this.myPluginDescriptor.getPluginId());
    }

    @Override
    public final LoadingOrder getOrder() {
        return this.myOrder;
    }

    @Override
    public final String getOrderId() {
        return this.myOrderId;
    }

    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    public final <T> Class<T> getImplementationClass() throws ClassNotFoundException {
        Class<?> implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            ClassLoader classLoader = this.myPluginDescriptor.getPluginClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            this.myImplementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
        }
        return implementationClassOrName;
    }

    @NotNull
    public final String getAssignableToClassName() {
        Object implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            return (String)implementationClassOrName;
        }
        return ((Class)implementationClassOrName).getName();
    }

    public String toString() {
        return "ExtensionComponentAdapter(impl=" + this.getAssignableToClassName() + ", plugin=" + this.myPluginDescriptor + ")";
    }
}

