/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.XmlExtensionAdapter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.pico.DefaultPicoContainer;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class BeanExtensionPoint<T>
extends ExtensionPointImpl<T> {
    public BeanExtensionPoint(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, boolean dynamic) {
        super(name, className, pluginDescriptor, null, dynamic);
    }

    @Override
    @NotNull
    public ExtensionPointImpl<T> cloneFor(@NotNull ComponentManager manager) {
        BeanExtensionPoint<T> result = new BeanExtensionPoint<T>(this.getName(), this.getClassName(), this.getPluginDescriptor(), this.isDynamic());
        result.setComponentManager(manager);
        return result;
    }

    @Override
    @NotNull
    protected ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        Element effectiveElement;
        String orderId = extensionElement.getAttributeValue("id");
        LoadingOrder order = LoadingOrder.readOrder(extensionElement.getAttributeValue("order"));
        Object object = effectiveElement = !JDOMUtil.isEmpty((Element)extensionElement) ? extensionElement : null;
        if (((DefaultPicoContainer)componentManager.getPicoContainer()).getParent() == null) {
            return new XmlExtensionAdapter(this.getClassName(), pluginDescriptor, orderId, order, effectiveElement);
        }
        return new XmlExtensionAdapter.SimpleConstructorInjectionAdapter(this.getClassName(), pluginDescriptor, orderId, order, effectiveElement);
    }

    @Override
    void unregisterExtensions(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor, @NotNull List<Element> elements, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        HashMap<String, String> defaultAttributes;
        block2: {
            defaultAttributes = new HashMap<String, String>();
            try {
                Object defaultInstance = componentManager.instantiateExtensionWithPicoContainerOnlyIfNeeded(this.getClassName(), pluginDescriptor);
                defaultAttributes.putAll(XmlExtensionAdapter.getSerializedDataMap(XmlSerializer.serialize(defaultInstance)));
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClassNotFoundException) break block2;
                throw e;
            }
        }
        this.unregisterExtensions((x, adapter) -> {
            if (!(adapter instanceof XmlExtensionAdapter)) {
                return true;
            }
            XmlExtensionAdapter xmlExtensionAdapter = (XmlExtensionAdapter)adapter;
            return xmlExtensionAdapter.getPluginDescriptor() != pluginDescriptor || !xmlExtensionAdapter.isLoadedFromAnyElement(elements, defaultAttributes);
        }, false, priorityListenerCallbacks, listenerCallbacks);
    }
}

