/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginId
implements Comparable<PluginId> {
    public static final PluginId[] EMPTY_ARRAY = new PluginId[0];
    private static final Map<String, PluginId> ourRegisteredIds = new Object2ObjectOpenHashMap();
    private final String myIdString;

    @NotNull
    public static synchronized PluginId getId(@NotNull String idString) {
        return ourRegisteredIds.computeIfAbsent(idString, PluginId::new);
    }

    @Nullable
    public static synchronized PluginId findId(String ... idStrings) {
        for (String idString : idStrings) {
            PluginId pluginId = ourRegisteredIds.get(idString);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static synchronized Map<String, PluginId> getRegisteredIds() {
        return new Object2ObjectOpenHashMap(ourRegisteredIds);
    }

    @NotNull
    public static synchronized Collection<PluginId> getRegisteredIdList() {
        return new ArrayList<PluginId>(ourRegisteredIds.values());
    }

    private PluginId(@NotNull String idString) {
        this.myIdString = idString;
    }

    @NotNull
    public String getIdString() {
        return this.myIdString;
    }

    @Override
    public int compareTo(@NotNull PluginId o) {
        return this.myIdString.compareTo(o.myIdString);
    }

    public String toString() {
        return this.getIdString();
    }
}

