/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemEventSerializer {
    @NotNull
    public static String serialize(@NotNull ExternalSystemEvent event) {
        String prefix = event.getTimestamp() + " " + event.getEventType().name();
        if (event instanceof ExternalUploadFinishedEvent) {
            ExternalUploadFinishedEvent failed = (ExternalUploadFinishedEvent)event;
            if (StatisticsStringUtil.isNotEmpty((String)failed.getError())) {
                return prefix + " " + StatisticsEventEscaper.escape(failed.getError());
            }
            return prefix;
        }
        if (event instanceof ExternalUploadSendEvent) {
            ExternalUploadSendEvent finished = (ExternalUploadSendEvent)event;
            String hashedFiles = finished.getSuccessfullySentFiles().stream().map(path -> Base64.getEncoder().encodeToString(path.getBytes(StandardCharsets.UTF_8))).collect(Collectors.joining(",", "[", "]"));
            return prefix + " " + finished.getSucceed() + " " + finished.getFailed() + " " + finished.getTotal() + " " + hashedFiles;
        }
        if (event instanceof ExternalSystemErrorEvent) {
            ExternalSystemErrorEvent error = (ExternalSystemErrorEvent)event;
            return prefix + " " + StatisticsEventEscaper.escape(error.getEvent()) + " " + StatisticsEventEscaper.escape(error.getErrorClass());
        }
        return prefix;
    }

    @Nullable
    public static ExternalSystemEvent deserialize(@NotNull String line) {
        ExternalSystemEventType type;
        String[] parts = line.split(" ");
        int length = parts.length;
        ExternalSystemEventType externalSystemEventType = type = length > 1 ? ExternalSystemEventType.parse(parts[1]) : null;
        if (type == null) {
            return null;
        }
        long timestamp = ExternalSystemEventSerializer.parseLong(parts[0]);
        if (type == ExternalSystemEventType.FINISHED) {
            String error = parts.length >= 3 ? parts[2].trim() : null;
            return new ExternalUploadFinishedEvent(timestamp, error);
        }
        if (type == ExternalSystemEventType.SEND && (length == 6 || length == 5)) {
            int succeed = ExternalSystemEventSerializer.parseInt(parts[2]);
            int failed = ExternalSystemEventSerializer.parseInt(parts[3]);
            int total = ExternalSystemEventSerializer.parseInt(parts[4]);
            List<String> sentFiles = length == 6 ? ExternalSystemEventSerializer.parseSentFiles(parts[5]) : Collections.emptyList();
            return new ExternalUploadSendEvent(timestamp, succeed, failed, total, sentFiles);
        }
        if (type == ExternalSystemEventType.STARTED && length == 2) {
            return new ExternalUploadStartedEvent(timestamp);
        }
        if (type == ExternalSystemEventType.ERROR && length == 4) {
            String event = parts[2].trim();
            String errorClass = parts[3].trim();
            return new ExternalSystemErrorEvent(timestamp, event, errorClass);
        }
        return null;
    }

    private static List<String> parseSentFiles(@NotNull String part) {
        try {
            if (part.startsWith("[") && part.endsWith("]")) {
                String unwrappedPart = part.substring(1, part.length() - 1);
                String[] filePathHashes = unwrappedPart.split(",");
                return Arrays.stream(filePathHashes).filter(hash -> !hash.isEmpty()).map(hash -> new String(Base64.getDecoder().decode((String)hash), StandardCharsets.UTF_8)).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
    }

    private static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

