/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.request;

import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.service.request.StatsProxyInfo;
import com.intellij.internal.statistic.service.request.StatsRequestResult;
import com.intellij.internal.statistic.service.request.StatsResponseException;
import com.intellij.internal.statistic.service.request.StatsResponseHandler;
import com.intellij.internal.statistic.service.request.StatsResponseProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;

public class StatsRequestBuilder {
    private final String myUserAgent;
    private final StatsProxyInfo myProxyInfo;
    private final String myUrl;
    private final String myMethod;
    private StringEntity myBody;
    private StatsResponseHandler onSucceed;
    private StatsResponseHandler onFail;

    public StatsRequestBuilder(@NotNull String method, @NotNull String url, @NotNull EventLogConnectionSettings settings) {
        this.myMethod = method;
        this.myUrl = url;
        this.myUserAgent = settings.getUserAgent();
        this.myProxyInfo = settings.selectProxy(this.myUrl);
    }

    @NotNull
    public StatsRequestBuilder withBody(@NotNull String body, @NotNull ContentType contentType) {
        this.myBody = new StringEntity(body, contentType);
        return this;
    }

    @NotNull
    public StatsRequestBuilder fail(@NotNull StatsResponseHandler processor) {
        this.onFail = processor;
        return this;
    }

    @NotNull
    public StatsRequestBuilder succeed(@NotNull StatsResponseHandler processor) {
        this.onSucceed = processor;
        return this;
    }

    public void send() throws IOException, StatsResponseException {
        this.send(response -> {
            if (this.onSucceed != null) {
                this.onSucceed.handle(response, 200);
            }
            return true;
        });
    }

    /*
     * Exception decompiling
     */
    public <T> StatsRequestResult<T> send(StatsResponseProcessor<? extends T> processor) throws IOException, StatsResponseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableHttpClient newClient(@NotNull String userAgent) {
        HttpClientBuilder builder = HttpClientBuilder.create().setUserAgent(userAgent);
        if (this.myProxyInfo != null && !this.myProxyInfo.isNoProxy()) {
            StatsRequestBuilder.configureProxy(builder, this.myProxyInfo);
        }
        return builder.build();
    }

    private static void configureProxy(@NotNull HttpClientBuilder builder, @NotNull StatsProxyInfo info) {
        SocketAddress proxyAddress;
        Proxy proxy = info.getProxy();
        if (proxy.type() == Proxy.Type.HTTP && (proxyAddress = proxy.address()) instanceof InetSocketAddress) {
            String login;
            InetSocketAddress address = (InetSocketAddress)proxyAddress;
            String hostName = address.getHostName();
            int port = address.getPort();
            builder.setProxy(new HttpHost(hostName, port));
            StatsProxyInfo.StatsProxyAuthProvider auth = info.getProxyAuth();
            if (auth != null && (login = auth.getProxyLogin()) != null) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(hostName, port), (Credentials)new UsernamePasswordCredentials(login, auth.getProxyPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            }
        }
    }

    @NotNull
    private HttpRequestBase newRequest() {
        if ("HEAD".equals(this.myMethod)) {
            return new HttpHead(this.myUrl);
        }
        if ("POST".equals(this.myMethod)) {
            HttpPost post = new HttpPost(this.myUrl);
            if (this.myBody != null) {
                post.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)this.myBody));
            }
            return post;
        }
        if ("GET".equals(this.myMethod)) {
            return new HttpGet(this.myUrl);
        }
        throw new IllegalArgumentException();
    }
}

