/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.internal.statistic.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.EventLogConnectionSettings;
import com.intellij.internal.statistic.service.fus.EventLogMetadataLoadException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistConditions;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistGroupConditions;
import com.intellij.internal.statistic.service.request.StatsHttpRequests;
import com.intellij.internal.statistic.service.request.StatsRequestResult;
import com.intellij.internal.statistic.service.request.StatsResponseException;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsWhitelistLoader {
    @NotNull
    public static StatisticsWhitelistConditions getApprovedGroups(@NotNull String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        try {
            String content = StatisticsWhitelistLoader.loadWhiteListFromServer(serviceUrl, settings);
            return StatisticsWhitelistLoader.parseApprovedGroups(content);
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            return StatisticsWhitelistConditions.empty();
        }
    }

    @NotNull
    public static String loadWhiteListFromServer(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) throws EventLogMetadataLoadException {
        if (StatisticsStringUtil.isEmptyOrSpaces((String)serviceUrl)) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.EMPTY_SERVICE_URL);
        }
        try {
            StatsRequestResult<String> result = StatsHttpRequests.request(serviceUrl, settings).send(r -> r.readAsString());
            if (result.isSucceed()) {
                return result.getResult();
            }
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.UNREACHABLE_SERVICE, result.getError());
        }
        catch (StatsResponseException | IOException e) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.ERROR_ON_LOAD, (Throwable)e);
        }
    }

    public static long lastModifiedWhitelist(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        if (StatisticsStringUtil.isEmptyOrSpaces((String)serviceUrl)) {
            return 0L;
        }
        try {
            StatsRequestResult<Long> result = StatsHttpRequests.head(serviceUrl, settings).send(r -> r.lastModified());
            return result.getResult() != null ? result.getResult() : 0L;
        }
        catch (StatsResponseException | IOException e) {
            return 0L;
        }
    }

    @NotNull
    public static StatisticsWhitelistConditions parseApprovedGroups(@Nullable String content) throws EventLogMetadataParseException {
        FUStatisticsWhiteListGroupsService.WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent(content);
        HashMap<String, StatisticsWhitelistGroupConditions> groupToCondition = new HashMap<String, StatisticsWhitelistGroupConditions>();
        for (FUStatisticsWhiteListGroupsService.WLGroup group : groups.groups) {
            groupToCondition.put(group.id, StatisticsWhitelistGroupConditions.create(group));
        }
        return StatisticsWhitelistConditions.create(groupToCondition);
    }
}

