/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StatisticsEventEscaper {
    @NotNull
    public static String escape(@NotNull String str) {
        return StatisticsEventEscaper.escapeInternal(str, false);
    }

    @NotNull
    public static String escapeFieldName(@NotNull String str) {
        return StatisticsEventEscaper.escapeInternal(str, true);
    }

    @NotNull
    private static String escapeInternal(@NotNull String str, boolean replaceDot) {
        if (StatisticsEventEscaper.containsSystemSymbols(str, replaceDot)) {
            return StatisticsEventEscaper.replace(str, replaceDot);
        }
        return str;
    }

    @NotNull
    private static String replace(@NotNull String value, boolean replaceDot) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!StatisticsEventEscaper.isAscii(c)) {
                out.append("?");
                continue;
            }
            if (StatisticsEventEscaper.isSymbolToReplace(c, replaceDot)) {
                out.append("_");
                continue;
            }
            if (StatisticsEventEscaper.isProhibitedSymbol(c)) continue;
            out.append(c);
        }
        return out.toString();
    }

    private static boolean containsSystemSymbols(@NotNull String value, boolean replaceDot) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!StatisticsEventEscaper.isAscii(c)) {
                return true;
            }
            if (StatisticsEventEscaper.isSymbolToReplace(c, replaceDot)) {
                return true;
            }
            if (!StatisticsEventEscaper.isProhibitedSymbol(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private static boolean isSymbolToReplace(char c, boolean withDot) {
        if (withDot && c == '.') {
            return true;
        }
        return StatisticsEventEscaper.isAsciiControl(c) || StatisticsEventEscaper.isWhiteSpace(c) || c == ':' || c == ';' || c == ',';
    }

    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    private static boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private static boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }
}

