/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.ui;

import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ScreenshotComparisonPanel;
import com.google.gct.testing.ui.GradientJPanel;
import com.google.gct.testing.ui.TabEventListener;
import com.intellij.icons.AllIcons;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;

public class Tab
extends GradientJPanel {
    private static final Color TOP_COLOR = UIUtil.getPanelBackground();
    private static final Color BOTTOM_COLOR = CloudTestingUtils.makeDarker(UIUtil.getPanelBackground(), 2);
    private static final Color STUB_TAB_BACKGROUND = new Color(200, 200, 200);
    private static final Color STUB_TAB_FOREGROUND = new Color(114, 114, 114);
    private static final Icon closeIcon = AllIcons.Actions.Close;
    private final JBLabel label;
    private final List<TabEventListener> listeners = new LinkedList<TabEventListener>();
    private final JPopupMenu popupMenu;

    public static Tab makeStandardTab(String title, Icon icon, Color borderColor) {
        return new Tab(title, icon, borderColor, true);
    }

    public static Tab makeStubTab(String title) {
        return new Tab(title, null, STUB_TAB_BACKGROUND, false);
    }

    protected Tab(String title, Icon icon, Color borderColor, boolean closeable) {
        this.setLayout(new BorderLayout());
        this.label = new JBLabel(title);
        if (icon != null) {
            this.label.setIcon(icon);
            this.label.setIconTextGap(5);
        }
        JPanel iconLabelPanel = new JPanel();
        iconLabelPanel.setOpaque(false);
        iconLabelPanel.setLayout(new GridBagLayout());
        iconLabelPanel.add((Component)this.label, Tab.createGbc(0));
        this.add((Component)iconLabelPanel, "West");
        this.popupMenu = new JPopupMenu();
        JMenuItem duplicatePanel = new JMenuItem("Duplicate Panel");
        duplicatePanel.setIcon(AllIcons.Actions.Diff);
        duplicatePanel.addActionListener(new DuplicatePanelActionListener());
        this.popupMenu.add(duplicatePanel);
        JMenuItem copyImage = new JMenuItem("Copy to Clipboard");
        copyImage.setIcon(AllIcons.Actions.Copy);
        copyImage.addActionListener(new CopyImageAction());
        this.popupMenu.add(copyImage);
        JMenuItem saveImage = new JMenuItem("Save Image ...");
        saveImage.setIcon(AllIcons.Actions.Menu_saveall);
        saveImage.addActionListener(new SaveImageAction());
        this.popupMenu.add(saveImage);
        if (closeable) {
            JLabel closeLabel = new JLabel(closeIcon);
            JLabel dropMenuLabel = new JLabel(AllIcons.General.ArrowDown);
            dropMenuLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Tab.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            });
            closeLabel.setToolTipText("Close this screenshot");
            JPanel closeLabelPanel = new JPanel();
            closeLabelPanel.setOpaque(false);
            closeLabelPanel.setLayout(new GridBagLayout());
            closeLabelPanel.add((Component)dropMenuLabel, Tab.createGbc(1));
            closeLabelPanel.add((Component)closeLabel, Tab.createGbc(2));
            this.add((Component)closeLabelPanel, "East");
            closeLabel.addMouseListener(new CloseButtonMouseListener());
        }
        if (closeable) {
            this.setBackground(BOTTOM_COLOR, TOP_COLOR);
            this.setBorder(new MatteBorder(1, 1, 0, 1, borderColor));
        } else {
            this.label.setForeground(STUB_TAB_FOREGROUND);
            this.setBackground(STUB_TAB_BACKGROUND);
            this.addMouseListener(new NonCloseableMouseListener());
        }
    }

    public void addTabEventListener(TabEventListener listener) {
        this.listeners.add(listener);
    }

    private static GridBagConstraints createGbc(int x) {
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = x == 0 ? 17 : 13;
        return gbc;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame(Tab.class.getSimpleName());
                frame.setDefaultCloseOperation(3);
                Tab passedTab = Tab.makeStandardTab("Passed", AllIcons.RunConfigurations.TestPassed, ScreenshotComparisonPanel.GREEN);
                Tab newTab = Tab.makeStubTab("Compare");
                JPanel panel = new JPanel(new FlowLayout());
                frame.add(panel);
                panel.add(passedTab);
                panel.add(new JLabel("    "));
                panel.add(newTab);
                frame.setSize(400, 300);
                frame.setVisible(true);
            }
        });
    }

    private class CopyImageAction
    implements ActionListener {
        private CopyImageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (TabEventListener listener : Tab.this.listeners) {
                listener.copyImage();
            }
        }
    }

    private class SaveImageAction
    implements ActionListener {
        private SaveImageAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (TabEventListener listener : Tab.this.listeners) {
                listener.saveImage();
            }
        }
    }

    private class DuplicatePanelActionListener
    implements ActionListener {
        private DuplicatePanelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (TabEventListener listener : Tab.this.listeners) {
                listener.openEvent();
            }
        }
    }

    class CloseButtonMouseListener
    extends MouseAdapter {
        CloseButtonMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (TabEventListener listener : Tab.this.listeners) {
                listener.closeEvent();
            }
        }
    }

    class NonCloseableMouseListener
    extends MouseAdapter {
        NonCloseableMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Tab.this.setBackground(BOTTOM_COLOR, TOP_COLOR);
            Tab.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Tab.this.setBackground(STUB_TAB_BACKGROUND);
            Tab.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            for (TabEventListener listener : Tab.this.listeners) {
                listener.openEvent();
            }
        }
    }
}

