/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.trackers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.PsiModificationTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.KotlinModificationTrackerService;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinIDEModificationTrackerService;", "Lorg/jetbrains/kotlin/analyzer/KotlinModificationTrackerService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "outOfBlockModificationTracker", "getOutOfBlockModificationTracker", "fileModificationTracker", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.fir.frontend-independent"})
public final class KotlinIDEModificationTrackerService
extends KotlinModificationTrackerService {
    @NotNull
    private final ModificationTracker modificationTracker;
    @NotNull
    private final ModificationTracker outOfBlockModificationTracker;

    @NotNull
    public ModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        return this.outOfBlockModificationTracker;
    }

    @NotNull
    public ModificationTracker fileModificationTracker(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return KotlinCodeBlockModificationListenerKt.getPerFileModificationTracker(file);
    }

    public KotlinIDEModificationTrackerService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026VICE.getInstance(project)");
        this.modificationTracker = (ModificationTracker)psiModificationTracker;
        this.outOfBlockModificationTracker = KotlinCodeBlockModificationListener.Companion.getInstance(project).getKotlinOutOfCodeBlockTracker();
    }
}

