/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.jvm;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\u000f\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\rH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"PRIMITIVE_TYPE_SIGNATURE", "", "", "unitClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "appendConeType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "appendErasedType", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "computeJvmDescriptor", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "computeJvmDescriptorReplacingKotlinToJava", "isVoid", "", "jvm"})
public final class DescriptorUtilsKt {
    @NotNull
    private static final Map<String, String> PRIMITIVE_TYPE_SIGNATURE;
    @NotNull
    private static final ClassId unitClassId;

    @NotNull
    public static final String computeJvmDescriptorReplacingKotlinToJava(@NotNull FirFunction<?> $this$computeJvmDescriptorReplacingKotlinToJava) {
        Intrinsics.checkNotNullParameter($this$computeJvmDescriptorReplacingKotlinToJava, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)DescriptorUtilsKt.computeJvmDescriptor($this$computeJvmDescriptorReplacingKotlinToJava), (String)"kotlin/Any", (String)"java/lang/Object", (boolean)false, (int)4, null), (String)"kotlin/String", (String)"java/lang/String", (boolean)false, (int)4, null), (String)"kotlin/Throwable", (String)"java/lang/Throwable", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String computeJvmDescriptor(@NotNull FirFunction<?> $this$computeJvmDescriptor) {
        Intrinsics.checkNotNullParameter($this$computeJvmDescriptor, (String)"<this>");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$computeJvmDescriptor_u24lambda_u2d0 = stringBuilder2;
        boolean bl5 = false;
        if ($this$computeJvmDescriptor instanceof FirSimpleFunction) {
            $this$computeJvmDescriptor_u24lambda_u2d0.append(((FirSimpleFunction)$this$computeJvmDescriptor).getName().asString());
        } else {
            $this$computeJvmDescriptor_u24lambda_u2d0.append("<init>");
        }
        $this$computeJvmDescriptor_u24lambda_u2d0.append("(");
        for (FirValueParameter parameter : $this$computeJvmDescriptor.getValueParameters()) {
            DescriptorUtilsKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d0, parameter.getReturnTypeRef());
        }
        $this$computeJvmDescriptor_u24lambda_u2d0.append(")");
        if (!($this$computeJvmDescriptor instanceof FirSimpleFunction) || DescriptorUtilsKt.isVoid($this$computeJvmDescriptor.getReturnTypeRef())) {
            $this$computeJvmDescriptor_u24lambda_u2d0.append("V");
        } else {
            DescriptorUtilsKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d0, $this$computeJvmDescriptor.getReturnTypeRef());
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private static final void appendErasedType(StringBuilder $this$appendErasedType, FirTypeRef typeRef) {
        JavaType javaType;
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef instanceof FirResolvedTypeRef) {
            DescriptorUtilsKt.appendConeType($this$appendErasedType, ((FirResolvedTypeRef)typeRef).getType());
        } else if (firTypeRef instanceof FirJavaTypeRef && (javaType = ((FirJavaTypeRef)typeRef).getType()) instanceof JavaClassifierType) {
            JavaClassifier classifier = ((JavaClassifierType)javaType).getClassifier();
            if (classifier instanceof JavaClass) {
                DescriptorUtilsKt.appendErasedType$appendClass($this$appendErasedType, (JavaClass)classifier);
            } else if (classifier instanceof JavaTypeParameter) {
                Object v0;
                block11: {
                    Iterable $this$firstOrNull$iv = ((JavaTypeParameter)classifier).getUpperBounds();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JavaClassifierType it = (JavaClassifierType)element$iv;
                        boolean bl = false;
                        if (!(it.getClassifier() instanceof JavaClass)) continue;
                        v0 = element$iv;
                        break block11;
                    }
                    v0 = null;
                }
                JavaClassifierType representative = v0;
                if (representative == null) {
                    $this$appendErasedType.append("Ljava/lang/Object;");
                } else {
                    JavaClassifier javaClassifier = representative.getClassifier();
                    if (javaClassifier == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.JavaClass");
                    }
                    DescriptorUtilsKt.appendErasedType$appendClass($this$appendErasedType, (JavaClass)javaClassifier);
                }
            } else {
                return;
            }
        }
    }

    private static final void appendConeType(StringBuilder $this$appendConeType, ConeKotlinType coneType) {
        ConeKotlinType coneKotlinType;
        ConeClassLikeType coneClassLikeType = coneKotlinType = coneType instanceof ConeClassLikeType ? (ConeClassLikeType)coneType : null;
        if (coneKotlinType != null) {
            String string2;
            ConeClassLikeType coneClassLikeType2 = coneKotlinType;
            boolean bl = false;
            boolean bl2 = false;
            ConeClassLikeType it = coneClassLikeType2;
            boolean bl3 = false;
            ClassId classId = it.getLookupTag().getClassId();
            if (Intrinsics.areEqual((Object)classId.getPackageFqName().toString(), (Object)"kotlin") && (string2 = PRIMITIVE_TYPE_SIGNATURE.get(classId.getShortClassName().getIdentifier())) != null) {
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String signature2 = string3;
                boolean bl6 = false;
                $this$appendConeType.append(signature2);
                return;
            }
        }
        if (coneType instanceof ConeClassErrorType) {
            return;
        }
        coneKotlinType = coneType;
        if (coneKotlinType instanceof ConeClassLikeType) {
            DescriptorUtilsKt.appendConeType$appendClassLikeType($this$appendConeType, (ConeClassLikeType)coneType);
        } else if (coneKotlinType instanceof ConeTypeParameterType) {
            Object v2;
            block16: {
                Iterable $this$firstOrNull$iv = ((FirTypeParameter)((ConeTypeParameterType)coneType).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ConeKotlinType coneKotlinType2;
                    FirTypeRef it = (FirTypeRef)element$iv;
                    boolean bl = false;
                    FirTypeRef $this$coneType$iv = it;
                    boolean $i$f$getConeType = false;
                    FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl7 = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                    ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                    if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                        coneKotlinType3 = null;
                    }
                    if ((coneKotlinType2 = coneKotlinType3) == null) {
                        String string4 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                        boolean bl8 = false;
                        throw (Throwable)new IllegalStateException(string4.toString());
                    }
                    if (!(coneKotlinType2 instanceof ConeClassLikeType)) continue;
                    v2 = element$iv;
                    break block16;
                }
                v2 = null;
            }
            FirTypeRef representative = v2;
            if (representative == null || representative instanceof FirImplicitNullableAnyTypeRef || representative instanceof FirImplicitAnyTypeRef) {
                $this$appendConeType.append("Ljava/lang/Object;");
            } else {
                FirTypeRef $this$coneTypeUnsafe$iv = representative;
                boolean $i$f$coneTypeUnsafe = false;
                ConeKotlinType coneKotlinType4 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
                if (coneKotlinType4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
                }
                DescriptorUtilsKt.appendConeType$appendClassLikeType($this$appendConeType, (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType4)));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            DescriptorUtilsKt.appendConeType($this$appendConeType, ((ConeDefinitelyNotNullType)coneType).getOriginal());
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            DescriptorUtilsKt.appendConeType($this$appendConeType, ((ConeFlexibleType)coneType).getLowerBound());
        }
    }

    private static final boolean isVoid(FirTypeRef $this$isVoid) {
        JavaType type2;
        FirTypeRef firTypeRef = $this$isVoid;
        boolean bl = firTypeRef instanceof FirJavaTypeRef ? (type2 = ((FirJavaTypeRef)$this$isVoid).getType()) instanceof JavaPrimitiveType && ((JavaPrimitiveType)type2).getType() == null : (firTypeRef instanceof FirResolvedTypeRef ? (type = ((FirResolvedTypeRef)$this$isVoid).getType()) instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)type).getLookupTag().getClassId(), (Object)unitClassId) : false);
        return bl;
    }

    private static final void appendErasedType$appendClass(StringBuilder $this_appendErasedType, JavaClass klass) {
        FqName fqName2 = klass.getFqName();
        if (fqName2 != null) {
            FqName fqName3 = fqName2;
            boolean bl = false;
            boolean bl2 = false;
            FqName it = fqName3;
            boolean bl3 = false;
            $this_appendErasedType.append("L");
            String string2 = it.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.asString()");
            $this_appendErasedType.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null));
            $this_appendErasedType.append(";");
        }
    }

    private static final void appendConeType$appendClassLikeType(StringBuilder $this_appendConeType, ConeClassLikeType type2) {
        ClassId classId = type2.getLookupTag().getClassId();
        if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray())) {
            $this_appendConeType.append("[");
            ConeTypeProjection[] $this$forEach$iv = type2.getTypeArguments();
            boolean $i$f$forEach = false;
            ConeTypeProjection[] coneTypeProjectionArray = $this$forEach$iv;
            int n = coneTypeProjectionArray.length;
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection element$iv;
                ConeTypeProjection typeArg = element$iv = coneTypeProjectionArray[i];
                boolean bl = false;
                ConeTypeProjection coneTypeProjection = typeArg;
                if (Intrinsics.areEqual((Object)coneTypeProjection, (Object)ConeStarProjection.INSTANCE)) {
                    $this_appendConeType.append("*");
                    continue;
                }
                if (!(coneTypeProjection instanceof ConeKotlinTypeProjection)) continue;
                DescriptorUtilsKt.appendConeType($this_appendConeType, ((ConeKotlinTypeProjection)typeArg).getType());
            }
        } else {
            $this_appendConeType.append("L");
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.packageFqName.asString()");
            $this_appendConeType.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null));
            $this_appendConeType.append("/");
            $this_appendConeType.append(classId.getRelativeClassName());
            $this_appendConeType.append(";");
        }
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"Boolean", (Object)"Z"), TuplesKt.to((Object)"Byte", (Object)"B"), TuplesKt.to((Object)"Char", (Object)"C"), TuplesKt.to((Object)"Short", (Object)"S"), TuplesKt.to((Object)"Int", (Object)"I"), TuplesKt.to((Object)"Long", (Object)"J"), TuplesKt.to((Object)"Float", (Object)"F"), TuplesKt.to((Object)"Double", (Object)"D")};
        PRIMITIVE_TYPE_SIGNATURE = MapsKt.mapOf((Pair[])object);
        object = ClassId.topLevel(new FqName("kotlin.Unit"));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(FqName(\"kotlin.Unit\"))");
        unitClassId = object;
    }
}

