/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirTypeMismatchOnOverrideChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.AbstractTypeCheckerContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J4\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\u001c\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J&\u0010!\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J&\u0010\"\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001a*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u001a*\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010&\u001a\u00020'*\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeMismatchOnOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "typeCheckerContext", "Lorg/jetbrains/kotlin/types/AbstractTypeCheckerContext;", "firTypeScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "checkProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkReturnType", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "reportMismatchOnFunction", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "type", "", "reportMismatchOnProperty", "reportMismatchOnVariable", "retrieveDirectOverriddenOf", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclarationSymbol", "checkers"})
public final class FirTypeMismatchOnOverrideChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirTypeMismatchOnOverrideChecker INSTANCE = new FirTypeMismatchOnOverrideChecker();

    private FirTypeMismatchOnOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        AbstractTypeCheckerContext typeCheckerContext = SessionUtilsKt.getTypeContext(context2.getSession()).newBaseTypeCheckerContext(false, false);
        FirTypeScope firTypeScope = KotlinScopeProviderKt.unsubstitutedScope(declaration, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), true);
        for (FirDeclaration it : declaration.getDeclarations()) {
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirSimpleFunction) {
                this.checkFunction((FirSimpleFunction)it, reporter, typeCheckerContext, firTypeScope, context2);
                continue;
            }
            if (!(firDeclaration instanceof FirProperty)) continue;
            this.checkProperty((FirProperty)it, reporter, typeCheckerContext, firTypeScope, context2);
        }
    }

    private final List<FirFunctionSymbol<?>> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirSimpleFunction function2) {
        $this$retrieveDirectOverriddenOf.processFunctionsByName(function2.getName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)retrieveDirectOverriddenOf.1.INSTANCE));
        return FirTypeScopeKt.getDirectOverriddenFunctions($this$retrieveDirectOverriddenOf, function2.getSymbol());
    }

    private final List<FirPropertySymbol> retrieveDirectOverriddenOf(FirTypeScope $this$retrieveDirectOverriddenOf, FirProperty property2) {
        $this$retrieveDirectOverriddenOf.processPropertiesByName(property2.getName(), retrieveDirectOverriddenOf.2.INSTANCE);
        return FirTypeScopeKt.getDirectOverriddenProperties($this$retrieveDirectOverriddenOf, property2.getSymbol());
    }

    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableMemberDeclaration<?> overrideDeclaration, FirCallableSymbol<?> baseDeclarationSymbol) {
        FirTypeParametersOwner firTypeParametersOwner;
        if (overrideDeclaration.getTypeParameters().isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        Object $this$safeAs$iv22 = baseDeclarationSymbol.getFir();
        boolean $i$f$safeAs = false;
        Object e = $this$safeAs$iv22;
        if (!(e instanceof FirTypeParametersOwner)) {
            e = null;
        }
        if ((firTypeParametersOwner = (FirTypeParametersOwner)e) == null) {
            return $this$substituteAllTypeParameters;
        }
        FirTypeParametersOwner parametersOwner = firTypeParametersOwner;
        boolean $this$safeAs$iv22 = false;
        Map map = new LinkedHashMap();
        int n = 0;
        int size2 = ((Number)((Object)AddToStdlibKt.min(overrideDeclaration.getTypeParameters().size(), parametersOwner.getTypeParameters().size()))).intValue();
        if (n < size2) {
            do {
                int it = n++;
                FirTypeParameterRef to = overrideDeclaration.getTypeParameters().get(it);
                FirTypeParameter from = parametersOwner.getTypeParameters().get(it);
                Map map2 = map;
                FirTypeParameterSymbol firTypeParameterSymbol = from.getSymbol();
                ConeKotlinType coneKotlinType = FirNestedClassifierScopeKt.toConeType(to);
                boolean bl = false;
                map2.put(firTypeParameterSymbol, coneKotlinType);
            } while (n < size2);
        }
        return SubstitutorsKt.substitutorByMap(map).substituteOrSelf($this$substituteAllTypeParameters);
    }

    /*
     * WARNING - void declaration
     */
    private final FirMemberDeclaration checkReturnType(FirCallableMemberDeclaration<?> $this$checkReturnType, List<? extends FirCallableSymbol<?>> overriddenSymbols2, AbstractTypeCheckerContext typeCheckerContext, CheckerContext context2) {
        void $this$mapTo$iv$iv;
        FirResolvedTypeRef firResolvedTypeRef;
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$safeAs$iv = $this$checkReturnType.getReturnTypeRef();
        boolean $i$f$safeAs22 = false;
        FirTypeRef firTypeRef = $this$safeAs$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType = (firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef) == null ? null : firResolvedTypeRef.getType();
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType returnType2 = coneKotlinType;
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable $i$f$safeAs22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConeKotlinType coneKotlinType3;
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FirTypeRef $this$coneType$iv = context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)it.getFir());
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl2 = false;
            FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType4 = firResolvedTypeRef2 == null ? null : firResolvedTypeRef2.getType();
            if (!(coneKotlinType4 instanceof ConeKotlinType)) {
                coneKotlinType4 = null;
            }
            if ((coneKotlinType3 = coneKotlinType4) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ConeKotlinType coneKotlinType5 = ConeTypesKt.upperBoundIfFlexible(coneKotlinType3);
            collection.add(coneKotlinType5);
        }
        int n = 0;
        List bounds = (List)destination$iv$iv;
        int n2 = bounds.size() + -1;
        if (n <= n2) {
            do {
                int it;
                ConeKotlinType restriction;
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerContext, (KotlinTypeMarker)returnType2, (KotlinTypeMarker)(restriction = this.substituteAllTypeParameters((ConeKotlinType)bounds.get(it = n++), $this$checkReturnType, overriddenSymbols2.get(it))), false, 8, null)) continue;
                Object $this$safeAs$iv2 = overriddenSymbols2.get(it).getFir();
                boolean $i$f$safeAs = false;
                Object e = $this$safeAs$iv2;
                if (!(e instanceof FirMemberDeclaration)) {
                    e = null;
                }
                return (FirMemberDeclaration)e;
            } while (n <= n2);
        }
        return null;
    }

    private final void checkFunction(FirSimpleFunction function2, DiagnosticReporter reporter, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        FirMemberDeclaration $this$isOverride$iv = function2;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        List<FirFunctionSymbol<?>> overriddenFunctionSymbols = this.retrieveDirectOverriddenOf(firTypeScope, function2);
        if (overriddenFunctionSymbols.isEmpty()) {
            return;
        }
        FirMemberDeclaration restriction = this.checkReturnType(function2, overriddenFunctionSymbols, typeCheckerContext, context2);
        FirMemberDeclaration firMemberDeclaration = restriction;
        if (firMemberDeclaration != null) {
            ConeKotlinType coneKotlinType;
            FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            FirMemberDeclaration it = firMemberDeclaration2;
            boolean bl3 = false;
            FirSourceElement firSourceElement = function2.getReturnTypeRef().getSource();
            FirTypeRef $this$coneType$iv = function2.getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl4 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            if ((coneKotlinType = coneKotlinType2) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            INSTANCE.reportMismatchOnFunction(reporter, firSourceElement, coneKotlinType.toString(), it);
        }
    }

    private final void checkProperty(FirProperty property2, DiagnosticReporter reporter, AbstractTypeCheckerContext typeCheckerContext, FirTypeScope firTypeScope, CheckerContext context2) {
        FirMemberDeclaration $this$isOverride$iv = property2;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        List<FirPropertySymbol> overriddenPropertySymbols = this.retrieveDirectOverriddenOf(firTypeScope, property2);
        if (overriddenPropertySymbols.isEmpty()) {
            return;
        }
        FirMemberDeclaration restriction = this.checkReturnType(property2, overriddenPropertySymbols, typeCheckerContext, context2);
        FirMemberDeclaration firMemberDeclaration = restriction;
        if (firMemberDeclaration != null) {
            FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
            boolean bl = false;
            boolean bl2 = false;
            FirMemberDeclaration it = firMemberDeclaration2;
            boolean bl3 = false;
            if (property2.isVar()) {
                ConeKotlinType coneKotlinType;
                FirSourceElement firSourceElement = property2.getReturnTypeRef().getSource();
                FirTypeRef $this$coneType$iv = property2.getReturnTypeRef();
                boolean $i$f$getConeType = false;
                Object $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeSafe = false;
                boolean bl4 = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                    coneKotlinType2 = null;
                }
                if ((coneKotlinType = coneKotlinType2) == null) {
                    $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                    $i$f$coneTypeSafe = false;
                    throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
                }
                INSTANCE.reportMismatchOnVariable(reporter, firSourceElement, coneKotlinType.toString(), it);
            } else {
                ConeKotlinType coneKotlinType;
                FirSourceElement firSourceElement = property2.getReturnTypeRef().getSource();
                FirTypeRef $this$coneType$iv = property2.getReturnTypeRef();
                boolean $i$f$getConeType = false;
                FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
                boolean $i$f$coneTypeSafe = false;
                boolean bl5 = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
                ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
                if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                    coneKotlinType3 = null;
                }
                if ((coneKotlinType = coneKotlinType3) == null) {
                    String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                    boolean bl6 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                INSTANCE.reportMismatchOnProperty(reporter, firSourceElement, coneKotlinType.toString(), it);
            }
        }
    }

    private final void reportMismatchOnFunction(DiagnosticReporter $this$reportMismatchOnFunction, FirSourceElement source, String type2, FirMemberDeclaration declaration) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportMismatchOnFunction.report((FirDiagnostic)FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE().on(it, type2, declaration));
        }
    }

    private final void reportMismatchOnProperty(DiagnosticReporter $this$reportMismatchOnProperty, FirSourceElement source, String type2, FirMemberDeclaration declaration) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportMismatchOnProperty.report((FirDiagnostic)FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE().on(it, type2, declaration));
        }
    }

    private final void reportMismatchOnVariable(DiagnosticReporter $this$reportMismatchOnVariable, FirSourceElement source, String type2, FirMemberDeclaration declaration) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$reportMismatchOnVariable.report((FirDiagnostic)FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE().on(it, type2, declaration));
        }
    }
}

