/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.ExecutionResult;
import org.jetbrains.kotlin.ir.interpreter.Next;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.Stack;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0002\b\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/JsPrimitives;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "equalTo", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "evaluate", "Lorg/jetbrains/kotlin/ir/interpreter/ExecutionResult;", "stack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Stack;", "interpret", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ExtensionFunctionType;", "ir.interpreter"})
public final class JsPrimitives
extends IntrinsicBase {
    @NotNull
    public static final JsPrimitives INSTANCE = new JsPrimitives();

    private JsPrimitives() {
        super(null);
    }

    @Override
    public boolean equalTo(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        String fqName2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(irFunction2));
        return Intrinsics.areEqual(fqName2, "kotlin.Long.<init>") || Intrinsics.areEqual(fqName2, "kotlin.Char.<init>");
    }

    @Override
    @NotNull
    public ExecutionResult evaluate(@NotNull IrFunction irFunction2, @NotNull Stack stack, @NotNull Function1<? super IrElement, ? extends ExecutionResult> interpret2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(interpret2, "interpret");
        String string2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(irFunction2));
        if (Intrinsics.areEqual(string2, "kotlin.Long.<init>")) {
            int low = StateKt.asInt(stack.getVariable(irFunction2.getValueParameters().get(0).getSymbol()).getState());
            int high = StateKt.asInt(stack.getVariable(irFunction2.getValueParameters().get(1).getSymbol()).getState());
            stack.pushReturnValue(UtilsKt.toState(((long)high << 32) + (long)low, irFunction2.getReturnType()));
        } else if (Intrinsics.areEqual(string2, "kotlin.Char.<init>")) {
            int value2 = StateKt.asInt(stack.getVariable(irFunction2.getValueParameters().get(0).getSymbol()).getState());
            stack.pushReturnValue(UtilsKt.toState(Character.valueOf((char)value2), irFunction2.getReturnType()));
        }
        return Next.INSTANCE;
    }
}

