/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.MethodSignatureMapper;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.PropertyReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbi;
import org.jetbrains.kotlin.backend.jvm.lower.inlineclasses.InlineClassAbiKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0003PQRB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u0014\u0010.\u001a\u00020/2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0014\u00100\u001a\u00020,2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0014\u00101\u001a\u00020/2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0014\u00102\u001a\u00020/2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0010\u00103\u001a\u00020(2\u0006\u00104\u001a\u000205H\u0016J$\u00106\u001a\u0002072\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020:H\u0002J\u0014\u0010;\u001a\u0002072\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020,H\u0016J\u0010\u0010?\u001a\u00020=2\u0006\u0010>\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020/2\u0006\u0010)\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020/2\u0006\u0010)\u001a\u00020DH\u0016J\u0014\u0010E\u001a\u00020\u0007*\u00020,2\u0006\u0010F\u001a\u00020\u0007H\u0002J9\u0010G\u001a\u00020\u0007*\u00020,2\u0006\u0010F\u001a\u00020\u00072#\u0010H\u001a\u001f\u0012\u0004\u0012\u00020J\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K\u0012\u0004\u0012\u00020/0I\u00a2\u0006\u0002\bMH\u0002J\u0018\u0010N\u001a\u00020/*\u00020J2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u0012\u0010O\u001a\u0004\u0018\u00010/*\u0006\u0012\u0002\b\u00030*H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0018\u00010\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0006\u0012\u0002\b\u00030\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\"*\u0006\u0012\u0002\b\u00030\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010 \u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "arrayItemGetter", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "currentClassData", "Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$ClassData;", "kPropertiesFieldType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "kPropertyStarType", "Lorg/jetbrains/kotlin/ir/types/impl/IrSimpleTypeImpl;", "signatureStringIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "useOptimizedSuperClass", "", "fakeGetterSignature", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getFakeGetterSignature", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)Ljava/lang/String;", "field", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "getField", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;)Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "getter", "getGetter", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;)Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "propertyContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getPropertyContainer", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "setter", "getSetter", "addConstructor", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "referenceClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "superClass", "cachedKProperty", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "createKPropertySubclass", "createReflectedKProperty", "createSpecializedKProperty", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "propertyReferenceKind", "Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$PropertyReferenceKind;", "mutable", "i", "", "propertyReferenceKindFor", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "addFakeOverride", "method", "addOverride", "buildBody", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lkotlin/ExtensionFunctionType;", "computeSignatureString", "getBoundReceiver", "ClassData", "PropertyInstance", "PropertyReferenceKind", "backend.jvm"})
final class PropertyReferenceLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrSimpleFunction arrayItemGetter;
    @NotNull
    private final IrSimpleFunctionSymbol signatureStringIntrinsic;
    @NotNull
    private final IrSimpleTypeImpl kPropertyStarType;
    @NotNull
    private final IrSimpleType kPropertiesFieldType;
    private final boolean useOptimizedSuperClass;
    @Nullable
    private ClassData currentClassData;

    /*
     * WARNING - void declaration
     */
    public PropertyReferenceLowering(@NotNull JvmBackendContext context2) {
        void $this$single$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions((IrClass)this.context.getIr().getSymbols().getArray().getOwner());
        PropertyReferenceLowering propertyReferenceLowering = this;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName().asString(), "get")) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var11_11 = single$iv;
        propertyReferenceLowering.arrayItemGetter = var11_11;
        this.signatureStringIntrinsic = this.context.getIr().getSymbols().getSignatureStringIntrinsic();
        this.kPropertyStarType = new IrSimpleTypeImpl(this.context.getIrBuiltIns().getKPropertyClass(), false, CollectionsKt.listOf(IrSimpleTypeImplKt.makeTypeProjection(this.context.getIrBuiltIns().getAnyNType(), Variance.OUT_VARIANCE)), CollectionsKt.emptyList(), null, 16, null);
        this.kPropertiesFieldType = IrTypesKt.createType(this.context.getIr().getSymbols().getArray(), false, CollectionsKt.listOf(IrSimpleTypeImplKt.makeTypeProjection(this.kPropertyStarType, Variance.OUT_VARIANCE)));
        this.useOptimizedSuperClass = this.context.getState().getGenerateOptimizedCallableReferenceSuperClasses();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunctionSymbol getGetter(IrMemberAccessExpression<?> $this$getter) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
        IrCallableReference irCallableReference = $this$getter instanceof IrPropertyReference ? (IrPropertyReference)$this$getter : null;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2 = irCallableReference == null ? null : ((IrPropertyReference)irCallableReference).getGetter();
        if (irSimpleFunctionSymbol2 == null) {
            IrCallableReference irCallableReference2 = irCallableReference = $this$getter instanceof IrLocalDelegatedPropertyReference ? (IrLocalDelegatedPropertyReference)$this$getter : null;
            irSimpleFunctionSymbol = irCallableReference == null ? null : ((IrLocalDelegatedPropertyReference)irCallableReference).getGetter();
        } else {
            irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
        }
        return irSimpleFunctionSymbol;
    }

    private final IrSimpleFunctionSymbol getSetter(IrMemberAccessExpression<?> $this$setter) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
        IrCallableReference irCallableReference = $this$setter instanceof IrPropertyReference ? (IrPropertyReference)$this$setter : null;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = irSimpleFunctionSymbol2 = irCallableReference == null ? null : ((IrPropertyReference)irCallableReference).getSetter();
        if (irSimpleFunctionSymbol2 == null) {
            IrCallableReference irCallableReference2 = irCallableReference = $this$setter instanceof IrLocalDelegatedPropertyReference ? (IrLocalDelegatedPropertyReference)$this$setter : null;
            irSimpleFunctionSymbol = irCallableReference == null ? null : ((IrLocalDelegatedPropertyReference)irCallableReference).getSetter();
        } else {
            irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
        }
        return irSimpleFunctionSymbol;
    }

    private final IrFieldSymbol getField(IrMemberAccessExpression<?> $this$field) {
        IrPropertyReference irPropertyReference = $this$field instanceof IrPropertyReference ? (IrPropertyReference)$this$field : null;
        return irPropertyReference == null ? null : irPropertyReference.getField();
    }

    private final IrDeclarationParent getPropertyContainer(IrMemberAccessExpression<?> $this$propertyContainer) {
        Object object;
        if ($this$propertyContainer instanceof IrLocalDelegatedPropertyReference) {
            IrClass irClass2;
            ClassData classData = this.currentClassData;
            IrClass irClass3 = irClass2 = classData == null ? null : classData.localPropertyOwner(((IrLocalDelegatedPropertyReference)$this$propertyContainer).getGetter());
            if (irClass2 == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("local property reference before declaration: ", RenderIrElementKt.render($this$propertyContainer)));
            }
            object = irClass2;
        } else {
            Object object2;
            IrDeclarationParent irDeclarationParent;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.getGetter($this$propertyContainer);
            IrDeclarationParent irDeclarationParent2 = irSimpleFunctionSymbol == null ? null : (irDeclarationParent = (object2 = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner()) == null ? null : object2.getParent());
            if (irDeclarationParent == null) {
                IrField irField;
                object2 = this.getField($this$propertyContainer);
                Object object3 = object2 == null ? null : (irSimpleFunctionSymbol = (irField = (IrField)object2.getOwner()) == null ? null : irField.getParent());
                if (irSimpleFunctionSymbol == null) {
                    object2 = Intrinsics.stringPlus("Property without getter or field: ", DumpIrTreeKt.dump$default($this$propertyContainer, false, 1, null));
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object2.toString());
                }
                object = irSimpleFunctionSymbol;
            } else {
                object = irDeclarationParent;
            }
        }
        return object;
    }

    private final String getFakeGetterSignature(IrField $this$fakeGetterSignature) {
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = $this$fakeGetterSignature.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        return stringBuilder2.append(JvmAbi.getterName(string2)).append("()").append(MethodSignatureMapper.mapReturnType$default(this.context.getMethodSignatureMapper(), $this$fakeGetterSignature, null, 2, null)).toString();
    }

    private final IrExpression computeSignatureString(IrBuilderWithScope $this$computeSignatureString, IrMemberAccessExpression<?> expression2) {
        IrProperty irProperty2;
        if (expression2 instanceof IrLocalDelegatedPropertyReference) {
            Integer n;
            ClassData classData = this.currentClassData;
            Integer n2 = n = classData == null ? null : classData.localPropertyIndex(((IrLocalDelegatedPropertyReference)expression2).getGetter());
            if (n == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("local property reference before declaration: ", RenderIrElementKt.render(expression2)));
            }
            int index2 = n;
            return ExpressionHelpersKt.irString($this$computeSignatureString, "<v#" + index2 + '>');
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.getGetter(expression2);
        if (irSimpleFunctionSymbol == null) {
            IrFieldSymbol irFieldSymbol = this.getField(expression2);
            Intrinsics.checkNotNull(irFieldSymbol);
            return ExpressionHelpersKt.irString($this$computeSignatureString, this.getFakeGetterSignature((IrField)irFieldSymbol.getOwner()));
        }
        IrSimpleFunctionSymbol getter2 = irSimpleFunctionSymbol;
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)getter2.getOwner()).getCorrespondingPropertySymbol();
        boolean needsDummySignature = Intrinsics.areEqual(irPropertySymbol == null ? null : ((irProperty2 = (IrProperty)irPropertySymbol.getOwner()) == null ? null : Boolean.valueOf(org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.needsAccessor(irProperty2, (IrSimpleFunction)getter2.getOwner()))), false) || InlineClassAbiKt.isInlineClassFieldGetter(getter2.getOwner()) && Intrinsics.areEqual(((IrSimpleFunction)getter2.getOwner()).getVisibility(), DescriptorVisibilities.INTERNAL);
        InlineClassAbi.UNMANGLED_FUNCTION_REFERENCE origin = needsDummySignature ? InlineClassAbi.UNMANGLED_FUNCTION_REFERENCE.INSTANCE : null;
        IrFunctionReferenceImpl reference = IrFunctionReferenceImpl.Companion.fromSymbolOwner(-1, -1, expression2.getType(), getter2, 0, getter2, origin);
        IrCall irCall = ExpressionHelpersKt.irCall($this$computeSignatureString, this.signatureStringIntrinsic);
        boolean bl = false;
        boolean bl2 = false;
        IrCall $this$computeSignatureString_u24lambda_u2d1 = irCall;
        boolean bl3 = false;
        $this$computeSignatureString_u24lambda_u2d1.putValueArgument(0, reference);
        return irCall;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addOverride(IrClass $this$addOverride, IrSimpleFunction method, Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression> buildBody) {
        void $this$addOverride_u24lambda_u2d5_u24lambda_u2d4;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrClass $this$addFunction$iv = $this$addOverride;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addOverride_u24lambda_u2d2 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
        boolean bl4 = false;
        IrElementBuilderKt.setSourceRange($this$addOverride_u24lambda_u2d2, $this$addOverride);
        $this$addOverride_u24lambda_u2d2.setName(method.getName());
        $this$addOverride_u24lambda_u2d2.setReturnType(method.getReturnType());
        $this$addOverride_u24lambda_u2d2.setVisibility(method.getVisibility());
        $this$addOverride_u24lambda_u2d2.setModality(Modality.OPEN);
        $this$addOverride_u24lambda_u2d2.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl5 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object object2 = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$addOverride_u24lambda_u2d5 = object2;
        boolean bl8 = false;
        Object $i$f$buildFun22 = $this$addOverride_u24lambda_u2d5;
        $i$f$buildFun22.setOverriddenSymbols(CollectionsKt.plus((Collection)$i$f$buildFun22.getOverriddenSymbols(), method.getSymbol()));
        $i$f$buildFun22 = $this$addOverride.getThisReceiver();
        Intrinsics.checkNotNull($i$f$buildFun22);
        ((IrFunction)$this$addOverride_u24lambda_u2d5).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)$i$f$buildFun22, (IrFunction)$this$addOverride_u24lambda_u2d5, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
        $i$f$buildFun22 = method.getValueParameters();
        Object object3 = $this$addOverride_u24lambda_u2d5;
        boolean $i$f$map = false;
        void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            object = destination$iv$iv;
            boolean bl9 = false;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, (IrFunction)$this$addOverride_u24lambda_u2d5, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null);
            object.add(irValueParameter2);
        }
        object = (List)destination$iv$iv;
        ((IrFunction)object3).setValueParameters((List<? extends IrValueParameter>)object);
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.getContext(), ((IrSimpleFunction)$this$addOverride_u24lambda_u2d5).getSymbol(), $this$addOverride_u24lambda_u2d5.getStartOffset(), $this$addOverride_u24lambda_u2d5.getEndOffset());
        boolean bl10 = false;
        boolean bl11 = false;
        destination$iv$iv = declarationIrBuilder;
        object3 = $this$addOverride_u24lambda_u2d5;
        boolean bl12 = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addOverride_u24lambda_u2d5_u24lambda_u2d4;
        IrValueParameter irValueParameter = ((IrFunction)$this$addOverride_u24lambda_u2d5).getDispatchReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter);
        object = ExpressionHelpersKt.irExprBody(irBuilderWithScope, buildBody.invoke((IrBuilderWithScope)$this$addOverride_u24lambda_u2d5_u24lambda_u2d4, CollectionsKt.plus((Collection)CollectionsKt.listOf(irValueParameter), (Iterable)((IrFunction)$this$addOverride_u24lambda_u2d5).getValueParameters())));
        ((IrFunction)object3).setBody((IrBody)object);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction addFakeOverride(IrClass $this$addFakeOverride, IrSimpleFunction method) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrClass $this$addFunction$iv = $this$addFakeOverride;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2d14$iv$iv$iv = irFunctionBuilder;
        boolean bl3 = false;
        IrFunctionBuilder $this$addFakeOverride_u24lambda_u2d6 = $this$buildFun_u24lambda_u2d14$iv$iv$iv;
        boolean bl4 = false;
        $this$addFakeOverride_u24lambda_u2d6.setName(method.getName());
        $this$addFakeOverride_u24lambda_u2d6.setReturnType(method.getReturnType());
        $this$addFakeOverride_u24lambda_u2d6.setVisibility(method.getVisibility());
        $this$addFakeOverride_u24lambda_u2d6.setFakeOverride(true);
        $this$addFakeOverride_u24lambda_u2d6.setOrigin(IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE);
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d14$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl5 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent($this$addFunction$iv);
        Object object = $this$buildFun$iv$iv$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$addFakeOverride_u24lambda_u2d8 = object;
        boolean bl8 = false;
        Object $i$f$buildFun22 = $this$addFakeOverride_u24lambda_u2d8;
        $i$f$buildFun22.setOverriddenSymbols(CollectionsKt.plus((Collection)$i$f$buildFun22.getOverriddenSymbols(), method.getSymbol()));
        $i$f$buildFun22 = $this$addFakeOverride.getThisReceiver();
        Intrinsics.checkNotNull($i$f$buildFun22);
        ((IrFunction)$this$addFakeOverride_u24lambda_u2d8).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)$i$f$buildFun22, (IrFunction)$this$addFakeOverride_u24lambda_u2d8, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
        $i$f$buildFun22 = method.getValueParameters();
        Object object2 = $this$addFakeOverride_u24lambda_u2d8;
        boolean $i$f$map = false;
        void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl9 = false;
            IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, (IrFunction)$this$addFakeOverride_u24lambda_u2d8, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null);
            collection.add(irValueParameter2);
        }
        collection = (List)destination$iv$iv;
        ((IrFunction)object2).setValueParameters((List<? extends IrValueParameter>)collection);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyReferenceKind propertyReferenceKind(IrCallableReference<?> expression2, boolean mutable, int i) {
        void $this$single$iv;
        boolean bl = 0 <= i ? i <= 2 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Incorrect number of receivers (" + i + ") for property reference: " + RenderIrElementKt.render(expression2);
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions((IrClass)this.context.getIr().getSymbols().getReflection().getOwner());
        IrClassSymbol irClassSymbol = this.context.getIr().getSymbols().getPropertyReferenceClass(mutable, i, true);
        IrClassSymbol irClassSymbol2 = this.context.getIr().getSymbols().getPropertyReferenceClass(mutable, i, false);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl5 = false;
            if (!Intrinsics.areEqual(it.getName().asString(), mutable ? Intrinsics.stringPlus("mutableProperty", i) : Intrinsics.stringPlus("property", i))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var16_18 = single$iv;
        IrFunction irFunction2 = var16_18;
        IrClassSymbol irClassSymbol3 = irClassSymbol;
        IrClassSymbol irClassSymbol4 = irClassSymbol2;
        return new PropertyReferenceKind(irClassSymbol4, irClassSymbol3, irFunction2);
    }

    private final PropertyReferenceKind propertyReferenceKindFor(IrCallableReference<?> expression2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        boolean bl;
        IrDeclarationBase irDeclarationBase;
        Object object;
        Object object2;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.getGetter((IrMemberAccessExpression)expression2);
        if (irSimpleFunctionSymbol2 == null) {
            object2 = null;
        } else {
            object = (IrSimpleFunction)irSimpleFunctionSymbol2.getOwner();
            if (object == null) {
                object2 = null;
            } else {
                irDeclarationBase = object;
                boolean bl2 = false;
                bl = false;
                IrSimpleFunction it = irDeclarationBase;
                boolean bl3 = false;
                IrExpression[] irExpressionArray = new IrExpression[]{expression2.getDispatchReceiver(), expression2.getExtensionReceiver()};
                int boundReceivers = CollectionsKt.listOfNotNull(irExpressionArray).size();
                IrValueParameter[] irValueParameterArray = new IrValueParameter[]{it.getDispatchReceiverParameter(), it.getExtensionReceiverParameter()};
                int needReceivers = CollectionsKt.listOfNotNull(irValueParameterArray).size();
                boolean bl4 = boundReceivers < 2 && (expression2.getExtensionReceiver() == null || needReceivers < 2);
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string2 = Intrinsics.stringPlus("Property reference with two receivers is not supported: ", RenderIrElementKt.render(expression2));
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                object2 = this.propertyReferenceKind(expression2, this.getSetter((IrMemberAccessExpression)expression2) != null, needReceivers - boundReceivers);
            }
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = object2;
        if (irSimpleFunctionSymbol3 == null) {
            PropertyReferenceKind propertyReferenceKind;
            object = this.getField((IrMemberAccessExpression)expression2);
            if (object == null) {
                propertyReferenceKind = null;
            } else {
                irDeclarationBase = (IrField)object.getOwner();
                if (irDeclarationBase == null) {
                    propertyReferenceKind = null;
                } else {
                    IrDeclarationBase irDeclarationBase2 = irDeclarationBase;
                    bl = false;
                    boolean bl8 = false;
                    IrDeclarationBase it = irDeclarationBase2;
                    boolean bl9 = false;
                    propertyReferenceKind = this.propertyReferenceKind(expression2, !((IrField)it).isFinal(), ((IrField)it).isStatic() || expression2.getDispatchReceiver() != null ? 0 : 1);
                }
            }
            irSimpleFunctionSymbol2 = propertyReferenceKind;
            if (irSimpleFunctionSymbol2 == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("property has no getter and no field: ", DumpIrTreeKt.dump$default(expression2, false, 1, null)));
            }
            irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
        } else {
            irSimpleFunctionSymbol = irSimpleFunctionSymbol3;
        }
        return irSimpleFunctionSymbol;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.transformChildrenVoid(irFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        ClassData data;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        this.currentClassData = data = new ClassData(declaration2, this.currentClassData);
        this.transformChildrenVoid(declaration2);
        this.currentClassData = data.getParent();
        Map<IrAttributeContainer, List<IrLocalDelegatedPropertySymbol>> map = data.getKProperties();
        boolean bl = false;
        if (!map.isEmpty()) {
            void $this$visitClassNew_u24lambda_u2d17_u24lambda_u2d16;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$visitClassNew_u24lambda_u2d17;
            map = data.getKPropertiesField();
            bl = false;
            boolean bl2 = false;
            Map<IrAttributeContainer, List<IrLocalDelegatedPropertySymbol>> map2 = map;
            int n = 0;
            List<IrDeclaration> list2 = declaration2.getDeclarations();
            boolean bl3 = false;
            $this$visitClassNew_u24lambda_u2d17.setParent(declaration2);
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(this.getContext(), declaration2.getSymbol(), 0, 0, 6, null);
            boolean bl4 = false;
            boolean bl5 = false;
            JvmIrBuilder jvmIrBuilder2 = jvmIrBuilder;
            void var12_17 = $this$visitClassNew_u24lambda_u2d17;
            boolean bl6 = false;
            Iterable $this$sortedBy$iv = data.getKProperties().values();
            boolean $i$f$sortedBy = false;
            boolean bl7 = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PropertyInstance it = (PropertyInstance)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getIndex());
                    it = (PropertyInstance)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getIndex();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)n);
                }
            });
            boolean $i$f$map = false;
            void var16_22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PropertyInstance propertyInstance = (PropertyInstance)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                IrExpression irExpression = it.getInitializer();
                collection.add(irExpression);
            }
            List initializers = (List)destination$iv$iv;
            IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$visitClassNew_u24lambda_u2d17_u24lambda_u2d16, IrArrayBuilderKt.irArrayOf((JvmIrBuilder)$this$visitClassNew_u24lambda_u2d17_u24lambda_u2d16, this.kPropertiesFieldType, initializers));
            var12_17.setInitializer(irExpressionBody);
            Unit unit = Unit.INSTANCE;
            list2.add(n, (IrDeclaration)((Object)map));
        }
        map = data.getLocalProperties();
        bl = false;
        if (!map.isEmpty()) {
            map = this.context.getLocalDelegatedProperties();
            IrAttributeContainer irAttributeContainer = declaration2.getAttributeOwnerId();
            List<IrLocalDelegatedPropertySymbol> list3 = data.getLocalProperties();
            boolean bl9 = false;
            map.put(irAttributeContainer, list3);
        }
        return declaration2;
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        ClassData classData = this.currentClassData;
        Intrinsics.checkNotNull(classData);
        classData.rememberLocalProperty(declaration2);
        return super.visitLocalDelegatedProperty(declaration2);
    }

    @Override
    @NotNull
    public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return this.cachedKProperty(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return this.cachedKProperty(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression cachedKProperty(IrCallableReference<?> expression2) {
        Object object;
        void $this$getOrPut$iv;
        this.transformChildrenVoid(expression2);
        if (!Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.PROPERTY_REFERENCE_FOR_DELEGATE.INSTANCE)) {
            return this.createSpecializedKProperty(expression2);
        }
        Object object2 = this.currentClassData;
        if (object2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus("property reference not in class: ", RenderIrElementKt.render(expression2)));
        }
        ClassData data = object2;
        BackendContext backendContext = this.context;
        object2 = this.getCurrentScope();
        Intrinsics.checkNotNull(object2);
        object2 = LowerUtilsKt.createIrBuilder(backendContext, ((ScopeWithIr)object2).getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        Object $this$cachedKProperty_u24lambda_u2d20 = object2;
        boolean bl3 = false;
        Map<IrSymbol, PropertyInstance> map = data.getKProperties();
        Object key$iv = expression2.getSymbol();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl4 = false;
            PropertyInstance answer$iv = new PropertyInstance(this.createReflectedKProperty(expression2), data.getKProperties().size());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        PropertyInstance propertyInstance = (PropertyInstance)object;
        int index2 = propertyInstance.component2();
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$cachedKProperty_u24lambda_u2d20, this.arrayItemGetter);
        boolean bl5 = false;
        boolean bl6 = false;
        IrFunctionAccessExpression $this$cachedKProperty_u24lambda_u2d20_u24lambda_u2d19 = irFunctionAccessExpression;
        boolean bl7 = false;
        $this$cachedKProperty_u24lambda_u2d20_u24lambda_u2d19.setDispatchReceiver(ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$cachedKProperty_u24lambda_u2d20, null, data.getKPropertiesField()));
        $this$cachedKProperty_u24lambda_u2d20_u24lambda_u2d19.putValueArgument(0, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$cachedKProperty_u24lambda_u2d20, index2, null, 2, null));
        return irFunctionAccessExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createReflectedKProperty(IrCallableReference<?> expression2) {
        void $this$createReflectedKProperty_u24lambda_u2d25_u24lambda_u2d24_u24lambda_u2d23;
        boolean bl = expression2.getDispatchReceiver() == null && expression2.getExtensionReceiver() == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("cannot create a reflected KProperty if the reference has a bound receiver: ", RenderIrElementKt.render(expression2));
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        PropertyReferenceKind referenceKind = this.propertyReferenceKindFor(expression2);
        BackendContext backendContext = this.context;
        Object object = this.getCurrentScope();
        Intrinsics.checkNotNull(object);
        object = LowerUtilsKt.createIrBuilder(backendContext, ((ScopeWithIr)object).getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl4 = false;
        boolean bl5 = false;
        Object $this$createReflectedKProperty_u24lambda_u2d25 = object;
        boolean bl6 = false;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createReflectedKProperty_u24lambda_u2d25, referenceKind.getWrapper());
        boolean bl7 = false;
        boolean bl8 = false;
        IrFunctionAccessExpression $this$createReflectedKProperty_u24lambda_u2d25_u24lambda_u2d24 = irFunctionAccessExpression;
        boolean bl9 = false;
        Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(referenceKind.getImplSymbol());
        boolean $i$f$single = false;
        IrConstructorSymbol single$iv = null;
        boolean found$iv22 = false;
        Iterator<IrConstructorSymbol> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrConstructorSymbol element$iv;
            IrConstructorSymbol it = element$iv = iterator2.next();
            boolean bl10 = false;
            if (!(((IrConstructor)it.getOwner()).getValueParameters().size() == 3)) continue;
            if (found$iv22) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructorSymbol constructor2 = single$iv;
        IrConstructorCall irConstructorCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createReflectedKProperty_u24lambda_u2d25, constructor2);
        boolean bl11 = false;
        boolean bl12 = false;
        IrConstructorCall found$iv22 = irConstructorCall;
        int n = 0;
        IrFunctionAccessExpression irFunctionAccessExpression2 = $this$createReflectedKProperty_u24lambda_u2d25_u24lambda_u2d24;
        boolean bl13 = false;
        $this$createReflectedKProperty_u24lambda_u2d25_u24lambda_u2d24_u24lambda_u2d23.putValueArgument(0, FunctionReferenceLowering.Companion.calculateOwner$backend_jvm((IrBuilderWithScope)$this$createReflectedKProperty_u24lambda_u2d25, this.getPropertyContainer((IrMemberAccessExpression)expression2), this.getContext()));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createReflectedKProperty_u24lambda_u2d25;
        String string3 = expression2.getReferencedName().asString();
        Intrinsics.checkNotNullExpressionValue(string3, "expression.referencedName.asString()");
        $this$createReflectedKProperty_u24lambda_u2d25_u24lambda_u2d24_u24lambda_u2d23.putValueArgument(1, ExpressionHelpersKt.irString(irBuilderWithScope, string3));
        $this$createReflectedKProperty_u24lambda_u2d25_u24lambda_u2d24_u24lambda_u2d23.putValueArgument(2, this.computeSignatureString((IrBuilderWithScope)$this$createReflectedKProperty_u24lambda_u2d25, (IrMemberAccessExpression)expression2));
        Unit unit = Unit.INSTANCE;
        irFunctionAccessExpression2.putValueArgument(n, irConstructorCall);
        return irFunctionAccessExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createSpecializedKProperty(IrCallableReference<?> expression2) {
        void this_$iv$iv;
        IrClass referenceClass2 = this.createKPropertySubclass(expression2);
        BackendContext backendContext = this.context;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull(scopeWithIr);
        IrBuilderWithScope $this$irBlock_u24default$iv = LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$createSpecializedKProperty_u24lambda_u2d28 = this_$iv$iv;
        boolean bl = false;
        $this$createSpecializedKProperty_u24lambda_u2d28.unaryPlus(referenceClass2);
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createSpecializedKProperty_u24lambda_u2d28, SequencesKt.single(IrUtilsKt.getConstructors(referenceClass2)));
        boolean bl2 = false;
        boolean bl3 = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression;
        void var17_17 = $this$createSpecializedKProperty_u24lambda_u2d28;
        boolean bl4 = false;
        IrExpression irExpression = this.getBoundReceiver(expression2);
        if (irExpression != null) {
            void $this$createSpecializedKProperty_u24lambda_u2d28_u24lambda_u2d27;
            IrExpression irExpression2 = irExpression;
            boolean bl5 = false;
            boolean bl6 = false;
            IrExpression it = irExpression2;
            boolean bl7 = false;
            $this$createSpecializedKProperty_u24lambda_u2d28_u24lambda_u2d27.putValueArgument(0, it);
        }
        Unit unit = Unit.INSTANCE;
        var17_17.unaryPlus(irFunctionAccessExpression);
        return this_$iv$iv.doBuild();
    }

    private final IrClass createKPropertySubclass(IrCallableReference<?> expression2) {
        IrField field;
        IrSimpleFunction irSimpleFunction;
        Object object;
        IrSimpleFunction set;
        IrSimpleFunction get2;
        IrField backingField2;
        IrExpression boundReceiver;
        IrClass referenceClass2;
        block23: {
            Iterator<IrSimpleFunction> iterator2;
            Iterator<IrSimpleFunction> iterator3;
            IrClass superClass2;
            block22: {
                IrProperty irProperty2;
                block21: {
                    IrDeclarationBase it;
                    Iterator<IrDeclarationBase> iterator4;
                    boolean found$iv;
                    Object single$iv;
                    boolean $i$f$single;
                    Sequence<IrDeclarationBase> $this$single$iv;
                    PropertyReferenceKind kind = this.propertyReferenceKindFor(expression2);
                    superClass2 = this.useOptimizedSuperClass ? (IrClass)kind.getImplSymbol().getOwner() : (IrClass)kind.getInterfaceSymbol().getOwner();
                    Object $this$buildClass$iv = this.context.getIrFactory();
                    boolean $i$f$buildClass = false;
                    IrClassBuilder irClassBuilder = new IrClassBuilder();
                    boolean bl = false;
                    boolean bl2 = false;
                    Iterator<IrSimpleFunction> $this$buildClass_u24lambda_u2d1$iv = irClassBuilder;
                    boolean bl3 = false;
                    IrClassBuilder $this$createKPropertySubclass_u24lambda_u2d29 = $this$buildClass_u24lambda_u2d1$iv;
                    boolean bl4 = false;
                    IrElementBuilderKt.setSourceRange($this$createKPropertySubclass_u24lambda_u2d29, expression2);
                    iterator3 = SpecialNames.NO_NAME_PROVIDED;
                    Intrinsics.checkNotNullExpressionValue(iterator3, "NO_NAME_PROVIDED");
                    $this$createKPropertySubclass_u24lambda_u2d29.setName((Name)((Object)iterator3));
                    $this$createKPropertySubclass_u24lambda_u2d29.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE);
                    iterator3 = DescriptorVisibilities.LOCAL;
                    Intrinsics.checkNotNullExpressionValue(iterator3, "LOCAL");
                    $this$createKPropertySubclass_u24lambda_u2d29.setVisibility((DescriptorVisibility)((Object)iterator3));
                    $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)((Object)$this$buildClass_u24lambda_u2d1$iv));
                    $i$f$buildClass = false;
                    boolean bl5 = false;
                    Object $this$createKPropertySubclass_u24lambda_u2d30 = $this$buildClass$iv;
                    boolean bl6 = false;
                    $this$buildClass_u24lambda_u2d1$iv = this.getCurrentDeclarationParent();
                    Intrinsics.checkNotNull($this$buildClass_u24lambda_u2d1$iv);
                    $this$createKPropertySubclass_u24lambda_u2d30.setParent((IrDeclarationParent)((Object)$this$buildClass_u24lambda_u2d1$iv));
                    ((IrClass)$this$createKPropertySubclass_u24lambda_u2d30).setSuperTypes(CollectionsKt.listOf(IrUtilsKt.getDefaultType(superClass2)));
                    org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$createKPropertySubclass_u24lambda_u2d30);
                    referenceClass2 = (IrClass)IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$buildClass$iv, expression2);
                    this.addConstructor(expression2, referenceClass2, superClass2);
                    if (!this.useOptimizedSuperClass) {
                        Sequence<IrSimpleFunction> $this$single$iv2 = IrUtilsKt.getFunctions(superClass2);
                        boolean $i$f$single2 = false;
                        IrSimpleFunction single$iv2 = null;
                        boolean found$iv2 = false;
                        $this$buildClass_u24lambda_u2d1$iv = $this$single$iv2.iterator();
                        while ($this$buildClass_u24lambda_u2d1$iv.hasNext()) {
                            IrSimpleFunction element$iv;
                            IrSimpleFunction it2 = element$iv = $this$buildClass_u24lambda_u2d1$iv.next();
                            boolean bl7 = false;
                            if (!Intrinsics.areEqual(it2.getName().asString(), "getName")) continue;
                            if (found$iv2) {
                                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv2 = element$iv;
                            found$iv2 = true;
                        }
                        if (!found$iv2) {
                            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        IrSimpleFunction getName = single$iv2;
                        Sequence<IrSimpleFunction> $this$single$iv3 = IrUtilsKt.getFunctions(superClass2);
                        boolean $i$f$single3 = false;
                        IrSimpleFunction single$iv3 = null;
                        boolean found$iv3 = false;
                        Iterator<IrSimpleFunction> element$iv = $this$single$iv3.iterator();
                        while (element$iv.hasNext()) {
                            IrSimpleFunction element$iv2;
                            IrSimpleFunction it3 = element$iv2 = element$iv.next();
                            boolean bl8 = false;
                            if (!Intrinsics.areEqual(it3.getName().asString(), "getOwner")) continue;
                            if (found$iv3) {
                                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv3 = element$iv2;
                            found$iv3 = true;
                        }
                        if (!found$iv3) {
                            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        IrSimpleFunction getOwner = single$iv3;
                        $this$single$iv = IrUtilsKt.getFunctions(superClass2);
                        $i$f$single = false;
                        single$iv = null;
                        found$iv = false;
                        iterator4 = $this$single$iv.iterator();
                        while (iterator4.hasNext()) {
                            IrDeclarationBase element$iv3 = iterator4.next();
                            it = (IrSimpleFunction)element$iv3;
                            boolean bl9 = false;
                            if (!Intrinsics.areEqual(it.getName().asString(), "getSignature")) continue;
                            if (found$iv) {
                                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                            }
                            single$iv = element$iv3;
                            found$iv = true;
                        }
                        if (!found$iv) {
                            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                        }
                        IrSimpleFunction getSignature = (IrSimpleFunction)single$iv;
                        this.addOverride(referenceClass2, getName, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>(expression2){
                            final /* synthetic */ IrCallableReference<?> $expression;
                            {
                                this.$expression = $expression;
                                super(2);
                            }

                            @NotNull
                            public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> it) {
                                Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                                Intrinsics.checkNotNullParameter(it, "it");
                                String string2 = this.$expression.getReferencedName().asString();
                                Intrinsics.checkNotNullExpressionValue(string2, "expression.referencedName.asString()");
                                return ExpressionHelpersKt.irString($this$addOverride, string2);
                            }
                        });
                        this.addOverride(referenceClass2, getOwner, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>(this, expression2){
                            final /* synthetic */ PropertyReferenceLowering this$0;
                            final /* synthetic */ IrCallableReference<?> $expression;
                            {
                                this.this$0 = $receiver;
                                this.$expression = $expression;
                                super(2);
                            }

                            @NotNull
                            public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> it) {
                                Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                                Intrinsics.checkNotNullParameter(it, "it");
                                return FunctionReferenceLowering.Companion.calculateOwner$backend_jvm($this$addOverride, PropertyReferenceLowering.access$getPropertyContainer(this.this$0, this.$expression), this.this$0.getContext());
                            }
                        });
                        this.addOverride(referenceClass2, getSignature, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>(this, expression2){
                            final /* synthetic */ PropertyReferenceLowering this$0;
                            final /* synthetic */ IrCallableReference<?> $expression;
                            {
                                this.this$0 = $receiver;
                                this.$expression = $expression;
                                super(2);
                            }

                            @NotNull
                            public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> it) {
                                Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                                Intrinsics.checkNotNullParameter(it, "it");
                                return PropertyReferenceLowering.access$computeSignatureString(this.this$0, $this$addOverride, this.$expression);
                            }
                        });
                    }
                    boundReceiver = this.getBoundReceiver(expression2);
                    $this$single$iv = IrUtilsKt.getProperties(superClass2);
                    $i$f$single = false;
                    single$iv = null;
                    found$iv = false;
                    iterator4 = $this$single$iv.iterator();
                    while (iterator4.hasNext()) {
                        IrProperty element$iv = iterator4.next();
                        it = element$iv;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual(it.getName().asString(), "receiver")) continue;
                        if (found$iv) {
                            throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    IrField getSignature = ((IrProperty)single$iv).getBackingField();
                    Intrinsics.checkNotNull(getSignature);
                    backingField2 = getSignature;
                    $this$single$iv = IrUtilsKt.getFunctions(superClass2);
                    $i$f$single = false;
                    single$iv = $this$single$iv;
                    boolean bl11 = false;
                    iterator4 = single$iv.iterator();
                    while (iterator4.hasNext()) {
                        IrProperty irProperty3 = iterator4.next();
                        it = (IrSimpleFunction)((Object)irProperty3);
                        boolean bl12 = false;
                        if (!Intrinsics.areEqual(it.getName().asString(), "get")) continue;
                        irProperty2 = irProperty3;
                        break block21;
                    }
                    irProperty2 = null;
                }
                get2 = (IrSimpleFunction)((Object)irProperty2);
                Sequence<IrSimpleFunction> $i$f$single = IrUtilsKt.getFunctions(superClass2);
                boolean single$iv = false;
                Sequence<IrSimpleFunction> sequence2 = $i$f$single;
                boolean bl = false;
                Iterator<IrSimpleFunction> iterator5 = sequence2.iterator();
                while (iterator5.hasNext()) {
                    iterator3 = iterator5.next();
                    IrSimpleFunction it = (IrSimpleFunction)((Object)iterator3);
                    boolean bl13 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), "set")) continue;
                    iterator2 = iterator3;
                    break block22;
                }
                iterator2 = null;
            }
            set = (IrSimpleFunction)((Object)iterator2);
            Sequence<IrSimpleFunction> single$iv = IrUtilsKt.getFunctions(superClass2);
            boolean bl = false;
            object = single$iv;
            boolean bl14 = false;
            iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                IrSimpleFunction irSimpleFunction2;
                IrSimpleFunction it = irSimpleFunction2 = iterator3.next();
                boolean bl15 = false;
                if (!Intrinsics.areEqual(it.getName().asString(), "invoke")) continue;
                irSimpleFunction = irSimpleFunction2;
                break block23;
            }
            irSimpleFunction = null;
        }
        IrSimpleFunction invoke2 = irSimpleFunction;
        IrBindableSymbol<PropertyDescriptor, IrField> irBindableSymbol = this.getField((IrMemberAccessExpression)expression2);
        IrField irField = field = irBindableSymbol == null ? null : (IrField)irBindableSymbol.getOwner();
        if (field == null) {
            irBindableSymbol = this.getGetter((IrMemberAccessExpression)expression2);
            if (irBindableSymbol != null && (object = (IrSimpleFunction)((Object)irBindableSymbol.getOwner())) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl16 = false;
                Object getter2 = object2;
                boolean bl17 = false;
                Intrinsics.checkNotNull(get2);
                this.addOverride(referenceClass2, get2, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>((IrSimpleFunction)getter2, boundReceiver, expression2, backingField2){
                    final /* synthetic */ IrSimpleFunction $getter;
                    final /* synthetic */ IrExpression $boundReceiver;
                    final /* synthetic */ IrCallableReference<?> $expression;
                    final /* synthetic */ IrField $backingField;
                    {
                        this.$getter = $getter;
                        this.$boundReceiver = $boundReceiver;
                        this.$expression = $expression;
                        this.$backingField = $backingField;
                        super(2);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> arguments2) {
                        Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                        Intrinsics.checkNotNullParameter(arguments2, "arguments");
                        IrCall irCall = ExpressionHelpersKt.irGet($this$addOverride, this.$getter.getReturnType(), null, this.$getter.getSymbol());
                        IrExpression irExpression = this.$boundReceiver;
                        IrCallableReference<?> irCallableReference = this.$expression;
                        IrField irField = this.$backingField;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrCall $this$invoke_u24lambda_u2d0 = irCall;
                        boolean bl3 = false;
                        PropertyReferenceLowering.access$createKPropertySubclass$setCallArguments($this$addOverride, irExpression, irCallableReference, irField, $this$invoke_u24lambda_u2d0, arguments2);
                        return irCall;
                    }
                });
                Intrinsics.checkNotNull(invoke2);
                this.addFakeOverride(referenceClass2, invoke2);
            }
            if ((irBindableSymbol = this.getSetter((IrMemberAccessExpression)expression2)) != null && (object = (IrSimpleFunction)((Object)irBindableSymbol.getOwner())) != null) {
                Object object3 = object;
                boolean bl = false;
                boolean bl18 = false;
                Object setter2 = object3;
                boolean bl19 = false;
                Intrinsics.checkNotNull(set);
                this.addOverride(referenceClass2, set, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>((IrSimpleFunction)setter2, boundReceiver, expression2, backingField2){
                    final /* synthetic */ IrSimpleFunction $setter;
                    final /* synthetic */ IrExpression $boundReceiver;
                    final /* synthetic */ IrCallableReference<?> $expression;
                    final /* synthetic */ IrField $backingField;
                    {
                        this.$setter = $setter;
                        this.$boundReceiver = $boundReceiver;
                        this.$expression = $expression;
                        this.$backingField = $backingField;
                        super(2);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> arguments2) {
                        Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                        Intrinsics.checkNotNullParameter(arguments2, "arguments");
                        IrCall irCall = ExpressionHelpersKt.irSet($this$addOverride, this.$setter.getReturnType(), null, this.$setter.getSymbol(), ExpressionHelpersKt.irGet($this$addOverride, CollectionsKt.last(arguments2)));
                        IrExpression irExpression = this.$boundReceiver;
                        IrCallableReference<?> irCallableReference = this.$expression;
                        IrField irField = this.$backingField;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrCall $this$invoke_u24lambda_u2d0 = irCall;
                        boolean bl3 = false;
                        PropertyReferenceLowering.access$createKPropertySubclass$setCallArguments($this$addOverride, irExpression, irCallableReference, irField, $this$invoke_u24lambda_u2d0, arguments2);
                        return irCall;
                    }
                });
            }
        } else {
            Intrinsics.checkNotNull(get2);
            this.addOverride(referenceClass2, get2, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>(field, expression2, backingField2){
                final /* synthetic */ IrField $field;
                final /* synthetic */ IrCallableReference<?> $expression;
                final /* synthetic */ IrField $backingField;
                {
                    this.$field = $field;
                    this.$expression = $expression;
                    this.$backingField = $backingField;
                    super(2);
                }

                @NotNull
                public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> arguments2) {
                    Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                    Intrinsics.checkNotNullParameter(arguments2, "arguments");
                    return ExpressionHelpersKt.irGetField($this$addOverride, PropertyReferenceLowering.access$createKPropertySubclass$fieldReceiver($this$addOverride, this.$field, this.$expression, this.$backingField, arguments2), this.$field);
                }
            });
            if (!field.isFinal()) {
                Intrinsics.checkNotNull(set);
                this.addOverride(referenceClass2, set, (Function2<? super IrBuilderWithScope, ? super List<? extends IrValueParameter>, ? extends IrExpression>)new Function2<IrBuilderWithScope, List<? extends IrValueParameter>, IrExpression>(field, expression2, backingField2){
                    final /* synthetic */ IrField $field;
                    final /* synthetic */ IrCallableReference<?> $expression;
                    final /* synthetic */ IrField $backingField;
                    {
                        this.$field = $field;
                        this.$expression = $expression;
                        this.$backingField = $backingField;
                        super(2);
                    }

                    @NotNull
                    public final IrExpression invoke(@NotNull IrBuilderWithScope $this$addOverride, @NotNull List<? extends IrValueParameter> arguments2) {
                        Intrinsics.checkNotNullParameter($this$addOverride, "$this$addOverride");
                        Intrinsics.checkNotNullParameter(arguments2, "arguments");
                        return ExpressionHelpersKt.irSetField($this$addOverride, PropertyReferenceLowering.access$createKPropertySubclass$fieldReceiver($this$addOverride, this.$field, this.$expression, this.$backingField, arguments2), this.$field, ExpressionHelpersKt.irGet($this$addOverride, CollectionsKt.last(arguments2)));
                    }
                });
            }
        }
        return referenceClass2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addConstructor(IrCallableReference<?> expression2, IrClass referenceClass2, IrClass superClass2) {
        void $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45;
        void this_$iv$iv;
        void startOffset$iv;
        void $this$irBlockBody$iv;
        void $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47;
        boolean hasBoundReceiver = this.getBoundReceiver(expression2) != null;
        int numOfSuperArgs = (hasBoundReceiver ? 1 : 0) + (this.useOptimizedSuperClass ? 4 : 0);
        Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors(superClass2);
        boolean $i$f$single = false;
        IrConstructor single$iv = null;
        boolean found$iv = false;
        Object object = $this$single$iv.iterator();
        while (object.hasNext()) {
            IrConstructor element$iv;
            IrConstructor it = element$iv = object.next();
            boolean bl = false;
            if (!(it.getValueParameters().size() == numOfSuperArgs)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superConstructor = single$iv;
        if (!this.useOptimizedSuperClass) {
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.addSimpleDelegatingConstructor$default(referenceClass2, superConstructor, this.context.getIrBuiltIns(), true, null, 8, null);
            return;
        }
        IrClass $this$addConstructor$iv = referenceClass2;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        object = new IrFunctionBuilder();
        boolean element$iv = false;
        boolean it = false;
        Object $this$buildConstructor_u24lambda_u2d18$iv$iv = object;
        boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = false;
        Object $this$addConstructor_u24lambda_u2d19$iv = $this$buildConstructor_u24lambda_u2d18$iv$iv;
        boolean bl = false;
        Object $this$addConstructor_u24lambda_u2d44 = $this$addConstructor_u24lambda_u2d19$iv;
        int n = 0;
        ((IrDeclarationBuilder)$this$addConstructor_u24lambda_u2d44).setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
        ((IrFunctionBuilder)$this$addConstructor_u24lambda_u2d44).setPrimary(true);
        ((IrFunctionBuilder)$this$addConstructor_u24lambda_u2d19$iv).setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        IrConstructor irConstructor2 = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d18$iv$iv);
        $i$f$buildConstructor = false;
        boolean bl2 = false;
        IrConstructor constructor$iv = irConstructor2;
        boolean bl3 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent($this$addConstructor$iv);
        IrConstructor irConstructor3 = irConstructor2;
        boolean bl4 = false;
        boolean bl5 = false;
        IrConstructor $this$addConstructor_u24lambda_u2d48 = irConstructor3;
        boolean bl6 = false;
        if (hasBoundReceiver) {
            DeclarationBuildersKt.addValueParameter$default((IrFunction)$this$addConstructor_u24lambda_u2d48, "receiver", this.getContext().getIrBuiltIns().getAnyNType(), null, 4, null);
        }
        JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(this.getContext(), $this$addConstructor_u24lambda_u2d48.getSymbol(), 0, 0, 6, null);
        boolean bl7 = false;
        boolean bl8 = false;
        JvmIrBuilder $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = jvmIrBuilder;
        IrConstructor irConstructor4 = $this$addConstructor_u24lambda_u2d48;
        boolean bl9 = false;
        $this$addConstructor_u24lambda_u2d44 = (IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47;
        n = $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47.getStartOffset();
        int endOffset$iv = $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46 = this_$iv$iv;
        boolean bl10 = false;
        IrDelegatingConstructorCall irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46, superConstructor);
        boolean bl11 = false;
        boolean bl12 = false;
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall;
        void var30_39 = $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46;
        boolean bl13 = false;
        int index2 = 0;
        if (hasBoundReceiver) {
            int n2 = index2;
            index2 = n2 + 1;
            $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.putValueArgument(n2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46, CollectionsKt.first($this$addConstructor_u24lambda_u2d48.getValueParameters())));
        }
        IrDeclaration callee = (IrDeclaration)expression2.getSymbol().getOwner();
        IrExpression owner = FunctionReferenceLowering.Companion.calculateOwnerKClass$backend_jvm((IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46, this.getPropertyContainer((IrMemberAccessExpression)expression2), $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47.getBackendContext());
        int n3 = index2;
        index2 = n3 + 1;
        $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.putValueArgument(n3, FunctionReferenceLowering.Companion.kClassToJavaClass$backend_jvm((IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46, owner, $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47.getBackendContext()));
        n3 = index2;
        index2 = n3 + 1;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46;
        String string2 = expression2.getReferencedName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "expression.referencedName.asString()");
        $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.putValueArgument(n3, ExpressionHelpersKt.irString(irBuilderWithScope, string2));
        int n4 = index2;
        index2 = n4 + 1;
        $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.putValueArgument(n4, this.computeSignatureString((IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46, (IrMemberAccessExpression)expression2));
        $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46_u24lambda_u2d45.putValueArgument(index2, ExpressionHelpersKt.irInt$default((IrBuilderWithScope)$this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46, FunctionReferenceLowering.Companion.getCallableReferenceTopLevelFlag$backend_jvm(callee), null, 2, null));
        Unit unit = Unit.INSTANCE;
        var30_39.unaryPlus(irDelegatingConstructorCall);
        $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46.unaryPlus(new IrInstanceInitializerCallImpl($this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46.getStartOffset(), $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46.getEndOffset(), referenceClass2.getSymbol(), $this$addConstructor_u24lambda_u2d48_u24lambda_u2d47_u24lambda_u2d46.getContext().getIrBuiltIns().getUnitType()));
        IrBlockBody irBlockBody = this_$iv$iv.doBuild();
        irConstructor4.setBody(irBlockBody);
    }

    private final IrExpression getBoundReceiver(IrCallableReference<?> $this$getBoundReceiver) {
        IrExpression irExpression;
        IrSymbolOwner callee = $this$getBoundReceiver.getSymbol().getOwner();
        if (callee instanceof IrDeclaration && JvmStaticAnnotationLoweringKt.isJvmStaticInObject((IrDeclaration)callee)) {
            IrClass objectClass = IrUtilsKt.getParentAsClass((IrDeclaration)callee);
            irExpression = new IrGetObjectValueImpl(-1, -1, IrTypesKt.typeWith(objectClass, new IrType[0]), objectClass.getSymbol());
        } else {
            IrExpression irExpression2 = $this$getBoundReceiver.getDispatchReceiver();
            irExpression = irExpression2 == null ? $this$getBoundReceiver.getExtensionReceiver() : irExpression2;
        }
        return irExpression;
    }

    private static final void createKPropertySubclass$setCallArguments(IrBuilderWithScope $this$createKPropertySubclass_u24setCallArguments, IrExpression boundReceiver, IrCallableReference<?> $expression, IrField backingField2, IrCall call2, List<? extends IrValueParameter> arguments2) {
        IrTypeOperatorCallImpl irTypeOperatorCallImpl;
        IrTypeOperatorCallImpl irTypeOperatorCallImpl2;
        IrTypeOperatorCallImpl irTypeOperatorCallImpl3;
        IrCall irCall;
        IrTypeOperatorCallImpl irTypeOperatorCallImpl4;
        IrExpression it;
        boolean bl;
        boolean bl2;
        IrExpression irExpression;
        IrTypeOperatorCallImpl irTypeOperatorCallImpl5;
        IrElementBase irElementBase = boundReceiver;
        if (irElementBase == null) {
            irTypeOperatorCallImpl5 = null;
        } else {
            irExpression = irElementBase;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl3 = false;
            irTypeOperatorCallImpl5 = ExpressionHelpersKt.irImplicitCast($this$createKPropertySubclass_u24setCallArguments, ExpressionHelpersKt.irGetField($this$createKPropertySubclass_u24setCallArguments, ExpressionHelpersKt.irGet($this$createKPropertySubclass_u24setCallArguments, arguments2.get(0)), backingField2), it.getType());
        }
        IrTypeOperatorCallImpl receiverFromField = irTypeOperatorCallImpl5;
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(call2, $expression, 0, 2, null);
        IrCall irCall2 = call2;
        irElementBase = ((IrSimpleFunction)call2.getSymbol().getOwner()).getDispatchReceiverParameter();
        if (irElementBase == null) {
            irTypeOperatorCallImpl4 = null;
        } else {
            irExpression = irElementBase;
            bl2 = false;
            bl = false;
            it = irExpression;
            irCall = irCall2;
            boolean bl4 = false;
            irTypeOperatorCallImpl3 = receiverFromField;
            irTypeOperatorCallImpl2 = irTypeOperatorCallImpl3 == null ? ExpressionHelpersKt.irImplicitCast($this$createKPropertySubclass_u24setCallArguments, ExpressionHelpersKt.irGet($this$createKPropertySubclass_u24setCallArguments, arguments2.get(1)), IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)call2.getSymbol().getOwner()))) : irTypeOperatorCallImpl3;
            irCall2 = irCall;
            irTypeOperatorCallImpl4 = irTypeOperatorCallImpl2;
        }
        irCall2.setDispatchReceiver(irTypeOperatorCallImpl4);
        IrCall irCall3 = call2;
        irElementBase = ((IrSimpleFunction)call2.getSymbol().getOwner()).getExtensionReceiverParameter();
        if (irElementBase == null) {
            irTypeOperatorCallImpl = null;
        } else {
            irExpression = irElementBase;
            bl2 = false;
            bl = false;
            it = irExpression;
            irCall = irCall3;
            boolean bl5 = false;
            irTypeOperatorCallImpl2 = ((IrSimpleFunction)call2.getSymbol().getOwner()).getDispatchReceiverParameter() == null ? ((irTypeOperatorCallImpl3 = receiverFromField) == null ? ExpressionHelpersKt.irImplicitCast($this$createKPropertySubclass_u24setCallArguments, ExpressionHelpersKt.irGet($this$createKPropertySubclass_u24setCallArguments, arguments2.get(1)), ((IrValueDeclaration)((Object)it)).getType()) : irTypeOperatorCallImpl3) : ExpressionHelpersKt.irImplicitCast($this$createKPropertySubclass_u24setCallArguments, ExpressionHelpersKt.irGet($this$createKPropertySubclass_u24setCallArguments, arguments2.get(receiverFromField != null ? 1 : 2)), ((IrValueDeclaration)((Object)it)).getType());
            irCall3 = irCall;
            irTypeOperatorCallImpl = irTypeOperatorCallImpl2;
        }
        irCall3.setExtensionReceiver(irTypeOperatorCallImpl);
    }

    private static final IrTypeOperatorCallImpl createKPropertySubclass$fieldReceiver(IrBuilderWithScope $this$createKPropertySubclass_u24fieldReceiver, IrField field, IrCallableReference<?> $expression, IrField backingField2, List<? extends IrValueParameter> arguments2) {
        return field.isStatic() ? null : ($expression.getDispatchReceiver() != null ? ExpressionHelpersKt.irImplicitCast($this$createKPropertySubclass_u24fieldReceiver, ExpressionHelpersKt.irGetField($this$createKPropertySubclass_u24fieldReceiver, ExpressionHelpersKt.irGet($this$createKPropertySubclass_u24fieldReceiver, arguments2.get(0)), backingField2), IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field))) : ExpressionHelpersKt.irImplicitCast($this$createKPropertySubclass_u24fieldReceiver, ExpressionHelpersKt.irGet($this$createKPropertySubclass_u24fieldReceiver, arguments2.get(1)), IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field))));
    }

    public static final /* synthetic */ IrDeclarationParent access$getPropertyContainer(PropertyReferenceLowering $this, IrMemberAccessExpression $receiver) {
        return $this.getPropertyContainer($receiver);
    }

    public static final /* synthetic */ IrExpression access$computeSignatureString(PropertyReferenceLowering $this, IrBuilderWithScope $receiver, IrMemberAccessExpression expression2) {
        return $this.computeSignatureString($receiver, expression2);
    }

    public static final /* synthetic */ IrTypeOperatorCallImpl access$createKPropertySubclass$fieldReceiver(IrBuilderWithScope $receiver, IrField field, IrCallableReference $expression, IrField backingField2, List arguments2) {
        return PropertyReferenceLowering.createKPropertySubclass$fieldReceiver($receiver, field, $expression, backingField2, arguments2);
    }

    public static final /* synthetic */ void access$createKPropertySubclass$setCallArguments(IrBuilderWithScope $receiver, IrExpression boundReceiver, IrCallableReference $expression, IrField backingField2, IrCall call2, List arguments2) {
        PropertyReferenceLowering.createKPropertySubclass$setCallArguments($receiver, boundReceiver, $expression, backingField2, call2, arguments2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$PropertyReferenceKind;", "", "interfaceSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "implSymbol", "wrapper", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getImplSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getInterfaceSymbol", "getWrapper", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.jvm"})
    private static final class PropertyReferenceKind {
        @NotNull
        private final IrClassSymbol interfaceSymbol;
        @NotNull
        private final IrClassSymbol implSymbol;
        @NotNull
        private final IrFunction wrapper;

        public PropertyReferenceKind(@NotNull IrClassSymbol interfaceSymbol, @NotNull IrClassSymbol implSymbol, @NotNull IrFunction wrapper) {
            Intrinsics.checkNotNullParameter(interfaceSymbol, "interfaceSymbol");
            Intrinsics.checkNotNullParameter(implSymbol, "implSymbol");
            Intrinsics.checkNotNullParameter(wrapper, "wrapper");
            this.interfaceSymbol = interfaceSymbol;
            this.implSymbol = implSymbol;
            this.wrapper = wrapper;
        }

        @NotNull
        public final IrClassSymbol getInterfaceSymbol() {
            return this.interfaceSymbol;
        }

        @NotNull
        public final IrClassSymbol getImplSymbol() {
            return this.implSymbol;
        }

        @NotNull
        public final IrFunction getWrapper() {
            return this.wrapper;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$PropertyInstance;", "", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "index", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;I)V", "getIndex", "()I", "getInitializer", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "backend.jvm"})
    private static final class PropertyInstance {
        @NotNull
        private final IrExpression initializer;
        private final int index;

        public PropertyInstance(@NotNull IrExpression initializer2, int index2) {
            Intrinsics.checkNotNullParameter(initializer2, "initializer");
            this.initializer = initializer2;
            this.index = index2;
        }

        @NotNull
        public final IrExpression getInitializer() {
            return this.initializer;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final IrExpression component1() {
            return this.initializer;
        }

        public final int component2() {
            return this.index;
        }

        @NotNull
        public final PropertyInstance copy(@NotNull IrExpression initializer2, int index2) {
            Intrinsics.checkNotNullParameter(initializer2, "initializer");
            return new PropertyInstance(initializer2, index2);
        }

        public static /* synthetic */ PropertyInstance copy$default(PropertyInstance propertyInstance, IrExpression irExpression, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irExpression = propertyInstance.initializer;
            }
            if ((n2 & 2) != 0) {
                n = propertyInstance.index;
            }
            return propertyInstance.copy(irExpression, n);
        }

        @NotNull
        public String toString() {
            return "PropertyInstance(initializer=" + this.initializer + ", index=" + this.index + ')';
        }

        public int hashCode() {
            int result2 = this.initializer.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.index);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertyInstance)) {
                return false;
            }
            PropertyInstance propertyInstance = (PropertyInstance)other;
            if (!Intrinsics.areEqual(this.initializer, propertyInstance.initializer)) {
                return false;
            }
            return this.index == propertyInstance.index;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0018\u00010\u0000R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010 \u001a\u0004\u0018\u00010\u001c2\u0006\u0010!\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001c0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0018\u00010\u0000R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$ClassData;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "parent", "Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$ClassData;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isSynthetic", "", "()Z", "kProperties", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$PropertyInstance;", "getKProperties", "()Ljava/util/Map;", "kPropertiesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getKPropertiesField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "localProperties", "", "Lorg/jetbrains/kotlin/ir/symbols/IrLocalDelegatedPropertySymbol;", "getLocalProperties", "()Ljava/util/List;", "localPropertyIndices", "", "getLocalPropertyIndices", "getParent", "()Lorg/jetbrains/kotlin/backend/jvm/lower/PropertyReferenceLowering$ClassData;", "localPropertyIndex", "getter", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Ljava/lang/Integer;", "localPropertyOwner", "rememberLocalProperty", "", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "backend.jvm"})
    private final class ClassData {
        @NotNull
        private final IrClass irClass;
        @Nullable
        private final ClassData parent;
        @NotNull
        private final Map<IrSymbol, PropertyInstance> kProperties;
        @NotNull
        private final IrField kPropertiesField;
        @NotNull
        private final List<IrLocalDelegatedPropertySymbol> localProperties;
        @NotNull
        private final Map<IrSymbol, Integer> localPropertyIndices;
        private final boolean isSynthetic;

        /*
         * WARNING - void declaration
         */
        public ClassData(@Nullable IrClass irClass2, ClassData parent2) {
            void $this$buildField$iv;
            Object object;
            void $this$kPropertiesField_u24lambda_u2d0;
            Intrinsics.checkNotNullParameter(PropertyReferenceLowering.this, "this$0");
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            this.irClass = irClass2;
            this.parent = parent2;
            boolean bl = false;
            this.kProperties = new LinkedHashMap();
            IrFactory irFactory = PropertyReferenceLowering.this.getContext().getIrFactory();
            PropertyReferenceLowering propertyReferenceLowering = PropertyReferenceLowering.this;
            boolean $i$f$buildField = false;
            IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            IrFieldBuilder $this$buildField_u24lambda_u2d4$iv = irFieldBuilder;
            boolean bl4 = false;
            IrFieldBuilder irFieldBuilder2 = $this$buildField_u24lambda_u2d4$iv;
            ClassData classData = this;
            boolean bl5 = false;
            Object object2 = Name.identifier("$$delegatedProperties");
            Intrinsics.checkNotNullExpressionValue(object2, "identifier(JvmAbi.DELEGATED_PROPERTIES_ARRAY_NAME)");
            $this$kPropertiesField_u24lambda_u2d0.setName((Name)object2);
            $this$kPropertiesField_u24lambda_u2d0.setType(propertyReferenceLowering.kPropertiesFieldType);
            $this$kPropertiesField_u24lambda_u2d0.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE);
            $this$kPropertiesField_u24lambda_u2d0.setFinal(true);
            $this$kPropertiesField_u24lambda_u2d0.setStatic(true);
            if (IrUtilsKt.isInterface(this.getIrClass()) && propertyReferenceLowering.getContext().getState().getJvmDefaultMode().getForAllMethodsWithBody()) {
                object2 = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue(object2, "PUBLIC");
                object = object2;
            } else {
                object2 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
                Intrinsics.checkNotNullExpressionValue(object2, "PACKAGE_VISIBILITY");
                object = object2;
            }
            $this$kPropertiesField_u24lambda_u2d0.setVisibility((DescriptorVisibility)object);
            Unit unit = Unit.INSTANCE;
            classData.kPropertiesField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, $this$buildField_u24lambda_u2d4$iv);
            boolean bl6 = false;
            this.localProperties = new ArrayList();
            bl6 = false;
            this.localPropertyIndices = new LinkedHashMap();
            this.isSynthetic = !(this.irClass.getMetadata() instanceof MetadataSource.File) && !(this.irClass.getMetadata() instanceof MetadataSource.Class);
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        @Nullable
        public final ClassData getParent() {
            return this.parent;
        }

        @NotNull
        public final Map<IrSymbol, PropertyInstance> getKProperties() {
            return this.kProperties;
        }

        @NotNull
        public final IrField getKPropertiesField() {
            return this.kPropertiesField;
        }

        @NotNull
        public final List<IrLocalDelegatedPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Map<IrSymbol, Integer> getLocalPropertyIndices() {
            return this.localPropertyIndices;
        }

        public final boolean isSynthetic() {
            return this.isSynthetic;
        }

        @Nullable
        public final Integer localPropertyIndex(@NotNull IrSymbol getter2) {
            ClassData classData;
            Intrinsics.checkNotNullParameter(getter2, "getter");
            Integer n = this.localPropertyIndices.get(getter2);
            return n == null ? ((classData = this.parent) == null ? null : classData.localPropertyIndex(getter2)) : n;
        }

        @Nullable
        public final IrClass localPropertyOwner(@NotNull IrSymbol getter2) {
            Intrinsics.checkNotNullParameter(getter2, "getter");
            Object object = this.localPropertyIndices;
            boolean bl = false;
            Map<IrSymbol, Integer> map = object;
            boolean bl2 = false;
            return map.containsKey(getter2) ? this.irClass : ((object = this.parent) == null ? null : ((ClassData)object).localPropertyOwner(getter2));
        }

        public final void rememberLocalProperty(@NotNull IrLocalDelegatedProperty property2) {
            ClassData classData;
            Object object;
            block1: {
                Intrinsics.checkNotNullParameter(property2, "property");
                object = SequencesKt.generateSequence(this, (Function1)rememberLocalProperty.metadataOwner.1.INSTANCE);
                boolean bl = false;
                Sequence<ClassData> sequence2 = object;
                boolean bl2 = false;
                Iterator<ClassData> iterator2 = sequence2.iterator();
                while (iterator2.hasNext()) {
                    ClassData classData2;
                    ClassData it = classData2 = iterator2.next();
                    boolean bl3 = false;
                    if (!(!it.isSynthetic())) continue;
                    classData = classData2;
                    break block1;
                }
                classData = null;
            }
            Object object2 = classData;
            ClassData metadataOwner2 = object2 == null ? this : object2;
            object2 = metadataOwner2.localPropertyIndices;
            object = property2.getGetter().getSymbol();
            Integer n = metadataOwner2.localProperties.size();
            boolean bl = false;
            object2.put(object, n);
            metadataOwner2.localProperties.add(property2.getSymbol());
        }
    }
}

