/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginConflictReporter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class StartupAbortedException
extends RuntimeException {
    public StartupAbortedException(@NotNull String message, @NotNull Throwable cause) {
        super(message, cause);
    }

    public static void processException(@NotNull Throwable t) {
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && !(t instanceof StartupAbortedException)) {
            if (!(t instanceof ProcessCanceledException)) {
                PluginManagerCore.getLogger().error(t);
            }
            return;
        }
        StartupAbortedException.logAndExit(t);
    }

    public static void logAndExit(@NotNull Throwable t) {
        ImplementationConflictException conflictException;
        PluginException pluginException;
        PluginId pluginId;
        PluginManagerCore.EssentialPluginMissingException essentialPluginMissingException = StartupAbortedException.findCause(t, PluginManagerCore.EssentialPluginMissingException.class);
        if (essentialPluginMissingException != null && essentialPluginMissingException.pluginIds != null) {
            Main.showMessage((String)"Corrupted Installation", (String)("Missing essential " + (essentialPluginMissingException.pluginIds.size() == 1 ? "plugin" : "plugins") + ":\n\n" + essentialPluginMissingException.pluginIds.stream().sorted().collect(Collectors.joining("\n  ", "  ", "\n\n")) + "Please reinstall " + StartupAbortedException.getProductNameSafe() + " from scratch."), (boolean)true);
            System.exit(12);
        }
        PluginId pluginId2 = pluginId = (pluginException = StartupAbortedException.findCause(t, PluginException.class)) != null ? pluginException.getPluginId() : null;
        if (Logger.isInitialized() && !(t instanceof ProcessCanceledException)) {
            try {
                PluginManagerCore.getLogger().error(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof StackOverflowError && "Nashorn AST Serializer".equals(Thread.currentThread().getName())) {
                return;
            }
        }
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred() && (conflictException = StartupAbortedException.findCause(t, ImplementationConflictException.class)) != null) {
            PluginConflictReporter pluginConflictReporter = (PluginConflictReporter)ApplicationManager.getApplication().getService(PluginConflictReporter.class);
            pluginConflictReporter.reportConflictByClasses(conflictException.getConflictingClasses());
        }
        if (pluginId != null && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(pluginId)) {
            PluginManagerCore.disablePlugin((PluginId)pluginId);
            StringWriter message = new StringWriter();
            message.append("Plugin '").append(pluginId.getIdString()).append("' failed to initialize and will be disabled. ");
            message.append(" Please restart ").append(StartupAbortedException.getProductNameSafe()).append('.');
            message.append("\n\n");
            pluginException.getCause().printStackTrace(new PrintWriter(message));
            Main.showMessage((String)"Plugin Error", (String)message.toString(), (boolean)false);
            System.exit(8);
        } else {
            Main.showMessage((String)"Start Failed", (Throwable)t);
            System.exit(3);
        }
    }

    private static String getProductNameSafe() {
        try {
            return ApplicationNamesInfo.getInstance().getFullProductName();
        }
        catch (Throwable ignore) {
            return "the IDE";
        }
    }

    private static <T extends Throwable> T findCause(Throwable t, Class<T> clazz) {
        while (t != null) {
            if (clazz.isInstance(t)) {
                return (T)((Throwable)clazz.cast(t));
            }
            t = t.getCause();
        }
        return null;
    }
}

