/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.terminal.JBTerminalWidget;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalRunner;

public class TerminalHandlerImpl
extends TerminalHandlerBase {
    private final JBTerminalWidget myTerminalWidget;

    public TerminalHandlerImpl(@NotNull String presentableName, @NotNull Project project, @NotNull InputStream terminalOutput, @NotNull OutputStream terminalInput, boolean deferTerminalSessionUntilFirstShown) {
        super(presentableName);
        CloudTerminalProcess process = new CloudTerminalProcess(terminalInput, terminalOutput);
        TerminalListener.TtyResizeHandler handlerBoundLater = (w, h) -> this.getResizeHandler().onTtyResizeRequest(w, h);
        CloudTerminalRunner terminalRunner = new CloudTerminalRunner(project, presentableName, process, handlerBoundLater, deferTerminalSessionUntilFirstShown);
        this.myTerminalWidget = terminalRunner.createTerminalWidget((Disposable)project, null);
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getPreferredFocusableComponent();
    }

    public void close() {
        this.myTerminalWidget.getTerminalDisplay().setCursorVisible(false);
        this.myTerminalWidget.stop();
        super.close();
    }
}

