/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.terminal.JBTerminalWidget;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.awt.Dimension;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;

public class CloudTerminalRunner
extends AbstractTerminalRunner<CloudTerminalProcess> {
    private final String myPipeName;
    private final CloudTerminalProcess myProcess;
    private final TerminalListener.TtyResizeHandler myTtyResizeHandler;
    private final boolean myDeferSessionUntilFirstShown;

    public CloudTerminalRunner(@NotNull Project project, String pipeName, CloudTerminalProcess process, @Nullable TerminalListener.TtyResizeHandler resizeHandler, boolean deferSessionUntilFirstShown) {
        super(project);
        this.myPipeName = pipeName;
        this.myProcess = process;
        this.myTtyResizeHandler = resizeHandler;
        this.myDeferSessionUntilFirstShown = deferSessionUntilFirstShown;
    }

    public CloudTerminalRunner(@NotNull Project project, String pipeName, CloudTerminalProcess process) {
        this(project, pipeName, process, null, false);
    }

    @Override
    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        return super.createTerminalWidget(parent, currentWorkingDirectory, this.myDeferSessionUntilFirstShown);
    }

    @Override
    protected CloudTerminalProcess createProcess(@Nullable String directory) {
        return this.myProcess;
    }

    @Override
    protected ProcessHandler createProcessHandler(final CloudTerminalProcess process) {
        return new ProcessHandler(){

            protected void destroyProcessImpl() {
                process.destroy();
            }

            protected void detachProcessImpl() {
                process.destroy();
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return process.getOutputStream();
            }
        };
    }

    @Override
    protected String getTerminalConnectionName(CloudTerminalProcess process) {
        return "Terminal: " + this.myPipeName;
    }

    @Override
    protected TtyConnector createTtyConnector(CloudTerminalProcess process) {
        return new ProcessTtyConnector(process, Charset.defaultCharset()){
            private Dimension myAppliedTermSize;

            protected void resizeImmediately() {
                if (CloudTerminalRunner.this.myTtyResizeHandler == null) {
                    return;
                }
                Dimension termSize = this.getPendingTermSize();
                if (Objects.equals(this.myAppliedTermSize, termSize)) {
                    return;
                }
                if (termSize != null) {
                    CloudTerminalRunner.this.myTtyResizeHandler.onTtyResizeRequest(termSize.width, termSize.height);
                }
                this.myAppliedTermSize = termSize;
            }

            public String getName() {
                return "Connector: " + CloudTerminalRunner.this.myPipeName;
            }

            public boolean isConnected() {
                return true;
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Cloud terminal";
    }
}

