/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalView;

public class RevealFileInTerminalAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(RevealFileInTerminalAction.isAvailable(e));
    }

    private static boolean isAvailable(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        return project != null && !LightEdit.owns((Project)project) && RevealFileInTerminalAction.getSelectedFile(e) != null;
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e) {
        return RevealFileAction.findLocalFile((VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile selectedFile = RevealFileInTerminalAction.getSelectedFile(e);
        if (project == null || selectedFile == null) {
            return;
        }
        TerminalView.getInstance(project).openTerminalIn(selectedFile);
    }
}

