/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.Alarm;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.StyledTextConsumerAdapter;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalModelListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.shellCommandRunner.TerminalDebugSmartCommandAction;
import org.jetbrains.plugins.terminal.shellCommandRunner.TerminalExecutorAction;
import org.jetbrains.plugins.terminal.shellCommandRunner.TerminalRunSmartCommandAction;

public final class TerminalShellCommandHandlerHelper {
    private static final Logger LOG = Logger.getInstance(TerminalShellCommandHandler.class);
    @NonNls
    private static final String TERMINAL_CUSTOM_COMMANDS_GOT_IT = "TERMINAL_CUSTOM_COMMANDS_GOT_IT";
    @NonNls
    private static final String GOT_IT = "got_it";
    @NonNls
    private static final String FEATURE_ID = "terminal.shell.command.handling";
    private static Experiments ourExperiments;
    private static final NotificationGroup ourToolWindowGroup;
    private final ShellTerminalWidget myWidget;
    private final Alarm myAlarm;
    private volatile String myWorkingDirectory;
    private volatile Boolean myHasRunningCommands;
    private PropertiesComponent myPropertiesComponent;
    private final SingletonNotificationManager mySingletonNotificationManager = new SingletonNotificationManager(ourToolWindowGroup, NotificationType.INFORMATION, null);
    private final AtomicBoolean myKeyPressed = new AtomicBoolean(false);

    TerminalShellCommandHandlerHelper(@NotNull ShellTerminalWidget widget) {
        this.myWidget = widget;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)widget);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myWidget).subscribe(TerminalCommandHandlerCustomizer.Companion.getTERMINAL_COMMAND_HANDLER_TOPIC(), () -> this.scheduleCommandHighlighting());
        TerminalModelListener listener = () -> {
            if (this.myKeyPressed.compareAndSet(true, false)) {
                this.scheduleCommandHighlighting();
            }
        };
        widget.getTerminalTextBuffer().addModelListener(listener);
        Disposer.register((Disposable)this.myWidget, () -> widget.getTerminalTextBuffer().removeModelListener(listener));
    }

    public void processKeyPressed() {
        if (TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            this.myKeyPressed.set(true);
            this.scheduleCommandHighlighting();
        }
    }

    private void scheduleCommandHighlighting() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.highlightMatchedCommand(this.myWidget.getProject()), 0);
    }

    public static boolean isFeatureEnabled() {
        Experiments experiments = ourExperiments;
        if (experiments == null) {
            ourExperiments = experiments = (Experiments)ReadAction.compute(() -> ApplicationManager.getApplication().isDisposed() ? null : Experiments.getInstance());
        }
        return experiments != null && experiments.isFeatureEnabled(FEATURE_ID);
    }

    private void highlightMatchedCommand(@NotNull Project project) {
        if (!this.isEnabledForProject()) {
            this.myWidget.getTerminalPanel().setFindResult(null);
            return;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        SubstringFinder.FindResult result = TerminalShellCommandHandler.Companion.matches(project, this.getWorkingDirectory(), !this.hasRunningCommands(), command) ? this.searchMatchedCommand(command) : null;
        this.myWidget.getTerminalPanel().setFindResult(result);
        if (this.getPropertiesComponent().getBoolean(TERMINAL_CUSTOM_COMMANDS_GOT_IT, false)) {
            return;
        }
        if (result != null) {
            String title = TerminalBundle.message("smart_command_execution.notification.title", new Object[0]);
            String content = TerminalBundle.message("smart_command_execution.notification.text", KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getRunAction()), KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getDebugAction()), ShowSettingsUtil.getSettingsMenuName(), GOT_IT);
            NotificationListener.Adapter listener = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (TerminalShellCommandHandlerHelper.GOT_IT.equals(e.getDescription())) {
                        TerminalShellCommandHandlerHelper.this.getPropertiesComponent().setValue(TerminalShellCommandHandlerHelper.TERMINAL_CUSTOM_COMMANDS_GOT_IT, true, false);
                    }
                }
            };
            this.mySingletonNotificationManager.notify(title, content, project, (NotificationListener)listener);
        }
    }

    private boolean isEnabledForProject() {
        return this.getPropertiesComponent().getBoolean("terminalCustomCommandExecutionTurnOff", true);
    }

    @NotNull
    private PropertiesComponent getPropertiesComponent() {
        PropertiesComponent propertiesComponent = this.myPropertiesComponent;
        if (propertiesComponent == null) {
            this.myPropertiesComponent = propertiesComponent = (PropertiesComponent)ReadAction.compute(() -> PropertiesComponent.getInstance());
        }
        return propertiesComponent;
    }

    @Nullable
    private String getWorkingDirectory() {
        String workingDirectory = this.myWorkingDirectory;
        if (workingDirectory == null) {
            this.myWorkingDirectory = workingDirectory = StringUtil.notNullize((String)TerminalWorkingDirectoryManager.getWorkingDirectory(this.myWidget, null));
        }
        return StringUtil.nullize((String)workingDirectory);
    }

    private boolean hasRunningCommands() {
        Boolean hasRunningCommands = this.myHasRunningCommands;
        if (hasRunningCommands == null) {
            this.myHasRunningCommands = hasRunningCommands = Boolean.valueOf(this.myWidget.hasRunningCommands());
        }
        return hasRunningCommands;
    }

    @Nullable
    private SubstringFinder.FindResult searchMatchedCommand(@NotNull String pattern) {
        if (pattern.length() == 0) {
            return null;
        }
        return this.myWidget.processTerminalBuffer(textBuffer -> {
            int cursorLine = this.myWidget.getLineNumberAtCursor();
            if (cursorLine < 0 || cursorLine >= textBuffer.getHeight()) {
                return null;
            }
            String lineText = textBuffer.getLine(cursorLine).getText();
            final int patternStartInd = lineText.lastIndexOf(pattern);
            if (patternStartInd < 0) {
                return null;
            }
            final SubstringFinder finder = new SubstringFinder(pattern, true){

                public boolean accept(@NotNull SubstringFinder.FindResult.FindItem item) {
                    return item.getStart().x >= patternStartInd;
                }
            };
            textBuffer.processScreenLines(cursorLine, 1, (StyledTextConsumer)new StyledTextConsumerAdapter(){

                public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                    for (int i = 0; i < characters.length(); ++i) {
                        finder.nextChar(x, y - startRow, characters, i);
                    }
                }
            });
            return finder.getResult();
        });
    }

    public boolean processEnterKeyPressed(@NotNull KeyEvent keyPressed) {
        boolean localSession;
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled() || !this.isEnabledForProject()) {
            this.onShellCommandExecuted();
            return false;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("typed shell command to execute: " + command);
        }
        this.myAlarm.cancelAllRequests();
        Project project = this.myWidget.getProject();
        String workingDirectory = this.getWorkingDirectory();
        boolean bl = localSession = !this.hasRunningCommands();
        if (!TerminalShellCommandHandler.Companion.matches(project, workingDirectory, localSession, command)) {
            this.onShellCommandExecuted();
            return false;
        }
        TerminalShellCommandHandler handler = TerminalShellCommandHandler.Companion.getEP().getExtensionList().stream().filter(it -> it.matches(project, workingDirectory, localSession, command)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find matching command handler."));
        Executor executor = TerminalShellCommandHandlerHelper.matchedExecutor(keyPressed);
        if (executor == null) {
            this.onShellCommandExecuted();
            TerminalUsageTriggerCollector.Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, false);
            return false;
        }
        TerminalUsageTriggerCollector.Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, true);
        TerminalShellCommandHandler.Companion.executeShellCommandHandler(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command, executor);
        this.clearTypedCommand(command);
        return true;
    }

    private void onShellCommandExecuted() {
        this.myWorkingDirectory = null;
        this.myHasRunningCommands = null;
    }

    private void clearTypedCommand(@NotNull String command) {
        TtyConnector connector = this.myWidget.getTtyConnector();
        byte[] array = new byte[command.length()];
        Arrays.fill(array, (byte)8);
        try {
            connector.write(array);
        }
        catch (IOException e) {
            LOG.info("Cannot clear shell command " + command, (Throwable)e);
        }
    }

    @Nullable
    static Executor matchedExecutor(@NotNull KeyEvent e) {
        if (TerminalShellCommandHandlerHelper.matchedRunAction(e) != null) {
            return DefaultRunExecutor.getRunExecutorInstance();
        }
        if (TerminalShellCommandHandlerHelper.matchedDebugAction(e) != null) {
            return ExecutorRegistry.getInstance().getExecutorById("Debug");
        }
        return null;
    }

    private static TerminalExecutorAction matchedRunAction(@NotNull KeyEvent e) {
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        AnAction action = TerminalShellCommandHandlerHelper.getRunAction();
        return action instanceof TerminalRunSmartCommandAction && Arrays.stream(action.getShortcutSet().getShortcuts()).anyMatch(sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut)) ? (TerminalRunSmartCommandAction)action : null;
    }

    private static TerminalExecutorAction matchedDebugAction(@NotNull KeyEvent e) {
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        AnAction action = TerminalShellCommandHandlerHelper.getDebugAction();
        return action instanceof TerminalDebugSmartCommandAction && Arrays.stream(action.getShortcutSet().getShortcuts()).anyMatch(sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut)) ? (TerminalDebugSmartCommandAction)action : null;
    }

    @NotNull
    private static AnAction getRunAction() {
        return Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Run"));
    }

    @NotNull
    private static AnAction getDebugAction() {
        return Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Debug"));
    }

    static {
        ourToolWindowGroup = NotificationGroup.toolWindowGroup((String)"Terminal", (String)"Terminal");
    }
}

