/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.ResolveData;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.BasicResolver;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List<String> ivyPatterns = new ArrayList<String>();
    private List<String> artifactPatterns = new ArrayList<String>();
    private boolean m2compatible = false;

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.ivyPatterns, DefaultArtifact.newIvyArtifact(mrid, data.getDate()), this.getRMDParser(dd, data), data.getDate());
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date) {
        if (this.isM2compatible()) {
            mrid = this.convertM2ResourceSearchIdToNormal(mrid);
        }
        return super.findResource(rress, rmdparser, mrid, date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List<String> patternList, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        ArrayList<ResolvedResource> resolvedResources = new ArrayList<ResolvedResource>();
        HashSet<String> foundRevisions = new HashSet<String>();
        boolean dynamic = this.getSettings().getVersionMatcher().isDynamic(moduleRevision);
        for (String pattern : patternList) {
            ResolvedResource rres = this.findResourceUsingPattern(moduleRevision, pattern, artifact, rmdparser, date);
            if (rres == null || foundRevisions.contains(rres.getRevision())) continue;
            foundRevisions.add(rres.getRevision());
            resolvedResources.add(rres);
            if (dynamic) continue;
            break;
        }
        if (resolvedResources.size() > 1) {
            ResolvedResource[] rress = resolvedResources.toArray(new ResolvedResource[resolvedResources.size()]);
            return this.findResource(rress, rmdparser, moduleRevision, date);
        }
        if (resolvedResources.size() == 1) {
            return (ResolvedResource)resolvedResources.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    public List<String> getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List<String> getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected void setIvyPatterns(List<String> patterns) {
        this.ivyPatterns = patterns;
    }

    protected void setArtifactPatterns(List<String> patterns) {
        this.artifactPatterns = patterns;
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        for (String p : this.getIvyPatterns()) {
            Message.debug("\t\t\t" + p);
        }
        Message.debug("\t\tartifact patterns:");
        for (String p : this.getArtifactPatterns()) {
            Message.debug("\t\t\t" + p);
        }
    }

    public boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean compatible) {
        this.m2compatible = compatible;
    }

    protected ModuleRevisionId convertM2ResourceSearchIdToNormal(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(47) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('/', '.'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }
}

