/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.jetbrains.kotlin.org.apache.ivy.core.report.ConfigurationResolveReport;
import org.jetbrains.kotlin.org.apache.ivy.core.report.DownloadStatus;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.ResolveOptions;
import org.jetbrains.kotlin.org.apache.ivy.plugins.report.ReportOutputter;
import org.jetbrains.kotlin.org.apache.ivy.util.filter.Filter;

public class ResolveReport {
    private ModuleDescriptor md;
    private Map<String, ConfigurationResolveReport> confReports = new LinkedHashMap<String, ConfigurationResolveReport>();
    private List<String> problemMessages = new ArrayList<String>();
    private List<IvyNode> dependencies = new ArrayList<IvyNode>();
    private List<Artifact> artifacts = new ArrayList<Artifact>();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(ModuleDescriptor md, String resolveId) {
        this.md = md;
        this.resolveId = resolveId;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this.confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return this.confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public boolean hasError() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            if (!report.hasError()) continue;
            return true;
        }
        return false;
    }

    public void output(ReportOutputter[] outputters, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        for (ReportOutputter outputter : outputters) {
            outputter.output(this, cacheMgr, options);
        }
    }

    public IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport report : this.confReports.values()) {
            ArtifactDownloadReport[] reports = report.getArtifactsReports(downloadStatus, withEvicted);
            all.addAll(Arrays.asList(reports));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public void checkIfChanged() {
        for (ConfigurationResolveReport report : this.confReports.values()) {
            report.checkIfChanged();
        }
    }

    public void setProblemMessages(List<String> problems) {
        this.problemMessages = problems;
    }

    public List<String> getAllProblemMessages() {
        ArrayList<String> ret = new ArrayList<String>(this.problemMessages);
        for (ConfigurationResolveReport r : this.confReports.values()) {
            for (IvyNode unresolved : r.getUnresolvedDependencies()) {
                String errMsg = unresolved.getProblemMessage();
                if (errMsg.isEmpty()) {
                    ret.add("unresolved dependency: " + unresolved.getId());
                    continue;
                }
                ret.add("unresolved dependency: " + unresolved.getId() + ": " + errMsg);
            }
            for (ArtifactDownloadReport adr : r.getFailedArtifactsReports()) {
                ret.add("download failed: " + adr.getArtifact());
            }
        }
        return ret;
    }

    public void setDependencies(List<IvyNode> dependencies, Filter<Artifact> artifactFilter) {
        this.dependencies = dependencies;
        this.artifacts = new ArrayList<Artifact>();
        for (IvyNode dependency : dependencies) {
            if (!dependency.isCompletelyEvicted() && !dependency.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(dependency.getSelectedArtifacts(artifactFilter)));
            }
            for (String dconf : dependency.getRootModuleConfigurations()) {
                ConfigurationResolveReport configurationReport = this.getConfigurationReport(dconf);
                if (configurationReport == null) continue;
                configurationReport.addDependency(dependency);
            }
        }
    }

    public List<IvyNode> getDependencies() {
        return this.dependencies;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setResolveTime(long elapsedTime) {
        this.resolveTime = elapsedTime;
    }

    public long getResolveTime() {
        return this.resolveTime;
    }

    public void setDownloadTime(long elapsedTime) {
        this.downloadTime = elapsedTime;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadSize(long size) {
        this.downloadSize = size;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public String getResolveId() {
        return this.resolveId;
    }
}

