/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.model.impl;

import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidApplicationArtifactPropertiesSerializer;
import org.jetbrains.jps.android.model.impl.JpsAndroidDexSettingsSerializer;
import org.jetbrains.jps.android.model.impl.JpsAndroidFinalPackageElementSerializer;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;

public class JpsAndroidModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final List<? extends JpsFacetConfigurationSerializer<JpsAndroidModuleExtension>> FACET_PROPERTIES_LOADERS = Collections.singletonList(new JpsFacetConfigurationSerializer<JpsAndroidModuleExtension>(JpsAndroidModuleExtensionImpl.KIND, "android", "Android"){

        public JpsAndroidModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
            return new JpsAndroidModuleExtensionImpl((AndroidFacetProperties)XmlSerializer.deserialize((Element)facetConfigurationElement, AndroidFacetProperties.class));
        }

        protected void saveExtension(JpsAndroidModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
            XmlSerializer.serializeInto((Object)((JpsAndroidModuleExtensionImpl)extension).getProperties(), (Element)facetConfigurationTag);
        }
    });
    private static final JpsSdkPropertiesSerializer<JpsSimpleElement<JpsAndroidSdkProperties>> SDK_PROPERTIES_LOADER = new JpsSdkPropertiesSerializer<JpsSimpleElement<JpsAndroidSdkProperties>>("Android SDK", (JpsSdkType)JpsAndroidSdkType.INSTANCE){

        @NotNull
        public JpsSimpleElement<JpsAndroidSdkProperties> loadProperties(@Nullable Element propertiesElement) {
            String jdkName;
            String buildTarget;
            if (propertiesElement != null) {
                buildTarget = propertiesElement.getAttributeValue("sdk");
                jdkName = propertiesElement.getAttributeValue("jdk");
            } else {
                buildTarget = null;
                jdkName = null;
            }
            return JpsElementFactory.getInstance().createSimpleElement((Object)new JpsAndroidSdkProperties(buildTarget, jdkName));
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsAndroidSdkProperties> properties, @NotNull Element element) {
            String buildTarget;
            String jdkName = ((JpsAndroidSdkProperties)properties.getData()).getJdkName();
            if (jdkName != null) {
                element.setAttribute("jdk", jdkName);
            }
            if ((buildTarget = ((JpsAndroidSdkProperties)properties.getData()).getBuildTargetHashString()) != null) {
                element.setAttribute("sdk", buildTarget);
            }
        }
    };

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        return FACET_PROPERTIES_LOADERS;
    }

    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        return Collections.singletonList(new JpsAndroidFinalPackageElementSerializer());
    }

    @NotNull
    public List<? extends JpsArtifactPropertiesSerializer<?>> getArtifactTypePropertiesSerializers() {
        return Collections.singletonList(new JpsAndroidApplicationArtifactPropertiesSerializer());
    }

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        return Collections.singletonList(new JpsAndroidDexSettingsSerializer());
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        return Collections.singletonList(SDK_PROPERTIES_LOADER);
    }
}

