/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidClassesDirBuildRootDescriptor;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidLibraryPackagingTarget
extends AndroidBuildTarget {
    public AndroidLibraryPackagingTarget(@NotNull JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File moduleOutputDir = ProjectPaths.getModuleOutputDir((JpsModule)this.myModule, (boolean)false);
        if (moduleOutputDir != null) {
            return Collections.singletonList(new AndroidClassesDirBuildRootDescriptor(this, moduleOutputDir));
        }
        return Collections.emptyList();
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputFile(context));
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        return this.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths());
    }

    @NotNull
    public File getOutputFile(BuildDataPaths dataPaths) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, this.myModule);
        return new File(dir, "classes.jar");
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidLibraryPackagingTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-library-packaging", "Library Packaging");
        }

        @Override
        @Nullable
        public AndroidLibraryPackagingTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            return extension.isLibrary() ? new AndroidLibraryPackagingTarget(extension.getModule()) : null;
        }
    }
}

