/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidDependencyProcessor;
import org.jetbrains.jps.android.AndroidDependencyType;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.AndroidPreDexBuilder;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidClassesDirBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidFileBasedBuildRootDescriptor;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidDexCompilerConfiguration;
import org.jetbrains.jps.android.model.JpsAndroidExtensionService;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidDexBuildTarget
extends AndroidBuildTarget {
    public AndroidDexBuildTarget(@NotNull JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        super.writeConfiguration(pd, out);
        JpsAndroidDexCompilerConfiguration c = JpsAndroidExtensionService.getInstance().getDexCompilerConfiguration(this.getModule().getProject());
        if (c != null) {
            out.println(c.getVmOptions());
            out.println(c.getMaxHeapSize());
            out.println(c.isOptimize());
            out.println(c.isForceJumbo());
            out.println(c.isCoreLibrary());
            out.println(c.getProguardVmOptions());
        }
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File testModuleClassesDir;
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isLibrary()) {
            return Collections.emptyList();
        }
        final Map libPackage2ModuleName = CollectionFactory.createFilePathMap();
        Set appClassesDirs = CollectionFactory.createFilePathSet();
        final Set javaClassesDirs = CollectionFactory.createFilePathSet();
        final Set libClassesDirs = CollectionFactory.createFilePathSet();
        File moduleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.PRODUCTION).getOutputDir();
        if (moduleClassesDir != null) {
            appClassesDirs.add(moduleClassesDir.getPath());
        }
        AndroidJpsUtil.processClasspath(dataPaths, this.myModule, new AndroidDependencyProcessor(){

            @Override
            public void processAndroidLibraryPackage(@NotNull File file, @NotNull JpsModule depModule) {
                libPackage2ModuleName.put(file.getPath(), depModule.getName());
            }

            @Override
            public void processAndroidLibraryOutputDirectory(@NotNull File dir) {
                libClassesDirs.add(dir.getPath());
            }

            @Override
            public void processJavaModuleOutputDirectory(@NotNull File dir) {
                javaClassesDirs.add(dir.getPath());
            }

            @Override
            public boolean isToProcess(@NotNull AndroidDependencyType type) {
                return type == AndroidDependencyType.ANDROID_LIBRARY_PACKAGE || type == AndroidDependencyType.ANDROID_LIBRARY_OUTPUT_DIRECTORY || type == AndroidDependencyType.JAVA_MODULE_OUTPUT_DIR;
            }
        }, false, false);
        if (extension.isPackTestCode() && (testModuleClassesDir = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.TEST).getOutputDir()) != null) {
            appClassesDirs.add(testModuleClassesDir.getPath());
        }
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (Object classesDir : appClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File((String)classesDir), ClassesDirType.ANDROID_APP));
        }
        for (Object classesDir : libClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File((String)classesDir), ClassesDirType.ANDROID_LIB));
        }
        for (Object classesDir : javaClassesDirs) {
            result.add((BuildRootDescriptor)new MyClassesDirBuildRootDescriptor(this, new File((String)classesDir), ClassesDirType.JAVA));
        }
        File preDexOutputDir = AndroidPreDexBuildTarget.getOutputDir(dataPaths);
        for (Map.Entry entry : libPackage2ModuleName.entrySet()) {
            String libPackage = (String)entry.getKey();
            String moduleName = (String)entry.getValue();
            File libPackageJarFile = new File(libPackage);
            assert (AndroidPreDexBuilder.canBePreDexed(libPackageJarFile));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, libPackageJarFile, true, false));
            result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, new File(new File(preDexOutputDir, moduleName), libPackageJarFile.getName()), true, true));
        }
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(this.myModule, null, null);
        if (platform != null) {
            for (String jarOrLibDir : AndroidJpsUtil.getExternalLibraries(dataPaths, this.myModule, platform, false, false, true)) {
                String preDexedFileName;
                File file;
                File preDexedFile = file = new File(jarOrLibDir);
                if (AndroidPreDexBuilder.canBePreDexed(file) && (preDexedFileName = AndroidPreDexBuilder.getOutputFileNameForExternalJar(file)) != null) {
                    preDexedFile = new File(preDexOutputDir, preDexedFileName);
                }
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, file, false, false));
                result.add((BuildRootDescriptor)new MyJarBuildRootDescriptor(this, preDexedFile, false, true));
            }
        }
        for (String path : AndroidJpsUtil.getProvidedLibraries(dataPaths, this.myModule)) {
            result.add((BuildRootDescriptor)new MyProvidedJarBuildRootDescriptor(this, new File(path)));
        }
        return result;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputFile(context));
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        return AndroidDexBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
    }

    @NotNull
    public static File getOutputFile(@NotNull BuildDataPaths dataPaths, @NotNull JpsModule module) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir, "classes.dex");
    }

    @Override
    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry registry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList(super.computeDependencies(registry, outputIndex));
        result.add(new AndroidAarDepsBuildTarget(this.myModule));
        result.add(new AndroidPreDexBuildTarget(this.myModule.getProject()));
        return result;
    }

    public static class MyJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        private final boolean myLibPackage;
        private final boolean myPreDexed;

        public MyJarBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File file, boolean libPackage, boolean preDexed) {
            super(target, file);
            this.myLibPackage = libPackage;
            this.myPreDexed = preDexed;
        }

        public boolean isLibPackage() {
            return this.myLibPackage;
        }

        public boolean isPreDexed() {
            return this.myPreDexed;
        }
    }

    public static class MyProvidedJarBuildRootDescriptor
    extends AndroidFileBasedBuildRootDescriptor {
        public MyProvidedJarBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File file) {
            super(target, file);
        }
    }

    public static class MyClassesDirBuildRootDescriptor
    extends AndroidClassesDirBuildRootDescriptor {
        private final ClassesDirType myClassesDirType;

        public MyClassesDirBuildRootDescriptor(@NotNull BuildTarget target, @NotNull File root, @NotNull ClassesDirType classesDirType) {
            super(target, root);
            this.myClassesDirType = classesDirType;
        }

        @NotNull
        public ClassesDirType getClassesDirType() {
            return this.myClassesDirType;
        }
    }

    public static enum ClassesDirType {
        ANDROID_APP,
        ANDROID_LIB,
        JAVA;

    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-dex", "DEX");
        }

        @Override
        public AndroidDexBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            return !extension.isLibrary() ? new AndroidDexBuildTarget(extension.getModule()) : null;
        }
    }
}

