/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.icu.impl.CacheValue;
import android.icu.text.DecimalFormatSymbols;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.System_Delegate;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;

public class ZygoteHooks {
    private static long token;

    private ZygoteHooks() {
    }

    public static void startZygoteNoThreadCreation() {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#startZygoteNoThreadCreation()V", true, null);
    }

    public static void onBeginPreload() {
        ULocale[] localesToPin;
        CacheValue.setStrength(CacheValue.Strength.STRONG);
        for (ULocale uLocale : localesToPin = new ULocale[]{ULocale.ROOT, ULocale.US, ULocale.getDefault()}) {
            new DecimalFormatSymbols(uLocale);
        }
        TimeZone.getDefault();
    }

    public static void onEndPreload() {
        CacheValue.setStrength(CacheValue.Strength.SOFT);
        FileDescriptor.in.cloneForFork();
        FileDescriptor.out.cloneForFork();
        FileDescriptor.err.cloneForFork();
    }

    public static void gcAndFinalize() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
    }

    public static void stopZygoteNoThreadCreation() {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#stopZygoteNoThreadCreation()V", true, null);
    }

    public static void preFork() {
        Daemons.stop();
        token = ZygoteHooks.nativePreFork();
        ZygoteHooks.waitUntilAllThreadsStopped();
    }

    public static void postForkSystemServer(int runtimeFlags) {
        ZygoteHooks.nativePostForkSystemServer(runtimeFlags);
    }

    public static void postForkChild(int runtimeFlags, boolean isSystemServer, boolean isZygote, String instructionSet) {
        ZygoteHooks.nativePostForkChild(token, runtimeFlags, isSystemServer, isZygote, instructionSet);
        Math.setRandomSeedInternal((long)System_Delegate.currentTimeMillis());
    }

    public static void postForkCommon() {
        ZygoteHooks.nativePostZygoteFork();
        Daemons.startPostZygoteFork();
    }

    private static void nativePostForkSystemServer(int n) {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#nativePostForkSystemServer(I)V", true, null);
    }

    private static long nativePreFork() {
        return OverrideMethod.invokeL("dalvik.system.ZygoteHooks#nativePreFork()J", true, null);
    }

    private static void nativePostZygoteFork() {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#nativePostZygoteFork()V", true, null);
    }

    private static void nativePostForkChild(long l, int n, boolean bl, boolean bl2, String string2) {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#nativePostForkChild(JIZZLjava/lang/String;)V", true, null);
    }

    private static void waitUntilAllThreadsStopped() {
        File tasks = new File("/proc/self/task");
        while (tasks.list().length > 1) {
            Thread.yield();
        }
    }
}

