/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.VMRuntime;
import java.lang.reflect.Array;

public class VMRuntime_Delegate {
    @LayoutlibDelegate
    static Object newUnpaddedArray(VMRuntime runtime, Class<?> componentType, int minLength) {
        if (!componentType.isPrimitive()) {
            int size = (minLength & 1) == 0 ? minLength + 1 : minLength;
            return Array.newInstance(componentType, size);
        }
        if (componentType == Character.TYPE) {
            int bytes = 20 + 2 * minLength;
            int alignedUpBytes = bytes + 7 & 0xFFFFFFF8;
            int dataBytes = alignedUpBytes - 20;
            int size = dataBytes / 2;
            return new char[size];
        }
        if (componentType == Integer.TYPE) {
            int size = (minLength & 1) == 0 ? minLength + 1 : minLength;
            return new int[size];
        }
        if (componentType == Byte.TYPE) {
            int dataBytes;
            int bytes = 20 + minLength;
            int alignedUpBytes = bytes + 7 & 0xFFFFFFF8;
            int size = dataBytes = alignedUpBytes - 20;
            return new byte[size];
        }
        if (componentType == Boolean.TYPE) {
            int dataBytes;
            int bytes = 20 + minLength;
            int alignedUpBytes = bytes + 7 & 0xFFFFFFF8;
            int size = dataBytes = alignedUpBytes - 20;
            return new boolean[size];
        }
        if (componentType == Short.TYPE) {
            int bytes = 20 + 2 * minLength;
            int alignedUpBytes = bytes + 7 & 0xFFFFFFF8;
            int dataBytes = alignedUpBytes - 20;
            int size = dataBytes / 2;
            return new short[size];
        }
        if (componentType == Float.TYPE) {
            int size = (minLength & 1) == 0 ? minLength + 1 : minLength;
            return new float[size];
        }
        if (componentType == Long.TYPE) {
            return new long[minLength];
        }
        if (componentType == Double.TYPE) {
            return new double[minLength];
        }
        assert (componentType == Void.TYPE);
        throw new IllegalArgumentException("Can't allocate an array of void");
    }

    @LayoutlibDelegate
    static int getNotifyNativeInterval() {
        return 1;
    }
}

