/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.replacements;

import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AndroidFrameworkProtos;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Rect {
    public static final Rect EMPTY = new Rect(0, 0, 0, 0);
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public Rect(int left, int top, int right, int bottom) {
        this.left = Math.min(left, right);
        this.top = Math.min(top, bottom);
        this.right = Math.max(left, right);
        this.bottom = Math.max(top, bottom);
    }

    public Rect(AndroidFrameworkProtos.RectProto rectProto) {
        this(rectProto.getLeft(), rectProto.getTop(), rectProto.getRight(), rectProto.getBottom());
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getWidth() {
        return this.right - this.left;
    }

    public int getHeight() {
        return this.bottom - this.top;
    }

    public boolean contains(Rect r) {
        return !this.isEmpty() && this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    public boolean isEmpty() {
        return this.left == this.right || this.top == this.bottom;
    }

    public AndroidFrameworkProtos.RectProto toProto() {
        AndroidFrameworkProtos.RectProto.Builder builder = AndroidFrameworkProtos.RectProto.newBuilder();
        builder.setLeft(this.left);
        builder.setTop(this.top);
        builder.setRight(this.right);
        builder.setBottom(this.bottom);
        return (AndroidFrameworkProtos.RectProto)builder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Rect.class != o.getClass()) {
            return false;
        }
        Rect r = (Rect)o;
        return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
    }

    public int hashCode() {
        int result = this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.right;
        result = 31 * result + this.bottom;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Rect(");
        sb.append(this.left);
        sb.append(", ");
        sb.append(this.top);
        sb.append(" - ");
        sb.append(this.right);
        sb.append(", ");
        sb.append(this.bottom);
        sb.append(")");
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[');
        sb.append(this.left);
        sb.append(',');
        sb.append(this.top);
        sb.append("][");
        sb.append(this.right);
        sb.append(',');
        sb.append(this.bottom);
        sb.append(']');
        return sb.toString();
    }

    public static boolean intersects(Rect a, Rect b) {
        return a.top < b.bottom && b.top < a.bottom && a.left < b.right && b.left < a.right;
    }
}

