/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class ClusteringUtils {
    public static final Similarity<AccessibilityHierarchyCheckResult> SIMILAR_RESULTS = new ResultSimilarity(ViewHierarchyElement::getResourceName);
    public static final Similarity<AccessibilityHierarchyCheckResult> SIMILAR_RESULTS_NEAREST_ANCESTOR_RELATION = new ResultSimilarity(vhe -> ClusteringUtils.getPseudoResourceId(vhe, true));
    public static final Similarity<AccessibilityHierarchyCheckResult> SIMILAR_RESULTS_NEAREST_ANCESTOR_CHAIN = new ResultSimilarity(vhe -> ClusteringUtils.getPseudoResourceId(vhe, false));

    private ClusteringUtils() {
    }

    public static <T> List<List<T>> cluster(Collection<T> values, Similarity<T> similarity) {
        ArrayList<List<T>> clusters = new ArrayList<List<T>>();
        for (T value : values) {
            boolean alreadySeen = false;
            for (List list : clusters) {
                if (!similarity.test(list.get(0), value)) continue;
                list.add(value);
                alreadySeen = true;
                break;
            }
            if (alreadySeen) continue;
            clusters.add(Lists.newArrayList((Object[])new Object[]{value}));
        }
        return clusters;
    }

    @Pure
    public static @Nullable String getPseudoResourceId(ViewHierarchyElement vhe, boolean includeIndices) {
        if (vhe.getResourceName() != null) {
            return vhe.getResourceName();
        }
        StringBuilder resourceId = ClusteringUtils.getResourceIdBuilder(vhe, includeIndices);
        return resourceId == null ? null : resourceId.toString();
    }

    private static @Nullable StringBuilder getResourceIdBuilder(ViewHierarchyElement vhe, boolean includeIndices) {
        StringBuilder parentResourceId;
        String resourceName = vhe.getResourceName();
        if (resourceName != null) {
            return new StringBuilder(resourceName);
        }
        ViewHierarchyElement parent = vhe.getParentView();
        if (parent != null && (parentResourceId = ClusteringUtils.getResourceIdBuilder(parent, includeIndices)) != null) {
            int childCount = parent.getChildViewCount();
            for (int i = 0; i < childCount; ++i) {
                if (parent.getChildView(i) != vhe) continue;
                CharSequence shortClassName = ClusteringUtils.getShortClassName(vhe);
                if (shortClassName != null) {
                    parentResourceId.append('/').append(shortClassName);
                    if (includeIndices) {
                        parentResourceId.append('[').append(i).append(']');
                    }
                } else if (includeIndices) {
                    parentResourceId.append(":nth-child(").append(i).append(')');
                } else {
                    parentResourceId.append(":child");
                }
                return parentResourceId;
            }
        }
        return null;
    }

    private static @Nullable CharSequence getShortClassName(ViewHierarchyElement vhe) {
        CharSequence className = vhe.getClassName();
        if (className != null) {
            return ClusteringUtils.simpleClassName(className);
        }
        className = vhe.getAccessibilityClassName();
        if (className != null) {
            return ClusteringUtils.simpleClassName(className);
        }
        return null;
    }

    private static CharSequence simpleClassName(CharSequence className) {
        for (int i = className.length() - 1; i > 0; --i) {
            char ithChar = className.charAt(i);
            if (ithChar != '.' && ithChar != '$') continue;
            return className.subSequence(i + 1, className.length());
        }
        return className;
    }

    private static class ResultSimilarity
    implements Similarity<AccessibilityHierarchyCheckResult> {
        private final ResourceIdGenerator idGenerator;

        ResultSimilarity(ResourceIdGenerator idGenerator) {
            this.idGenerator = idGenerator;
        }

        @Override
        public boolean test(AccessibilityHierarchyCheckResult result1, AccessibilityHierarchyCheckResult result2) {
            String resourceId1;
            ViewHierarchyElement vhe1 = result1.getElement();
            ViewHierarchyElement vhe2 = result2.getElement();
            if (Objects.equals((Object)result1.getType(), (Object)result2.getType()) && Objects.equals(result1.getSourceCheckClass(), result2.getSourceCheckClass()) && result1.getResultId() == result2.getResultId() && vhe1 != null && vhe2 != null && (resourceId1 = this.idGenerator.apply(vhe1)) != null) {
                return resourceId1.equals(this.idGenerator.apply(vhe2));
            }
            return false;
        }
    }

    public static interface ResourceIdGenerator {
        public @Nullable String apply(ViewHierarchyElement var1);
    }

    public static interface Similarity<T> {
        public boolean test(T var1, T var2);
    }
}

