/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.ScrollCaptureViewHelper;

public class ScrollViewCaptureHelper
implements ScrollCaptureViewHelper<ViewGroup> {
    private int mStartScrollY;
    private boolean mScrollBarEnabled;
    private int mOverScrollMode;

    @Override
    public void onPrepareForStart(ViewGroup view, Rect scrollBounds) {
        this.mStartScrollY = view.getScrollY();
        this.mOverScrollMode = view.getOverScrollMode();
        if (this.mOverScrollMode != 2) {
            view.setOverScrollMode(2);
        }
        this.mScrollBarEnabled = view.isVerticalScrollBarEnabled();
        if (this.mScrollBarEnabled) {
            view.setVerticalScrollBarEnabled(false);
        }
    }

    @Override
    public Rect onScrollRequested(ViewGroup view, Rect scrollBounds, Rect requestRect) {
        View contentView = view.getChildAt(0);
        if (contentView == null) {
            return null;
        }
        int scrollDelta = view.getScrollY() - this.mStartScrollY;
        Rect requestedContainerBounds = new Rect(requestRect);
        requestedContainerBounds.offset(0, -scrollDelta);
        requestedContainerBounds.offset(scrollBounds.left, scrollBounds.top);
        Rect requestedContentBounds = new Rect(requestedContainerBounds);
        requestedContentBounds.offset(view.getScrollX() - contentView.getLeft(), view.getScrollY() - contentView.getTop());
        contentView.requestRectangleOnScreen(new Rect(requestedContentBounds), true);
        scrollDelta = view.getScrollY() - this.mStartScrollY;
        Point offset = new Point();
        Rect capturedRect = new Rect(requestedContentBounds);
        if (!view.getChildVisibleRect(contentView, capturedRect, offset)) {
            capturedRect.setEmpty();
            return capturedRect;
        }
        capturedRect.offset(-offset.x, -offset.y);
        capturedRect.offset(contentView.getLeft() - view.getScrollX(), contentView.getTop() - view.getScrollY());
        capturedRect.offset(-scrollBounds.left, -scrollBounds.top);
        capturedRect.offset(0, scrollDelta);
        return capturedRect;
    }

    @Override
    public void onPrepareForEnd(ViewGroup view) {
        view.scrollTo(0, this.mStartScrollY);
        if (this.mOverScrollMode != 2) {
            view.setOverScrollMode(this.mOverScrollMode);
        }
        if (this.mScrollBarEnabled) {
            view.setVerticalScrollBarEnabled(true);
        }
    }
}

