/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.RenderNode;
import android.os.Handler;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureSession;
import android.view.Surface;
import android.view.View;
import com.android.internal.view.ScrollCaptureViewHelper;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public class ScrollCaptureViewSupport<V extends View>
implements ScrollCaptureCallback {
    private final WeakReference<V> mWeakView;
    private final ScrollCaptureViewHelper<V> mViewHelper;
    private ViewRenderer mRenderer;
    private Handler mUiHandler;
    private boolean mStarted;
    private boolean mEnded;

    static <V extends View> ScrollCaptureCallback createCallback(V view, ScrollCaptureViewHelper<V> impl) {
        return new ScrollCaptureViewSupport<V>(view, impl);
    }

    ScrollCaptureViewSupport(V containingView, ScrollCaptureViewHelper<V> viewHelper) {
        this.mWeakView = new WeakReference<V>(containingView);
        this.mRenderer = new ViewRenderer();
        this.mUiHandler = ((View)containingView).getHandler();
        this.mViewHelper = viewHelper;
    }

    @Override
    public void onScrollCaptureSearch(Consumer<Rect> onReady) {
        View view = (View)this.mWeakView.get();
        this.mStarted = false;
        this.mEnded = false;
        if (view != null && view.isVisibleToUser() && this.mViewHelper.onAcceptSession(view)) {
            onReady.accept(this.mViewHelper.onComputeScrollBounds(view));
            return;
        }
        onReady.accept(null);
    }

    @Override
    public void onScrollCaptureStart(ScrollCaptureSession session, Runnable onReady) {
        View view = (View)this.mWeakView.get();
        this.mEnded = false;
        this.mStarted = true;
        if (view != null && view.isVisibleToUser()) {
            this.mRenderer.setSurface(session.getSurface());
            this.mViewHelper.onPrepareForStart(view, session.getScrollBounds());
        }
        onReady.run();
    }

    @Override
    public void onScrollCaptureImageRequest(ScrollCaptureSession session, Rect requestRect) {
        View view = (View)this.mWeakView.get();
        if (view == null || !view.isVisibleToUser()) {
            session.notifyBufferSent(0L, null);
            return;
        }
        Rect captureArea = this.mViewHelper.onScrollRequested(view, session.getScrollBounds(), requestRect);
        this.mRenderer.renderFrame(view, captureArea, this.mUiHandler, () -> session.notifyBufferSent(0L, captureArea));
    }

    @Override
    public void onScrollCaptureEnd(Runnable onReady) {
        View view = (View)this.mWeakView.get();
        if (this.mStarted && !this.mEnded) {
            this.mViewHelper.onPrepareForEnd(view);
            this.mEnded = true;
            this.mRenderer.trimMemory();
            this.mRenderer.setSurface(null);
        }
        onReady.run();
    }

    static class ViewRenderer {
        private static final float AMBIENT_SHADOW_ALPHA = 0.039f;
        private static final float SPOT_SHADOW_ALPHA = 0.039f;
        private static final float LIGHT_Z_DP = 400.0f;
        private static final float LIGHT_RADIUS_DP = 800.0f;
        private static final String TAG = "ViewRenderer";
        private HardwareRenderer mRenderer;
        private RenderNode mRootRenderNode;
        private final RectF mTempRectF = new RectF();
        private final Rect mSourceRect = new Rect();
        private final Rect mTempRect = new Rect();
        private final Matrix mTempMatrix = new Matrix();
        private final int[] mTempLocation = new int[2];
        private long mLastRenderedSourceDrawingId = -1L;

        ViewRenderer() {
            this.mRenderer = new HardwareRenderer();
            this.mRootRenderNode = new RenderNode("ScrollCaptureRoot");
            this.mRenderer.setContentRoot(this.mRootRenderNode);
            this.mRenderer.setOpaque(false);
        }

        public void setSurface(Surface surface) {
            this.mRenderer.setSurface(surface);
        }

        private boolean updateForView(View source) {
            if (this.mLastRenderedSourceDrawingId == source.getUniqueDrawingId()) {
                return false;
            }
            this.mLastRenderedSourceDrawingId = source.getUniqueDrawingId();
            return true;
        }

        private void setupLighting(View mSource) {
            this.mLastRenderedSourceDrawingId = mSource.getUniqueDrawingId();
            DisplayMetrics metrics = mSource.getResources().getDisplayMetrics();
            mSource.getLocationOnScreen(this.mTempLocation);
            float lightX = (float)metrics.widthPixels / 2.0f - (float)this.mTempLocation[0];
            float lightY = metrics.heightPixels - this.mTempLocation[1];
            int lightZ = (int)(400.0f * metrics.density);
            int lightRadius = (int)(800.0f * metrics.density);
            this.mRenderer.setLightSourceGeometry(lightX, lightY, lightZ, lightRadius);
            this.mRenderer.setLightSourceAlpha(0.039f, 0.039f);
        }

        public void renderFrame(View localReference, Rect sourceRect, Handler handler, Runnable onFrameCommitted) {
            if (this.updateForView(localReference)) {
                this.setupLighting(localReference);
            }
            this.buildRootDisplayList(localReference, sourceRect);
            HardwareRenderer.FrameRenderRequest request = this.mRenderer.createRenderRequest();
            request.setVsyncTime(SystemClock.elapsedRealtimeNanos());
            request.setFrameCommitCallback(handler::post, onFrameCommitted);
            request.setWaitForPresent(true);
            request.syncAndDraw();
        }

        public void trimMemory() {
            this.mRenderer.clearContent();
        }

        public void destroy() {
            this.mRenderer.destroy();
        }

        private void transformToRoot(View local, Rect localRect, Rect outRect) {
            this.mTempMatrix.reset();
            local.transformMatrixToGlobal(this.mTempMatrix);
            this.mTempRectF.set(localRect);
            this.mTempMatrix.mapRect(this.mTempRectF);
            this.mTempRectF.round(outRect);
        }

        private void buildRootDisplayList(View source, Rect localSourceRect) {
            View captureSource = source.getRootView();
            this.transformToRoot(source, localSourceRect, this.mTempRect);
            this.mRootRenderNode.setPosition(0, 0, this.mTempRect.width(), this.mTempRect.height());
            RecordingCanvas canvas = this.mRootRenderNode.beginRecording(this.mTempRect.width(), this.mTempRect.height());
            canvas.translate(-this.mTempRect.left, -this.mTempRect.top);
            canvas.drawRenderNode(captureSource.updateDisplayListIfDirty());
            this.mRootRenderNode.endRecording();
        }
    }
}

