/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.ScrollCaptureCallback;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.ScrollCaptureViewSupport;
import com.android.internal.view.ScrollViewCaptureHelper;

public class ScrollCaptureInternal {
    private static final String TAG = "ScrollCaptureInternal";
    private static final int UP = -1;
    private static final int DOWN = 1;
    public static final int TYPE_FIXED = 0;
    public static final int TYPE_SCROLLING = 1;
    public static final int TYPE_RECYCLING = 2;

    public static int detectScrollingType(View view) {
        if (!(view instanceof ViewGroup)) {
            return 0;
        }
        if (!view.canScrollVertically(1) && !view.canScrollVertically(-1)) {
            return 0;
        }
        if (((ViewGroup)view).getChildCount() > 1) {
            return 2;
        }
        if (view.getScrollY() != 0) {
            return 1;
        }
        if (view.canScrollVertically(-1)) {
            return 2;
        }
        view.scrollTo(view.getScrollX(), 1);
        if (view.getScrollY() == 1) {
            view.scrollTo(view.getScrollX(), 0);
            return 1;
        }
        return 2;
    }

    public ScrollCaptureCallback requestCallback(View view, Rect localVisibleRect, Point positionInWindow) {
        int i = ScrollCaptureInternal.detectScrollingType(view);
        switch (i) {
            case 1: {
                return new ScrollCaptureViewSupport<ViewGroup>((ViewGroup)view, new ScrollViewCaptureHelper());
            }
        }
        return null;
    }
}

