/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityTaskManager;
import android.app.TaskStackListener;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.input.InputManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.KeyEvent;
import android.view.WindowManagerGlobal;
import android.view.inputmethod.InputMethodManager;
import android.window.TaskEmbedder;
import java.util.List;

public class VirtualDisplayTaskEmbedder
extends TaskEmbedder {
    private static final String TAG = "VirDispTaskEmbedder";
    private static final String DISPLAY_NAME = "TaskVirtualDisplay";
    private int mDisplayDensityDpi;
    private final boolean mSingleTaskInstance;
    private final boolean mUsePublicVirtualDisplay;
    private final boolean mUseTrustedDisplay;
    private VirtualDisplay mVirtualDisplay;
    private Insets mForwardedInsets;
    private DisplayMetrics mTmpDisplayMetrics;
    private TaskStackListener mTaskStackListener;

    public VirtualDisplayTaskEmbedder(Context context, TaskEmbedder.Host host, boolean singleTaskInstance, boolean usePublicVirtualDisplay, boolean useTrustedDisplay) {
        super(context, host);
        this.mSingleTaskInstance = singleTaskInstance;
        this.mUsePublicVirtualDisplay = usePublicVirtualDisplay;
        this.mUseTrustedDisplay = useTrustedDisplay;
    }

    @Override
    public boolean isInitialized() {
        return this.mVirtualDisplay != null;
    }

    @Override
    public boolean onInitialize() {
        DisplayManager displayManager = this.mContext.getSystemService(DisplayManager.class);
        this.mDisplayDensityDpi = this.getBaseDisplayDensity();
        int virtualDisplayFlags = 264;
        if (this.mUsePublicVirtualDisplay) {
            virtualDisplayFlags |= 1;
        }
        if (this.mUseTrustedDisplay) {
            virtualDisplayFlags |= 0x400;
        }
        this.mVirtualDisplay = displayManager.createVirtualDisplay("TaskVirtualDisplay@" + System.identityHashCode(this), this.mHost.getWidth(), this.mHost.getHeight(), this.mDisplayDensityDpi, null, virtualDisplayFlags);
        if (this.mVirtualDisplay == null) {
            Log.e(TAG, "Failed to initialize TaskEmbedder");
            return false;
        }
        try {
            int displayId = this.getDisplayId();
            IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
            WindowManagerGlobal.getWindowSession().reparentDisplayContent(this.mHost.getWindow(), this.mSurfaceControl, displayId);
            wm.dontOverrideDisplayInfo(displayId);
            if (this.mSingleTaskInstance) {
                this.mContext.getSystemService(ActivityTaskManager.class).setDisplayToSingleTaskInstance(displayId);
            }
            this.setForwardedInsets(this.mForwardedInsets);
            this.mTaskStackListener = new TaskStackListenerImpl();
            this.mActivityTaskManager.registerTaskStackListener(this.mTaskStackListener);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        return super.onInitialize();
    }

    @Override
    protected boolean onRelease() {
        super.onRelease();
        this.clearActivityViewGeometryForIme();
        if (this.mTaskStackListener != null) {
            try {
                this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to unregister task stack listener", e);
            }
            this.mTaskStackListener = null;
        }
        if (this.isInitialized()) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        super.start();
        if (this.isInitialized()) {
            this.mVirtualDisplay.setDisplayState(true);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.isInitialized()) {
            this.mVirtualDisplay.setDisplayState(false);
            this.clearActivityViewGeometryForIme();
        }
    }

    @Override
    public void resizeTask(int width, int height) {
        this.mDisplayDensityDpi = this.getBaseDisplayDensity();
        if (this.isInitialized()) {
            this.mVirtualDisplay.resize(width, height, this.mDisplayDensityDpi);
        }
    }

    @Override
    public void performBackPress() {
        if (!this.isInitialized()) {
            return;
        }
        int displayId = this.mVirtualDisplay.getDisplay().getDisplayId();
        InputManager im = InputManager.getInstance();
        im.injectInputEvent(VirtualDisplayTaskEmbedder.createKeyEvent(0, 4, displayId), 0);
        im.injectInputEvent(VirtualDisplayTaskEmbedder.createKeyEvent(1, 4, displayId), 0);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        this.notifyBoundsChanged();
        return super.gatherTransparentRegion(region);
    }

    @Override
    public int getId() {
        return this.getDisplayId();
    }

    @Override
    public int getDisplayId() {
        if (this.isInitialized()) {
            return this.mVirtualDisplay.getDisplay().getDisplayId();
        }
        return -1;
    }

    @Override
    public VirtualDisplay getVirtualDisplay() {
        if (this.isInitialized()) {
            return this.mVirtualDisplay;
        }
        return null;
    }

    @Override
    protected ActivityOptions prepareActivityOptions(ActivityOptions options) {
        options = super.prepareActivityOptions(options);
        options.setLaunchDisplayId(this.getDisplayId());
        return options;
    }

    @Override
    public void setForwardedInsets(Insets insets) {
        this.mForwardedInsets = insets;
        if (!this.isInitialized()) {
            return;
        }
        try {
            IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
            wm.setForwardedInsets(this.getDisplayId(), this.mForwardedInsets);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @Override
    protected void updateLocationAndTapExcludeRegion() {
        super.updateLocationAndTapExcludeRegion();
        if (!this.isInitialized() || this.mHost.getWindow() == null) {
            return;
        }
        this.reportLocation(this.mHost.getScreenToTaskMatrix(), this.mHost.getPositionInWindow());
    }

    private void reportLocation(Matrix screenToViewMatrix, Point positionInWindow) {
        try {
            int displayId = this.getDisplayId();
            this.mContext.getSystemService(InputMethodManager.class).reportActivityView(displayId, screenToViewMatrix);
            IWindowSession session = WindowManagerGlobal.getWindowSession();
            session.updateDisplayContentLocation(this.mHost.getWindow(), positionInWindow.x, positionInWindow.y, displayId);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void clearActivityViewGeometryForIme() {
        int displayId = this.getDisplayId();
        this.mContext.getSystemService(InputMethodManager.class).reportActivityView(displayId, null);
    }

    private static KeyEvent createKeyEvent(int action, int code, int displayId) {
        long when = SystemClock.uptimeMillis();
        KeyEvent ev = new KeyEvent(when, when, action, code, 0, 0, -1, 0, 72, 257);
        ev.setDisplayId(displayId);
        return ev;
    }

    private int getBaseDisplayDensity() {
        return this.mContext.getResources().getConfiguration().densityDpi;
    }

    private class TaskStackListenerImpl
    extends TaskStackListener {
        private TaskStackListenerImpl() {
        }

        @Override
        public void onTaskDescriptionChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
            if (!VirtualDisplayTaskEmbedder.this.isInitialized()) {
                return;
            }
            if (taskInfo.displayId != VirtualDisplayTaskEmbedder.this.getDisplayId()) {
                return;
            }
            ActivityManager.StackInfo stackInfo = this.getTopMostStackInfo();
            if (stackInfo == null) {
                return;
            }
            if (taskInfo.taskId == stackInfo.taskIds[stackInfo.taskIds.length - 1]) {
                VirtualDisplayTaskEmbedder.this.mHost.post(() -> VirtualDisplayTaskEmbedder.this.mHost.onTaskBackgroundColorChanged(VirtualDisplayTaskEmbedder.this, taskInfo.taskDescription.getBackgroundColor()));
            }
        }

        @Override
        public void onTaskMovedToFront(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
            if (!VirtualDisplayTaskEmbedder.this.isInitialized() || VirtualDisplayTaskEmbedder.this.mListener == null || taskInfo.displayId != VirtualDisplayTaskEmbedder.this.getDisplayId()) {
                return;
            }
            ActivityManager.StackInfo stackInfo = this.getTopMostStackInfo();
            if (stackInfo != null && taskInfo.taskId == stackInfo.taskIds[stackInfo.taskIds.length - 1]) {
                VirtualDisplayTaskEmbedder.this.mListener.onTaskMovedToFront(taskInfo.taskId);
            }
        }

        @Override
        public void onTaskCreated(int taskId, ComponentName componentName) throws RemoteException {
            if (VirtualDisplayTaskEmbedder.this.mListener == null || !VirtualDisplayTaskEmbedder.this.isInitialized()) {
                return;
            }
            ActivityManager.StackInfo stackInfo = this.getTopMostStackInfo();
            if (stackInfo != null && taskId == stackInfo.taskIds[stackInfo.taskIds.length - 1]) {
                VirtualDisplayTaskEmbedder.this.mListener.onTaskCreated(taskId, componentName);
            }
        }

        @Override
        public void onTaskRemovalStarted(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
            if (VirtualDisplayTaskEmbedder.this.mListener == null || !VirtualDisplayTaskEmbedder.this.isInitialized() || taskInfo.displayId != VirtualDisplayTaskEmbedder.this.getDisplayId()) {
                return;
            }
            VirtualDisplayTaskEmbedder.this.mListener.onTaskRemovalStarted(taskInfo.taskId);
        }

        private ActivityManager.StackInfo getTopMostStackInfo() throws RemoteException {
            int displayId = VirtualDisplayTaskEmbedder.this.getDisplayId();
            List<ActivityManager.StackInfo> stackInfoList = VirtualDisplayTaskEmbedder.this.mActivityTaskManager.getAllStackInfosOnDisplay(displayId);
            if (stackInfoList.isEmpty()) {
                return null;
            }
            return stackInfoList.get(0);
        }
    }
}

