/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Map;

public class WebResourceResponse {
    @UnsupportedAppUsage
    private boolean mImmutable;
    private String mMimeType;
    private String mEncoding;
    @UnsupportedAppUsage
    private int mStatusCode;
    private String mReasonPhrase;
    private Map<String, String> mResponseHeaders;
    private InputStream mInputStream;

    public WebResourceResponse(String mimeType, String encoding, InputStream data) {
        this.mMimeType = mimeType;
        this.mEncoding = encoding;
        this.setData(data);
    }

    public WebResourceResponse(String mimeType, String encoding, int statusCode, String reasonPhrase, Map<String, String> responseHeaders, InputStream data) {
        this(mimeType, encoding, data);
        this.setStatusCodeAndReasonPhrase(statusCode, reasonPhrase);
        this.setResponseHeaders(responseHeaders);
    }

    public void setMimeType(String mimeType) {
        this.checkImmutable();
        this.mMimeType = mimeType;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public void setEncoding(String encoding) {
        this.checkImmutable();
        this.mEncoding = encoding;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setStatusCodeAndReasonPhrase(int statusCode, String reasonPhrase) {
        this.checkImmutable();
        if (statusCode < 100) {
            throw new IllegalArgumentException("statusCode can't be less than 100.");
        }
        if (statusCode > 599) {
            throw new IllegalArgumentException("statusCode can't be greater than 599.");
        }
        if (statusCode > 299 && statusCode < 400) {
            throw new IllegalArgumentException("statusCode can't be in the [300, 399] range.");
        }
        if (reasonPhrase == null) {
            throw new IllegalArgumentException("reasonPhrase can't be null.");
        }
        if (reasonPhrase.trim().isEmpty()) {
            throw new IllegalArgumentException("reasonPhrase can't be empty.");
        }
        for (int i = 0; i < reasonPhrase.length(); ++i) {
            char c = reasonPhrase.charAt(i);
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("reasonPhrase can't contain non-ASCII characters.");
        }
        this.mStatusCode = statusCode;
        this.mReasonPhrase = reasonPhrase;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    public void setResponseHeaders(Map<String, String> headers) {
        this.checkImmutable();
        this.mResponseHeaders = headers;
    }

    public Map<String, String> getResponseHeaders() {
        return this.mResponseHeaders;
    }

    public void setData(InputStream data) {
        this.checkImmutable();
        if (data != null && StringBufferInputStream.class.isAssignableFrom(data.getClass())) {
            throw new IllegalArgumentException("StringBufferInputStream is deprecated and must not be passed to a WebResourceResponse");
        }
        this.mInputStream = data;
    }

    public InputStream getData() {
        return this.mInputStream;
    }

    @SystemApi
    public WebResourceResponse(boolean immutable, String mimeType, String encoding, int statusCode, String reasonPhrase, Map<String, String> responseHeaders, InputStream data) {
        this.mImmutable = immutable;
        this.mMimeType = mimeType;
        this.mEncoding = encoding;
        this.mStatusCode = statusCode;
        this.mReasonPhrase = reasonPhrase;
        this.mResponseHeaders = responseHeaders;
        this.mInputStream = data;
    }

    private void checkImmutable() {
        if (this.mImmutable) {
            throw new IllegalStateException("This WebResourceResponse instance is immutable");
        }
    }
}

