/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.view.shadow.AmbientShadowConfig;
import android.view.shadow.AmbientShadowVertexCalculator;
import com.android.layoutlib.bridge.Bridge;

class AmbientShadowTriangulator {
    private final AmbientShadowConfig mShadowConfig;
    private final AmbientShadowVertexCalculator mCalculator;
    private boolean mValid;

    public AmbientShadowTriangulator(AmbientShadowConfig shadowConfig) {
        this.mShadowConfig = shadowConfig;
        this.mCalculator = new AmbientShadowVertexCalculator(this.mShadowConfig);
    }

    public void triangulate() {
        try {
            this.mCalculator.generateVertex();
            this.mValid = true;
        }
        catch (ArithmeticException | IndexOutOfBoundsException mathError) {
            Bridge.getLog().warning("info", "Arithmetic error while drawing ambient shadow", null, (Object)mathError);
        }
        catch (Exception ex) {
            Bridge.getLog().warning("info", "Error while drawing shadow", null, (Object)ex);
        }
    }

    public boolean isValid() {
        return this.mValid;
    }

    public float[] getVertices() {
        return this.mCalculator.getVertex();
    }

    public int[] getIndices() {
        return this.mCalculator.getIndex();
    }

    public float[] getColors() {
        return this.mCalculator.getColor();
    }
}

