/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class TranslateAnimation
extends Animation {
    private int mFromXType = 0;
    private int mToXType = 0;
    private int mFromYType = 0;
    private int mToYType = 0;
    @UnsupportedAppUsage
    protected float mFromXValue = 0.0f;
    @UnsupportedAppUsage
    protected float mToXValue = 0.0f;
    @UnsupportedAppUsage
    protected float mFromYValue = 0.0f;
    @UnsupportedAppUsage
    protected float mToYValue = 0.0f;
    protected float mFromXDelta;
    protected float mToXDelta;
    protected float mFromYDelta;
    protected float mToYDelta;

    public TranslateAnimation(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TranslateAnimation);
        Animation.Description d = Animation.Description.parseValue(a.peekValue(0));
        this.mFromXType = d.type;
        this.mFromXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(1));
        this.mToXType = d.type;
        this.mToXValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(2));
        this.mFromYType = d.type;
        this.mFromYValue = d.value;
        d = Animation.Description.parseValue(a.peekValue(3));
        this.mToYType = d.type;
        this.mToYValue = d.value;
        a.recycle();
    }

    public TranslateAnimation(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta) {
        this.mFromXValue = fromXDelta;
        this.mToXValue = toXDelta;
        this.mFromYValue = fromYDelta;
        this.mToYValue = toYDelta;
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
    }

    public TranslateAnimation(int fromXType, float fromXValue, int toXType, float toXValue, int fromYType, float fromYValue, int toYType, float toYValue) {
        this.mFromXValue = fromXValue;
        this.mToXValue = toXValue;
        this.mFromYValue = fromYValue;
        this.mToYValue = toYValue;
        this.mFromXType = fromXType;
        this.mToXType = toXType;
        this.mFromYType = fromYType;
        this.mToYType = toYType;
    }

    @Override
    protected void applyTransformation(float interpolatedTime, Transformation t) {
        float dx = this.mFromXDelta;
        float dy = this.mFromYDelta;
        if (this.mFromXDelta != this.mToXDelta) {
            dx = this.mFromXDelta + (this.mToXDelta - this.mFromXDelta) * interpolatedTime;
        }
        if (this.mFromYDelta != this.mToYDelta) {
            dy = this.mFromYDelta + (this.mToYDelta - this.mFromYDelta) * interpolatedTime;
        }
        t.getMatrix().setTranslate(dx, dy);
    }

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mFromXDelta = this.resolveSize(this.mFromXType, this.mFromXValue, width, parentWidth);
        this.mToXDelta = this.resolveSize(this.mToXType, this.mToXValue, width, parentWidth);
        this.mFromYDelta = this.resolveSize(this.mFromYType, this.mFromYValue, height, parentHeight);
        this.mToYDelta = this.resolveSize(this.mToYType, this.mToYValue, height, parentHeight);
    }
}

