/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.ArraySet;
import android.util.Log;
import android.view.Display;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InsetsAnimationThread;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowLeaked;
import android.view.WindowManager;
import android.view.WindowManagerGlobal_Delegate;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.util.FastPrintWriter;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class WindowManagerGlobal {
    private static final String TAG = "WindowManager";
    private static boolean sUseBLASTAdapter = false;
    public static final int RELAYOUT_RES_IN_TOUCH_MODE = 1;
    public static final int RELAYOUT_RES_FIRST_TIME = 2;
    public static final int RELAYOUT_RES_SURFACE_CHANGED = 4;
    public static final int RELAYOUT_RES_DRAG_RESIZING_DOCKED = 8;
    public static final int RELAYOUT_RES_DRAG_RESIZING_FREEFORM = 16;
    public static final int RELAYOUT_RES_SURFACE_RESIZED = 32;
    public static final int RELAYOUT_RES_CONSUME_ALWAYS_SYSTEM_BARS = 64;
    public static final int RELAYOUT_RES_BLAST_SYNC = 128;
    public static final int RELAYOUT_INSETS_PENDING = 1;
    public static final int RELAYOUT_DEFER_SURFACE_DESTROY = 2;
    public static final int ADD_FLAG_IN_TOUCH_MODE = 1;
    public static final int ADD_FLAG_APP_VISIBLE = 2;
    public static final int ADD_FLAG_USE_TRIPLE_BUFFERING = 4;
    public static final int ADD_FLAG_USE_BLAST = 8;
    public static final int ADD_FLAG_ALWAYS_CONSUME_SYSTEM_BARS = 4;
    public static final int ADD_OKAY = 0;
    public static final int ADD_BAD_APP_TOKEN = -1;
    public static final int ADD_BAD_SUBWINDOW_TOKEN = -2;
    public static final int ADD_NOT_APP_TOKEN = -3;
    public static final int ADD_APP_EXITING = -4;
    public static final int ADD_DUPLICATE_ADD = -5;
    public static final int ADD_STARTING_NOT_NEEDED = -6;
    public static final int ADD_MULTIPLE_SINGLETON = -7;
    public static final int ADD_PERMISSION_DENIED = -8;
    public static final int ADD_INVALID_DISPLAY = -9;
    public static final int ADD_INVALID_TYPE = -10;
    public static final int ADD_INVALID_USER = -11;
    public static final int ADD_TOO_MANY_TOKENS = -12;
    @UnsupportedAppUsage
    private static WindowManagerGlobal sDefaultWindowManager;
    @UnsupportedAppUsage
    private static IWindowManager sWindowManagerService;
    @UnsupportedAppUsage
    private static IWindowSession sWindowSession;
    @UnsupportedAppUsage
    private final Object mLock = new Object();
    @UnsupportedAppUsage
    private final ArrayList<View> mViews = new ArrayList();
    @UnsupportedAppUsage
    private final ArrayList<ViewRootImpl> mRoots = new ArrayList();
    @UnsupportedAppUsage
    private final ArrayList<WindowManager.LayoutParams> mParams = new ArrayList();
    private final ArraySet<View> mDyingViews = new ArraySet();
    private Runnable mSystemPropertyUpdater;

    private WindowManagerGlobal() {
    }

    @UnsupportedAppUsage
    public static void initialize() {
        WindowManagerGlobal.getWindowManagerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static WindowManagerGlobal getInstance() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            if (sDefaultWindowManager == null) {
                sDefaultWindowManager = new WindowManagerGlobal();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultWindowManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static IWindowManager getWindowManagerService_Original() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            if (sWindowManagerService == null) {
                sWindowManagerService = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
                try {
                    if (sWindowManagerService != null) {
                        ValueAnimator.setDurationScale(sWindowManagerService.getCurrentAnimatorScale());
                        sUseBLASTAdapter = sWindowManagerService.useBLAST();
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWindowManagerService;
        }
    }

    @LayoutlibDelegate
    public static IWindowManager getWindowManagerService() {
        return WindowManagerGlobal_Delegate.getWindowManagerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static IWindowSession getWindowSession() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            if (sWindowSession == null) {
                try {
                    InputMethodManager.ensureDefaultInstanceForDefaultDisplayIfNecessary();
                    IWindowManager windowManager = WindowManagerGlobal.getWindowManagerService();
                    sWindowSession = windowManager.openSession(new IWindowSessionCallback.Stub(){

                        @Override
                        public void onAnimatorScaleChanged(float scale) {
                            ValueAnimator.setDurationScale(scale);
                        }
                    });
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWindowSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static IWindowSession peekWindowSession() {
        Class<WindowManagerGlobal> clazz = WindowManagerGlobal.class;
        synchronized (WindowManagerGlobal.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWindowSession;
        }
    }

    public static boolean useBLAST() {
        return sUseBLASTAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public String[] getViewRootNames() {
        Object object = this.mLock;
        synchronized (object) {
            int numRoots = this.mRoots.size();
            String[] mViewRoots = new String[numRoots];
            for (int i = 0; i < numRoots; ++i) {
                mViewRoots[i] = WindowManagerGlobal.getWindowName(this.mRoots.get(i));
            }
            return mViewRoots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ArrayList<ViewRootImpl> getRootViews(IBinder token) {
        ArrayList<ViewRootImpl> views = new ArrayList<ViewRootImpl>();
        Object object = this.mLock;
        synchronized (object) {
            int numRoots = this.mRoots.size();
            for (int i = 0; i < numRoots; ++i) {
                WindowManager.LayoutParams params = this.mParams.get(i);
                if (params.token == null) continue;
                if (params.token != token) {
                    boolean isChild = false;
                    if (params.type >= 1000 && params.type <= 1999) {
                        for (int j = 0; j < numRoots; ++j) {
                            View viewj = this.mViews.get(j);
                            WindowManager.LayoutParams paramsj = this.mParams.get(j);
                            if (params.token != viewj.getWindowToken() || paramsj.token != token) continue;
                            isChild = true;
                            break;
                        }
                    }
                    if (!isChild) continue;
                }
                views.add(this.mRoots.get(i));
            }
        }
        return views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<View> getWindowViews() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<View>(this.mViews);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getWindowView(IBinder windowToken) {
        Object object = this.mLock;
        synchronized (object) {
            int numViews = this.mViews.size();
            for (int i = 0; i < numViews; ++i) {
                View view = this.mViews.get(i);
                if (view.getWindowToken() != windowToken) continue;
                return view;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public View getRootView(String name) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mRoots.size() - 1; i >= 0; --i) {
                ViewRootImpl root = this.mRoots.get(i);
                if (!name.equals(WindowManagerGlobal.getWindowName(root))) continue;
                return root.getView();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addView(View view, ViewGroup.LayoutParams params, Display display, Window parentWindow, int userId) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        if (parentWindow != null) {
            parentWindow.adjustLayoutParamsForSubWindow(wparams);
        } else {
            Context context = view.getContext();
            if (context != null && (context.getApplicationInfo().flags & 0x20000000) != 0) {
                wparams.flags |= 0x1000000;
            }
        }
        View panelParentView = null;
        Object object = this.mLock;
        synchronized (object) {
            int index;
            if (this.mSystemPropertyUpdater == null) {
                this.mSystemPropertyUpdater = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = WindowManagerGlobal.this.mLock;
                        synchronized (object) {
                            for (int i = WindowManagerGlobal.this.mRoots.size() - 1; i >= 0; --i) {
                                ((ViewRootImpl)WindowManagerGlobal.this.mRoots.get(i)).loadSystemProperties();
                            }
                        }
                    }
                };
                SystemProperties.addChangeCallback(this.mSystemPropertyUpdater);
            }
            if ((index = this.findViewLocked(view, false)) >= 0) {
                if (this.mDyingViews.contains(view)) {
                    this.mRoots.get(index).doDie();
                } else {
                    throw new IllegalStateException("View " + view + " has already been added to the window manager.");
                }
            }
            if (wparams.type >= 1000 && wparams.type <= 1999) {
                int count = this.mViews.size();
                for (int i = 0; i < count; ++i) {
                    if (this.mRoots.get((int)i).mWindow.asBinder() != wparams.token) continue;
                    panelParentView = this.mViews.get(i);
                }
            }
            ViewRootImpl root = new ViewRootImpl(view.getContext(), display);
            view.setLayoutParams(wparams);
            this.mViews.add(view);
            this.mRoots.add(root);
            this.mParams.add(wparams);
            try {
                root.setView(view, wparams, panelParentView, userId);
            }
            catch (RuntimeException e) {
                if (index >= 0) {
                    this.removeViewLocked(index, true);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        if (!(params instanceof WindowManager.LayoutParams)) {
            throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
        view.setLayoutParams(wparams);
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findViewLocked(view, true);
            ViewRootImpl root = this.mRoots.get(index);
            this.mParams.remove(index);
            this.mParams.add(index, wparams);
            root.setLayoutParams(wparams, false);
        }
    }

    @UnsupportedAppUsage
    public void removeView(View view, boolean immediate) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findViewLocked(view, true);
            View curView = this.mRoots.get(index).getView();
            this.removeViewLocked(index, immediate);
            if (curView == view) {
                return;
            }
            throw new IllegalStateException("Calling with view " + view + " but the ViewAncestor is attached to " + curView);
        }
    }

    public void closeAll(IBinder token, String who, String what) {
        this.closeAllExceptView(token, null, who, what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllExceptView(IBinder token, View view, String who, String what) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mViews.size();
            for (int i = 0; i < count; ++i) {
                if (view != null && this.mViews.get(i) == view || token != null && this.mParams.get((int)i).token != token) continue;
                ViewRootImpl root = this.mRoots.get(i);
                if (who != null) {
                    WindowLeaked leak = new WindowLeaked(what + " " + who + " has leaked window " + root.getView() + " that was originally added here");
                    leak.setStackTrace(root.getLocation().getStackTrace());
                    Log.e(TAG, "", leak);
                }
                this.removeViewLocked(i, false);
            }
        }
    }

    private void removeViewLocked(int index, boolean immediate) {
        ViewRootImpl root = this.mRoots.get(index);
        View view = root.getView();
        if (root != null) {
            root.getImeFocusController().onWindowDismissed();
        }
        boolean deferred = root.die(immediate);
        if (view != null) {
            view.assignParent(null);
            if (deferred) {
                this.mDyingViews.add(view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveView(ViewRootImpl root) {
        boolean allViewsRemoved;
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mRoots.indexOf(root);
            if (index >= 0) {
                this.mRoots.remove(index);
                this.mParams.remove(index);
                View view = this.mViews.remove(index);
                this.mDyingViews.remove(view);
            }
            allViewsRemoved = this.mRoots.isEmpty();
        }
        if (ThreadedRenderer.sTrimForeground && ThreadedRenderer.isAvailable()) {
            this.doTrimForeground();
        }
        if (allViewsRemoved) {
            InsetsAnimationThread.release();
        }
    }

    private int findViewLocked(View view, boolean required) {
        int index = this.mViews.indexOf(view);
        if (required && index < 0) {
            throw new IllegalArgumentException("View=" + view + " not attached to window manager");
        }
        return index;
    }

    public static boolean shouldDestroyEglContext(int trimLevel) {
        if (trimLevel >= 80) {
            return true;
        }
        return trimLevel >= 60 && !ActivityManager.isHighEndGfx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    public void trimMemory(int level) {
        if (ThreadedRenderer.isAvailable()) {
            if (WindowManagerGlobal.shouldDestroyEglContext(level)) {
                Object object = this.mLock;
                synchronized (object) {
                    for (int i = this.mRoots.size() - 1; i >= 0; --i) {
                        this.mRoots.get(i).destroyHardwareResources();
                    }
                }
                level = 80;
            }
            ThreadedRenderer.trimMemory(level);
            if (ThreadedRenderer.sTrimForeground) {
                this.doTrimForeground();
            }
        }
    }

    public static void trimForeground() {
        if (ThreadedRenderer.sTrimForeground && ThreadedRenderer.isAvailable()) {
            WindowManagerGlobal wm = WindowManagerGlobal.getInstance();
            wm.doTrimForeground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTrimForeground() {
        boolean hasVisibleWindows = false;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mRoots.size() - 1; i >= 0; --i) {
                ViewRootImpl root = this.mRoots.get(i);
                if (root.mView != null && root.getHostVisibility() == 0 && root.mAttachInfo.mThreadedRenderer != null) {
                    hasVisibleWindows = true;
                    continue;
                }
                root.destroyHardwareResources();
            }
        }
        if (!hasVisibleWindows) {
            ThreadedRenderer.trimMemory(80);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpGfxInfo(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            Object object = this.mLock;
            synchronized (object) {
                int count = this.mViews.size();
                pw.println("Profile data in ms:");
                for (int i = 0; i < count; ++i) {
                    ViewRootImpl root = this.mRoots.get(i);
                    String name = WindowManagerGlobal.getWindowName(root);
                    pw.printf("\n\t%s (visibility=%d)", name, root.getHostVisibility());
                    ThreadedRenderer renderer = root.getView().mAttachInfo.mThreadedRenderer;
                    if (renderer == null) continue;
                    renderer.dumpGfxInfo(pw, fd, args);
                }
                pw.println("\nView hierarchy:\n");
                ViewRootImpl.GfxInfo totals = new ViewRootImpl.GfxInfo();
                for (int i = 0; i < count; ++i) {
                    ViewRootImpl root = this.mRoots.get(i);
                    ViewRootImpl.GfxInfo info = root.getGfxInfo();
                    totals.add(info);
                    String name = WindowManagerGlobal.getWindowName(root);
                    pw.printf("  %s\n  %d views, %.2f kB of render nodes", name, info.viewCount, Float.valueOf((float)info.renderNodeMemoryUsage / 1024.0f));
                    pw.printf("\n\n", new Object[0]);
                }
                pw.printf("\nTotal %-15s: %d\n", "ViewRootImpl", count);
                pw.printf("Total %-15s: %d\n", "attached Views", totals.viewCount);
                pw.printf("Total %-15s: %.2f kB (used) / %.2f kB (capacity)\n\n", "RenderNode", Float.valueOf((float)totals.renderNodeMemoryUsage / 1024.0f), Float.valueOf((float)totals.renderNodeMemoryAllocated / 1024.0f));
            }
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    private static String getWindowName(ViewRootImpl root) {
        return root.mWindowAttributes.getTitle() + "/" + root.getClass().getName() + '@' + Integer.toHexString(root.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedState(IBinder token, boolean stopped) {
        ArrayList<ViewRootImpl> nonCurrentThreadRoots = null;
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mViews.size();
            for (int i = count - 1; i >= 0; --i) {
                if (token != null && this.mParams.get((int)i).token != token) continue;
                ViewRootImpl root = this.mRoots.get(i);
                if (root.mThread == Thread.currentThread()) {
                    root.setWindowStopped(stopped);
                } else {
                    if (nonCurrentThreadRoots == null) {
                        nonCurrentThreadRoots = new ArrayList<ViewRootImpl>();
                    }
                    nonCurrentThreadRoots.add(root);
                }
                this.setStoppedState(root.mAttachInfo.mWindowToken, stopped);
            }
        }
        if (nonCurrentThreadRoots != null) {
            for (int i = nonCurrentThreadRoots.size() - 1; i >= 0; --i) {
                ViewRootImpl root = (ViewRootImpl)nonCurrentThreadRoots.get(i);
                root.mHandler.runWithScissors(() -> root.setWindowStopped(stopped), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportNewConfiguration(Configuration config) {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mViews.size();
            config = new Configuration(config);
            for (int i = 0; i < count; ++i) {
                ViewRootImpl root = this.mRoots.get(i);
                root.requestUpdateConfiguration(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCanvasOpacity(IBinder token, boolean opaque) {
        if (token == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mParams.size() - 1; i >= 0; --i) {
                if (this.mParams.get((int)i).token != token) continue;
                this.mRoots.get(i).changeCanvasOpacity(opaque);
                return;
            }
        }
    }
}

