/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.MergedConfiguration;
import android.view.DisplayCutout;
import android.view.DragEvent;
import android.view.IScrollCaptureController;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import com.android.internal.os.IResultReceiver;

public interface IWindow
extends IInterface {
    public void executeCommand(String var1, String var2, ParcelFileDescriptor var3) throws RemoteException;

    public void resized(Rect var1, Rect var2, Rect var3, Rect var4, boolean var5, MergedConfiguration var6, Rect var7, boolean var8, boolean var9, int var10, DisplayCutout.ParcelableWrapper var11) throws RemoteException;

    public void locationInParentDisplayChanged(Point var1) throws RemoteException;

    public void insetsChanged(InsetsState var1) throws RemoteException;

    public void insetsControlChanged(InsetsState var1, InsetsSourceControl[] var2) throws RemoteException;

    public void showInsets(int var1, boolean var2) throws RemoteException;

    public void hideInsets(int var1, boolean var2) throws RemoteException;

    public void moved(int var1, int var2) throws RemoteException;

    public void dispatchAppVisibility(boolean var1) throws RemoteException;

    public void dispatchGetNewSurface() throws RemoteException;

    public void windowFocusChanged(boolean var1, boolean var2) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    public void dispatchWallpaperOffsets(float var1, float var2, float var3, float var4, float var5, boolean var6) throws RemoteException;

    public void dispatchWallpaperCommand(String var1, int var2, int var3, int var4, Bundle var5, boolean var6) throws RemoteException;

    public void dispatchDragEvent(DragEvent var1) throws RemoteException;

    public void updatePointerIcon(float var1, float var2) throws RemoteException;

    public void dispatchSystemUiVisibilityChanged(int var1, int var2, int var3, int var4) throws RemoteException;

    public void dispatchWindowShown() throws RemoteException;

    public void requestAppKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    public void dispatchPointerCaptureChanged(boolean var1) throws RemoteException;

    public void requestScrollCapture(IScrollCaptureController var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindow {
        private static final String DESCRIPTOR = "android.view.IWindow";
        static final int TRANSACTION_executeCommand = 1;
        static final int TRANSACTION_resized = 2;
        static final int TRANSACTION_locationInParentDisplayChanged = 3;
        static final int TRANSACTION_insetsChanged = 4;
        static final int TRANSACTION_insetsControlChanged = 5;
        static final int TRANSACTION_showInsets = 6;
        static final int TRANSACTION_hideInsets = 7;
        static final int TRANSACTION_moved = 8;
        static final int TRANSACTION_dispatchAppVisibility = 9;
        static final int TRANSACTION_dispatchGetNewSurface = 10;
        static final int TRANSACTION_windowFocusChanged = 11;
        static final int TRANSACTION_closeSystemDialogs = 12;
        static final int TRANSACTION_dispatchWallpaperOffsets = 13;
        static final int TRANSACTION_dispatchWallpaperCommand = 14;
        static final int TRANSACTION_dispatchDragEvent = 15;
        static final int TRANSACTION_updatePointerIcon = 16;
        static final int TRANSACTION_dispatchSystemUiVisibilityChanged = 17;
        static final int TRANSACTION_dispatchWindowShown = 18;
        static final int TRANSACTION_requestAppKeyboardShortcuts = 19;
        static final int TRANSACTION_dispatchPointerCaptureChanged = 20;
        static final int TRANSACTION_requestScrollCapture = 21;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindow asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindow) {
                return (IWindow)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "executeCommand";
                }
                case 2: {
                    return "resized";
                }
                case 3: {
                    return "locationInParentDisplayChanged";
                }
                case 4: {
                    return "insetsChanged";
                }
                case 5: {
                    return "insetsControlChanged";
                }
                case 6: {
                    return "showInsets";
                }
                case 7: {
                    return "hideInsets";
                }
                case 8: {
                    return "moved";
                }
                case 9: {
                    return "dispatchAppVisibility";
                }
                case 10: {
                    return "dispatchGetNewSurface";
                }
                case 11: {
                    return "windowFocusChanged";
                }
                case 12: {
                    return "closeSystemDialogs";
                }
                case 13: {
                    return "dispatchWallpaperOffsets";
                }
                case 14: {
                    return "dispatchWallpaperCommand";
                }
                case 15: {
                    return "dispatchDragEvent";
                }
                case 16: {
                    return "updatePointerIcon";
                }
                case 17: {
                    return "dispatchSystemUiVisibilityChanged";
                }
                case 18: {
                    return "dispatchWindowShown";
                }
                case 19: {
                    return "requestAppKeyboardShortcuts";
                }
                case 20: {
                    return "dispatchPointerCaptureChanged";
                }
                case 21: {
                    return "requestScrollCapture";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ParcelFileDescriptor _arg2 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.executeCommand(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    Rect _arg0 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Rect _arg2 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    Rect _arg3 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    boolean _arg4 = 0 != data.readInt();
                    MergedConfiguration _arg5 = 0 != data.readInt() ? MergedConfiguration.CREATOR.createFromParcel(data) : null;
                    Rect _arg6 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    boolean _arg7 = 0 != data.readInt();
                    boolean _arg8 = 0 != data.readInt();
                    int _arg9 = data.readInt();
                    DisplayCutout.ParcelableWrapper _arg10 = 0 != data.readInt() ? DisplayCutout.ParcelableWrapper.CREATOR.createFromParcel(data) : null;
                    this.resized(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Point _arg0 = 0 != data.readInt() ? Point.CREATOR.createFromParcel(data) : null;
                    this.locationInParentDisplayChanged(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    InsetsState _arg0 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    this.insetsChanged(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    InsetsState _arg0 = 0 != data.readInt() ? InsetsState.CREATOR.createFromParcel(data) : null;
                    InsetsSourceControl[] _arg1 = data.createTypedArray(InsetsSourceControl.CREATOR);
                    this.insetsControlChanged(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.showInsets(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.hideInsets(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.moved(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.dispatchAppVisibility(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    this.dispatchGetNewSurface();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.windowFocusChanged(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.closeSystemDialogs(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    boolean _arg5 = 0 != data.readInt();
                    this.dispatchWallpaperOffsets(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    boolean _arg5 = 0 != data.readInt();
                    this.dispatchWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    DragEvent _arg0 = 0 != data.readInt() ? DragEvent.CREATOR.createFromParcel(data) : null;
                    this.dispatchDragEvent(_arg0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    float _arg1 = data.readFloat();
                    this.updatePointerIcon(_arg0, _arg1);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.dispatchSystemUiVisibilityChanged(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    this.dispatchWindowShown();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.requestAppKeyboardShortcuts(_arg0, _arg1);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.dispatchPointerCaptureChanged(_arg0);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    IScrollCaptureController _arg0 = IScrollCaptureController.Stub.asInterface(data.readStrongBinder());
                    this.requestScrollCapture(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWindow impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWindow getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWindow {
            private IBinder mRemote;
            public static IWindow sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeCommand(String command, String parameters, ParcelFileDescriptor descriptor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(command);
                    _data.writeString(parameters);
                    if (descriptor != null) {
                        _data.writeInt(1);
                        descriptor.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().executeCommand(command, parameters, descriptor);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resized(Rect frame, Rect contentInsets, Rect visibleInsets, Rect stableInsets, boolean reportDraw, MergedConfiguration newMergedConfiguration, Rect backDropFrame, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId, DisplayCutout.ParcelableWrapper displayCutout) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (contentInsets != null) {
                        _data.writeInt(1);
                        contentInsets.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (visibleInsets != null) {
                        _data.writeInt(1);
                        visibleInsets.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (stableInsets != null) {
                        _data.writeInt(1);
                        stableInsets.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(reportDraw ? 1 : 0);
                    if (newMergedConfiguration != null) {
                        _data.writeInt(1);
                        newMergedConfiguration.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (backDropFrame != null) {
                        _data.writeInt(1);
                        backDropFrame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(forceLayout ? 1 : 0);
                    _data.writeInt(alwaysConsumeSystemBars ? 1 : 0);
                    _data.writeInt(displayId);
                    if (displayCutout != null) {
                        _data.writeInt(1);
                        displayCutout.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().resized(frame, contentInsets, visibleInsets, stableInsets, reportDraw, newMergedConfiguration, backDropFrame, forceLayout, alwaysConsumeSystemBars, displayId, displayCutout);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void locationInParentDisplayChanged(Point offset) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (offset != null) {
                        _data.writeInt(1);
                        offset.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().locationInParentDisplayChanged(offset);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsChanged(InsetsState insetsState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (insetsState != null) {
                        _data.writeInt(1);
                        insetsState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().insetsChanged(insetsState);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (insetsState != null) {
                        _data.writeInt(1);
                        insetsState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray(activeControls, 0);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().insetsControlChanged(insetsState, activeControls);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInsets(int types, boolean fromIme) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeInt(fromIme ? 1 : 0);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showInsets(types, fromIme);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideInsets(int types, boolean fromIme) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeInt(fromIme ? 1 : 0);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideInsets(types, fromIme);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moved(int newX, int newY) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newX);
                    _data.writeInt(newY);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().moved(newX, newY);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchAppVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(visible ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchAppVisibility(visible);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dispatchGetNewSurface() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchGetNewSurface();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hasFocus ? 1 : 0);
                    _data.writeInt(inTouchMode ? 1 : 0);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().windowFocusChanged(hasFocus, inTouchMode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().closeSystemDialogs(reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(x);
                    _data.writeFloat(y);
                    _data.writeFloat(xStep);
                    _data.writeFloat(yStep);
                    _data.writeFloat(zoom);
                    _data.writeInt(sync ? 1 : 0);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchWallpaperOffsets(x, y, xStep, yStep, zoom, sync);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sync ? 1 : 0);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchWallpaperCommand(action, x, y, z, extras, sync);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchDragEvent(DragEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchDragEvent(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePointerIcon(float x, float y) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(x);
                    _data.writeFloat(y);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updatePointerIcon(x, y);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSystemUiVisibilityChanged(int seq, int globalVisibility, int localValue, int localChanges) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seq);
                    _data.writeInt(globalVisibility);
                    _data.writeInt(localValue);
                    _data.writeInt(localChanges);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchSystemUiVisibilityChanged(seq, globalVisibility, localValue, localChanges);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dispatchWindowShown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchWindowShown();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestAppKeyboardShortcuts(receiver, deviceId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchPointerCaptureChanged(boolean hasCapture) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hasCapture ? 1 : 0);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchPointerCaptureChanged(hasCapture);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestScrollCapture(IScrollCaptureController controller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(controller != null ? controller.asBinder() : null);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestScrollCapture(controller);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindow {
        @Override
        public void executeCommand(String command, String parameters, ParcelFileDescriptor descriptor) throws RemoteException {
        }

        @Override
        public void resized(Rect frame, Rect contentInsets, Rect visibleInsets, Rect stableInsets, boolean reportDraw, MergedConfiguration newMergedConfiguration, Rect backDropFrame, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId, DisplayCutout.ParcelableWrapper displayCutout) throws RemoteException {
        }

        @Override
        public void locationInParentDisplayChanged(Point offset) throws RemoteException {
        }

        @Override
        public void insetsChanged(InsetsState insetsState) throws RemoteException {
        }

        @Override
        public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
        }

        @Override
        public void showInsets(int types, boolean fromIme) throws RemoteException {
        }

        @Override
        public void hideInsets(int types, boolean fromIme) throws RemoteException {
        }

        @Override
        public void moved(int newX, int newY) throws RemoteException {
        }

        @Override
        public void dispatchAppVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void dispatchGetNewSurface() throws RemoteException {
        }

        @Override
        public void windowFocusChanged(boolean hasFocus, boolean inTouchMode) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(String reason) throws RemoteException {
        }

        @Override
        public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) throws RemoteException {
        }

        @Override
        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
        }

        @Override
        public void dispatchDragEvent(DragEvent event) throws RemoteException {
        }

        @Override
        public void updatePointerIcon(float x, float y) throws RemoteException {
        }

        @Override
        public void dispatchSystemUiVisibilityChanged(int seq, int globalVisibility, int localValue, int localChanges) throws RemoteException {
        }

        @Override
        public void dispatchWindowShown() throws RemoteException {
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void dispatchPointerCaptureChanged(boolean hasCapture) throws RemoteException {
        }

        @Override
        public void requestScrollCapture(IScrollCaptureController controller) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

