/*
 * Decompiled with CFR 0.152.
 */
package android.util.imagepool;

import android.util.imagepool.ImagePool;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ImageImpl
implements ImagePool.Image {
    private final ReadWriteLock mLock = new ReentrantReadWriteLock();
    private final int mWidth;
    private final int mHeight;
    private final ImagePool.Image.Orientation mOrientation;
    final BufferedImage mImg;

    ImageImpl(int width, int height, BufferedImage img, ImagePool.Image.Orientation orientation) {
        this.mImg = img;
        this.mWidth = width;
        this.mHeight = height;
        this.mOrientation = orientation;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRGB(int x, int y, int width, int height, int[] colors, int offset, int stride) {
        this.mLock.readLock().lock();
        try {
            this.mImg.setRGB(x, y, width, height, colors, offset, stride);
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(Graphics2D graphics, int x, int y, ImageObserver o) {
        this.mLock.readLock().lock();
        try {
            graphics.drawImage(this.mImg, x, y, this.mWidth, this.mHeight, o);
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }
}

