/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Path;
import android.util.PathParser_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.FastNative;

public class PathParser {
    static final String LOGTAG = PathParser.class.getSimpleName();

    @UnsupportedAppUsage
    public static Path createPathFromPathData(String pathString) {
        if (pathString == null) {
            throw new IllegalArgumentException("Path string can not be null.");
        }
        Path path = new Path();
        PathParser.nParseStringForPath(path.mNativePath, pathString, pathString.length());
        return path;
    }

    public static void createPathFromPathData(Path outPath, PathData data) {
        PathParser.nCreatePathFromPathData(outPath.mNativePath, data.mNativePathData);
    }

    public static boolean canMorph(PathData pathDataFrom, PathData pathDataTo) {
        return PathParser.nCanMorph(pathDataFrom.mNativePathData, pathDataTo.mNativePathData);
    }

    public static boolean interpolatePathData(PathData outData, PathData fromData, PathData toData, float fraction2) {
        return PathParser.nInterpolatePathData(outData.mNativePathData, fromData.mNativePathData, toData.mNativePathData, fraction2);
    }

    @LayoutlibDelegate
    private static void nParseStringForPath(long l, String string2, int n) {
        PathParser_Delegate.nParseStringForPath(l, string2, n);
    }

    @LayoutlibDelegate
    private static long nCreatePathDataFromString(String string2, int n) {
        return PathParser_Delegate.nCreatePathDataFromString(string2, n);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nCreatePathFromPathData(long l, long l2) {
        PathParser_Delegate.nCreatePathFromPathData(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreateEmptyPathData() {
        return PathParser_Delegate.nCreateEmptyPathData();
    }

    @LayoutlibDelegate
    @FastNative
    private static long nCreatePathData(long l) {
        return PathParser_Delegate.nCreatePathData(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nInterpolatePathData(long l, long l2, long l3, float f) {
        return PathParser_Delegate.nInterpolatePathData(l, l2, l3, f);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nFinalize(long l) {
        PathParser_Delegate.nFinalize(l);
    }

    @LayoutlibDelegate
    @FastNative
    private static boolean nCanMorph(long l, long l2) {
        return PathParser_Delegate.nCanMorph(l, l2);
    }

    @LayoutlibDelegate
    @FastNative
    private static void nSetPathData(long l, long l2) {
        PathParser_Delegate.nSetPathData(l, l2);
    }

    public static class PathData {
        long mNativePathData = 0L;

        public PathData() {
            this.mNativePathData = PathParser.nCreateEmptyPathData();
        }

        public PathData(PathData data) {
            this.mNativePathData = PathParser.nCreatePathData(data.mNativePathData);
        }

        public PathData(String pathString) {
            this.mNativePathData = PathParser.nCreatePathDataFromString(pathString, pathString.length());
            if (this.mNativePathData == 0L) {
                throw new IllegalArgumentException("Invalid pathData: " + pathString);
            }
        }

        public long getNativePtr() {
            return this.mNativePathData;
        }

        public void setPathData(PathData source) {
            PathParser.nSetPathData(this.mNativePathData, source.mNativePathData);
        }

        protected void finalize() throws Throwable {
            if (this.mNativePathData != 0L) {
                PathParser.nFinalize(this.mNativePathData);
                this.mNativePathData = 0L;
            }
            super.finalize();
        }
    }
}

