/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.LinkProperties;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.DataFailCause;
import android.telephony.data.ApnSetting;
import java.util.Objects;

public class PreciseDataConnectionState
implements Parcelable {
    private int mState = -1;
    private int mNetworkType = 0;
    private int mFailCause = 0;
    private int mApnTypes = 0;
    private String mApn = "";
    private LinkProperties mLinkProperties = null;
    private ApnSetting mApnSetting = null;
    private static final long GET_DATA_CONNECTION_STATE_R_VERSION = 148535736L;
    public static final Parcelable.Creator<PreciseDataConnectionState> CREATOR = new Parcelable.Creator<PreciseDataConnectionState>(){

        @Override
        public PreciseDataConnectionState createFromParcel(Parcel in) {
            return new PreciseDataConnectionState(in);
        }

        public PreciseDataConnectionState[] newArray(int size) {
            return new PreciseDataConnectionState[size];
        }
    };

    @Deprecated
    @UnsupportedAppUsage
    public PreciseDataConnectionState(int state, int networkType, int apnTypes, String apn, LinkProperties linkProperties, int failCause) {
        this(state, networkType, apnTypes, apn, linkProperties, failCause, null);
    }

    public PreciseDataConnectionState(int state, int networkType, int apnTypes, String apn, LinkProperties linkProperties, int failCause, ApnSetting apnSetting) {
        this.mState = state;
        this.mNetworkType = networkType;
        this.mApnTypes = apnTypes;
        this.mApn = apn;
        this.mLinkProperties = linkProperties;
        this.mFailCause = failCause;
        this.mApnSetting = apnSetting;
    }

    public PreciseDataConnectionState() {
    }

    private PreciseDataConnectionState(Parcel in) {
        this.mState = in.readInt();
        this.mNetworkType = in.readInt();
        this.mApnTypes = in.readInt();
        this.mApn = in.readString();
        this.mLinkProperties = (LinkProperties)in.readParcelable(null);
        this.mFailCause = in.readInt();
        this.mApnSetting = (ApnSetting)in.readParcelable(null);
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionState() {
        if (this.mState == 4 && !Compatibility.isChangeEnabled(148535736L)) {
            return 2;
        }
        return this.mState;
    }

    public int getState() {
        return this.mState;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionNetworkType() {
        return this.mNetworkType;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionApnTypeBitMask() {
        return this.mApnTypes;
    }

    @SystemApi
    @Deprecated
    public String getDataConnectionApn() {
        return this.mApn;
    }

    @Deprecated
    @SystemApi
    public LinkProperties getDataConnectionLinkProperties() {
        return this.mLinkProperties;
    }

    public LinkProperties getLinkProperties() {
        return this.mLinkProperties;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionFailCause() {
        return this.mFailCause;
    }

    public int getLastCauseCode() {
        return this.mFailCause;
    }

    public ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mState);
        out.writeInt(this.mNetworkType);
        out.writeInt(this.mApnTypes);
        out.writeString(this.mApn);
        out.writeParcelable(this.mLinkProperties, flags);
        out.writeInt(this.mFailCause);
        out.writeParcelable(this.mApnSetting, flags);
    }

    public int hashCode() {
        return Objects.hash(this.mState, this.mNetworkType, this.mApnTypes, this.mApn, this.mLinkProperties, this.mFailCause, this.mApnSetting);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PreciseDataConnectionState)) {
            return false;
        }
        PreciseDataConnectionState other = (PreciseDataConnectionState)obj;
        return Objects.equals(this.mApn, other.mApn) && this.mApnTypes == other.mApnTypes && this.mFailCause == other.mFailCause && Objects.equals(this.mLinkProperties, other.mLinkProperties) && this.mNetworkType == other.mNetworkType && this.mState == other.mState && Objects.equals(this.mApnSetting, other.mApnSetting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data Connection state: " + this.mState);
        sb.append(", Network type: " + this.mNetworkType);
        sb.append(", APN types: " + ApnSetting.getApnTypesStringFromBitmask(this.mApnTypes));
        sb.append(", APN: " + this.mApn);
        sb.append(", Link properties: " + this.mLinkProperties);
        sb.append(", Fail cause: " + DataFailCause.toString(this.mFailCause));
        sb.append(", Apn Setting: " + this.mApnSetting);
        return sb.toString();
    }
}

