/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Range;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ModemActivityInfo
implements Parcelable {
    public static final int TX_POWER_LEVELS = 5;
    public static final int TX_POWER_LEVEL_0 = 0;
    public static final int TX_POWER_LEVEL_1 = 1;
    public static final int TX_POWER_LEVEL_2 = 2;
    public static final int TX_POWER_LEVEL_3 = 3;
    public static final int TX_POWER_LEVEL_4 = 4;
    private static final Range<Integer>[] TX_POWER_RANGES = new Range[]{new Range<Integer>(Integer.MIN_VALUE, 0), new Range<Integer>(0, 5), new Range<Integer>(5, 15), new Range<Integer>(15, 20), new Range<Integer>(20, Integer.MAX_VALUE)};
    private long mTimestamp;
    private int mSleepTimeMs;
    private int mIdleTimeMs;
    private List<TransmitPower> mTransmitPowerInfo = new ArrayList<TransmitPower>(5);
    private int mRxTimeMs;
    public static final Parcelable.Creator<ModemActivityInfo> CREATOR = new Parcelable.Creator<ModemActivityInfo>(){

        @Override
        public ModemActivityInfo createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            int sleepTimeMs = in.readInt();
            int idleTimeMs = in.readInt();
            int[] txTimeMs = new int[5];
            for (int i = 0; i < 5; ++i) {
                txTimeMs[i] = in.readInt();
            }
            int rxTimeMs = in.readInt();
            return new ModemActivityInfo(timestamp, sleepTimeMs, idleTimeMs, txTimeMs, rxTimeMs);
        }

        public ModemActivityInfo[] newArray(int size) {
            return new ModemActivityInfo[size];
        }
    };

    public ModemActivityInfo(long timestamp, int sleepTimeMs, int idleTimeMs, int[] txTimeMs, int rxTimeMs) {
        this.mTimestamp = timestamp;
        this.mSleepTimeMs = sleepTimeMs;
        this.mIdleTimeMs = idleTimeMs;
        this.populateTransmitPowerRange(txTimeMs);
        this.mRxTimeMs = rxTimeMs;
    }

    private void populateTransmitPowerRange(int[] transmitPowerMs) {
        int i;
        for (i = 0; i < Math.min(transmitPowerMs.length, 5); ++i) {
            this.mTransmitPowerInfo.add(i, new TransmitPower(TX_POWER_RANGES[i], transmitPowerMs[i]));
        }
        while (i < 5) {
            this.mTransmitPowerInfo.add(i, new TransmitPower(TX_POWER_RANGES[i], 0));
            ++i;
        }
    }

    public String toString() {
        return "ModemActivityInfo{ mTimestamp=" + this.mTimestamp + " mSleepTimeMs=" + this.mSleepTimeMs + " mIdleTimeMs=" + this.mIdleTimeMs + " mTransmitPowerInfo[]=" + this.mTransmitPowerInfo.toString() + " mRxTimeMs=" + this.mRxTimeMs + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimestamp);
        dest.writeInt(this.mSleepTimeMs);
        dest.writeInt(this.mIdleTimeMs);
        for (int i = 0; i < 5; ++i) {
            dest.writeInt(this.mTransmitPowerInfo.get(i).getTimeInMillis());
        }
        dest.writeInt(this.mRxTimeMs);
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    public List<TransmitPower> getTransmitPowerInfo() {
        return this.mTransmitPowerInfo;
    }

    public void setTransmitTimeMillis(int[] txTimeMs) {
        this.populateTransmitPowerRange(txTimeMs);
    }

    public int[] getTransmitTimeMillis() {
        int[] transmitTimeMillis = new int[5];
        for (int i = 0; i < transmitTimeMillis.length; ++i) {
            transmitTimeMillis[i] = this.mTransmitPowerInfo.get(i).getTimeInMillis();
        }
        return transmitTimeMillis;
    }

    public int getSleepTimeMillis() {
        return this.mSleepTimeMs;
    }

    public void setSleepTimeMillis(int sleepTimeMillis) {
        this.mSleepTimeMs = sleepTimeMillis;
    }

    public int getIdleTimeMillis() {
        return this.mIdleTimeMs;
    }

    public void setIdleTimeMillis(int idleTimeMillis) {
        this.mIdleTimeMs = idleTimeMillis;
    }

    public int getReceiveTimeMillis() {
        return this.mRxTimeMs;
    }

    public void setReceiveTimeMillis(int rxTimeMillis) {
        this.mRxTimeMs = rxTimeMillis;
    }

    public boolean isValid() {
        for (TransmitPower powerInfo : this.getTransmitPowerInfo()) {
            if (powerInfo.getTimeInMillis() >= 0) continue;
            return false;
        }
        return this.getIdleTimeMillis() >= 0 && this.getSleepTimeMillis() >= 0 && this.getReceiveTimeMillis() >= 0 && !this.isEmpty();
    }

    private boolean isEmpty() {
        for (TransmitPower txVal : this.getTransmitPowerInfo()) {
            if (txVal.getTimeInMillis() == 0) continue;
            return false;
        }
        return this.getIdleTimeMillis() == 0 && this.getSleepTimeMillis() == 0 && this.getReceiveTimeMillis() == 0;
    }

    public class TransmitPower {
        private int mTimeInMillis;
        private Range<Integer> mPowerRangeInDbm;

        public TransmitPower(Range<Integer> range, int time) {
            this.mTimeInMillis = time;
            this.mPowerRangeInDbm = range;
        }

        public int getTimeInMillis() {
            return this.mTimeInMillis;
        }

        public Range<Integer> getPowerRangeInDbm() {
            return this.mPowerRangeInDbm;
        }

        public String toString() {
            return "TransmitPower{ mTimeInMillis=" + this.mTimeInMillis + " mPowerRangeInDbm={" + this.mPowerRangeInDbm.getLower() + "," + this.mPowerRangeInDbm.getUpper() + "}}";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TxPowerLevel {
    }
}

