/*
 * Decompiled with CFR 0.152.
 */
package android.os.incremental;

import android.os.ParcelFileDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class V4Signature {
    public static final String EXT = ".idsig";
    public static final int SUPPORTED_VERSION = 2;
    public static final int HASHING_ALGORITHM_SHA256 = 1;
    public static final byte LOG2_BLOCK_SIZE_4096_BYTES = 12;
    public final int version;
    public final byte[] hashingInfo;
    public final byte[] signingInfo;

    public static V4Signature readFrom(ParcelFileDescriptor pfd) throws IOException {
        try (ParcelFileDescriptor.AutoCloseInputStream stream = new ParcelFileDescriptor.AutoCloseInputStream(pfd.dup());){
            V4Signature v4Signature = V4Signature.readFrom(stream);
            return v4Signature;
        }
    }

    public static V4Signature readFrom(byte[] bytes) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            V4Signature v4Signature = V4Signature.readFrom(stream);
            return v4Signature;
        }
    }

    public byte[] toByteArray() {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.writeTo(stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        stream.close();
        return byArray;
    }

    public static byte[] getSigningData(long fileSize, HashingInfo hashingInfo, SigningInfo signingInfo) {
        int size = 17 + V4Signature.bytesSize(hashingInfo.salt) + V4Signature.bytesSize(hashingInfo.rawRootHash) + V4Signature.bytesSize(signingInfo.apkDigest) + V4Signature.bytesSize(signingInfo.certificate) + V4Signature.bytesSize(signingInfo.additionalData);
        ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(size);
        buffer.putLong(fileSize);
        buffer.putInt(hashingInfo.hashAlgorithm);
        buffer.put(hashingInfo.log2BlockSize);
        V4Signature.writeBytes(buffer, hashingInfo.salt);
        V4Signature.writeBytes(buffer, hashingInfo.rawRootHash);
        V4Signature.writeBytes(buffer, signingInfo.apkDigest);
        V4Signature.writeBytes(buffer, signingInfo.certificate);
        V4Signature.writeBytes(buffer, signingInfo.additionalData);
        return buffer.array();
    }

    public boolean isVersionSupported() {
        return this.version == 2;
    }

    private V4Signature(int version, byte[] hashingInfo, byte[] signingInfo) {
        this.version = version;
        this.hashingInfo = hashingInfo;
        this.signingInfo = signingInfo;
    }

    private static V4Signature readFrom(InputStream stream) throws IOException {
        int version = V4Signature.readIntLE(stream);
        byte[] hashingInfo = V4Signature.readBytes(stream);
        byte[] signingInfo = V4Signature.readBytes(stream);
        return new V4Signature(version, hashingInfo, signingInfo);
    }

    private void writeTo(OutputStream stream) throws IOException {
        V4Signature.writeIntLE(stream, this.version);
        V4Signature.writeBytes(stream, this.hashingInfo);
        V4Signature.writeBytes(stream, this.signingInfo);
    }

    private static int bytesSize(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    private static void readFully(InputStream stream, byte[] buffer) throws IOException {
        int count;
        int len = buffer.length;
        for (int n = 0; n < len; n += count) {
            count = stream.read(buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    private static int readIntLE(InputStream stream) throws IOException {
        byte[] buffer = new byte[4];
        V4Signature.readFully(stream, buffer);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private static void writeIntLE(OutputStream stream, int v) throws IOException {
        byte[] buffer = ByteBuffer.wrap(new byte[4]).order(ByteOrder.LITTLE_ENDIAN).putInt(v).array();
        stream.write(buffer);
    }

    private static byte[] readBytes(InputStream stream) throws IOException {
        try {
            int size = V4Signature.readIntLE(stream);
            byte[] bytes = new byte[size];
            V4Signature.readFully(stream, bytes);
            return bytes;
        }
        catch (EOFException ignored) {
            return null;
        }
    }

    private static byte[] readBytes(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() < 4) {
            throw new EOFException();
        }
        int size = buffer.getInt();
        if (buffer.remaining() < size) {
            throw new EOFException();
        }
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return bytes;
    }

    private static void writeBytes(OutputStream stream, byte[] bytes) throws IOException {
        if (bytes == null) {
            V4Signature.writeIntLE(stream, 0);
            return;
        }
        V4Signature.writeIntLE(stream, bytes.length);
        stream.write(bytes);
    }

    private static void writeBytes(ByteBuffer buffer, byte[] bytes) {
        if (bytes == null) {
            buffer.putInt(0);
            return;
        }
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    public static class SigningInfo {
        public final byte[] apkDigest;
        public final byte[] certificate;
        public final byte[] additionalData;
        public final byte[] publicKey;
        public final int signatureAlgorithmId;
        public final byte[] signature;

        SigningInfo(byte[] apkDigest, byte[] certificate, byte[] additionalData, byte[] publicKey, int signatureAlgorithmId, byte[] signature) {
            this.apkDigest = apkDigest;
            this.certificate = certificate;
            this.additionalData = additionalData;
            this.publicKey = publicKey;
            this.signatureAlgorithmId = signatureAlgorithmId;
            this.signature = signature;
        }

        public static SigningInfo fromByteArray(byte[] bytes) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            byte[] apkDigest = V4Signature.readBytes(buffer);
            byte[] certificate = V4Signature.readBytes(buffer);
            byte[] additionalData = V4Signature.readBytes(buffer);
            byte[] publicKey = V4Signature.readBytes(buffer);
            int signatureAlgorithmId = buffer.getInt();
            byte[] signature = V4Signature.readBytes(buffer);
            return new SigningInfo(apkDigest, certificate, additionalData, publicKey, signatureAlgorithmId, signature);
        }
    }

    public static class HashingInfo {
        public final int hashAlgorithm;
        public final byte log2BlockSize;
        public final byte[] salt;
        public final byte[] rawRootHash;

        HashingInfo(int hashAlgorithm, byte log2BlockSize, byte[] salt, byte[] rawRootHash) {
            this.hashAlgorithm = hashAlgorithm;
            this.log2BlockSize = log2BlockSize;
            this.salt = salt;
            this.rawRootHash = rawRootHash;
        }

        public static HashingInfo fromByteArray(byte[] bytes) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            int hashAlgorithm = buffer.getInt();
            byte log2BlockSize = buffer.get();
            byte[] salt = V4Signature.readBytes(buffer);
            byte[] rawRootHash = V4Signature.readBytes(buffer);
            return new HashingInfo(hashAlgorithm, log2BlockSize, salt, rawRootHash);
        }
    }
}

