/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.PendingIntent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IPullAtomCallback;
import android.os.Parcel;
import android.os.RemoteException;

public interface IStatsManagerService
extends IInterface {
    public void setDataFetchOperation(long var1, PendingIntent var3, String var4) throws RemoteException;

    public void removeDataFetchOperation(long var1, String var3) throws RemoteException;

    public long[] setActiveConfigsChangedOperation(PendingIntent var1, String var2) throws RemoteException;

    public void removeActiveConfigsChangedOperation(String var1) throws RemoteException;

    public void setBroadcastSubscriber(long var1, long var3, PendingIntent var5, String var6) throws RemoteException;

    public void unsetBroadcastSubscriber(long var1, long var3, String var5) throws RemoteException;

    public long[] getRegisteredExperimentIds() throws RemoteException;

    public byte[] getMetadata(String var1) throws RemoteException;

    public byte[] getData(long var1, String var3) throws RemoteException;

    public void addConfiguration(long var1, byte[] var3, String var4) throws RemoteException;

    public void removeConfiguration(long var1, String var3) throws RemoteException;

    public void registerPullAtomCallback(int var1, long var2, long var4, int[] var6, IPullAtomCallback var7) throws RemoteException;

    public void unregisterPullAtomCallback(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsManagerService {
        private static final String DESCRIPTOR = "android.os.IStatsManagerService";
        static final int TRANSACTION_setDataFetchOperation = 1;
        static final int TRANSACTION_removeDataFetchOperation = 2;
        static final int TRANSACTION_setActiveConfigsChangedOperation = 3;
        static final int TRANSACTION_removeActiveConfigsChangedOperation = 4;
        static final int TRANSACTION_setBroadcastSubscriber = 5;
        static final int TRANSACTION_unsetBroadcastSubscriber = 6;
        static final int TRANSACTION_getRegisteredExperimentIds = 7;
        static final int TRANSACTION_getMetadata = 8;
        static final int TRANSACTION_getData = 9;
        static final int TRANSACTION_addConfiguration = 10;
        static final int TRANSACTION_removeConfiguration = 11;
        static final int TRANSACTION_registerPullAtomCallback = 12;
        static final int TRANSACTION_unregisterPullAtomCallback = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatsManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatsManagerService) {
                return (IStatsManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setDataFetchOperation";
                }
                case 2: {
                    return "removeDataFetchOperation";
                }
                case 3: {
                    return "setActiveConfigsChangedOperation";
                }
                case 4: {
                    return "removeActiveConfigsChangedOperation";
                }
                case 5: {
                    return "setBroadcastSubscriber";
                }
                case 6: {
                    return "unsetBroadcastSubscriber";
                }
                case 7: {
                    return "getRegisteredExperimentIds";
                }
                case 8: {
                    return "getMetadata";
                }
                case 9: {
                    return "getData";
                }
                case 10: {
                    return "addConfiguration";
                }
                case 11: {
                    return "removeConfiguration";
                }
                case 12: {
                    return "registerPullAtomCallback";
                }
                case 13: {
                    return "unregisterPullAtomCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    PendingIntent _arg1 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    this.setDataFetchOperation(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.removeDataFetchOperation(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    PendingIntent _arg0 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    long[] _result = this.setActiveConfigsChangedOperation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.removeActiveConfigsChangedOperation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    PendingIntent _arg2 = 0 != data.readInt() ? PendingIntent.CREATOR.createFromParcel(data) : null;
                    String _arg3 = data.readString();
                    this.setBroadcastSubscriber(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    String _arg2 = data.readString();
                    this.unsetBroadcastSubscriber(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    long[] _result = this.getRegisteredExperimentIds();
                    reply.writeNoException();
                    reply.writeLongArray(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    byte[] _result = this.getMetadata(_arg0);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    byte[] _result = this.getData(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    byte[] _arg1 = data.createByteArray();
                    String _arg2 = data.readString();
                    this.addConfiguration(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.removeConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    int[] _arg3 = data.createIntArray();
                    IPullAtomCallback _arg4 = IPullAtomCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerPullAtomCallback(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterPullAtomCallback(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IStatsManagerService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IStatsManagerService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IStatsManagerService {
            private IBinder mRemote;
            public static IStatsManagerService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDataFetchOperation(long configId, PendingIntent pendingIntent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configId);
                    if (pendingIntent != null) {
                        _data.writeInt(1);
                        pendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDataFetchOperation(configId, pendingIntent, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeDataFetchOperation(long configId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeDataFetchOperation(configId, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] setActiveConfigsChangedOperation(PendingIntent pendingIntent, String packageName) throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        _data.writeInt(1);
                        pendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long[] lArray = Stub.getDefaultImpl().setActiveConfigsChangedOperation(pendingIntent, packageName);
                        return lArray;
                    }
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeActiveConfigsChangedOperation(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeActiveConfigsChangedOperation(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configKey);
                    _data.writeLong(subscriberId);
                    if (pendingIntent != null) {
                        _data.writeInt(1);
                        pendingIntent.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setBroadcastSubscriber(configKey, subscriberId, pendingIntent, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsetBroadcastSubscriber(long configKey, long subscriberId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configKey);
                    _data.writeLong(subscriberId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unsetBroadcastSubscriber(configKey, subscriberId, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long[] getRegisteredExperimentIds() throws RemoteException {
                long[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long[] lArray = Stub.getDefaultImpl().getRegisteredExperimentIds();
                        return lArray;
                    }
                    _reply.readException();
                    _result = _reply.createLongArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getMetadata(String packageName) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getMetadata(packageName);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getData(long key, String packageName) throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(key);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().getData(key, packageName);
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addConfiguration(long configId, byte[] config, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeByteArray(config);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addConfiguration(configId, config, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeConfiguration(long configId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(configId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeConfiguration(configId, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPullAtomCallback(int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(atomTag);
                    _data.writeLong(coolDownMillis);
                    _data.writeLong(timeoutMillis);
                    _data.writeIntArray(additiveFields);
                    _data.writeStrongBinder(pullerCallback != null ? pullerCallback.asBinder() : null);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerPullAtomCallback(atomTag, coolDownMillis, timeoutMillis, additiveFields, pullerCallback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterPullAtomCallback(int atomTag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(atomTag);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterPullAtomCallback(atomTag);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatsManagerService {
        @Override
        public void setDataFetchOperation(long configId, PendingIntent pendingIntent, String packageName) throws RemoteException {
        }

        @Override
        public void removeDataFetchOperation(long configId, String packageName) throws RemoteException {
        }

        @Override
        public long[] setActiveConfigsChangedOperation(PendingIntent pendingIntent, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void removeActiveConfigsChangedOperation(String packageName) throws RemoteException {
        }

        @Override
        public void setBroadcastSubscriber(long configKey, long subscriberId, PendingIntent pendingIntent, String packageName) throws RemoteException {
        }

        @Override
        public void unsetBroadcastSubscriber(long configKey, long subscriberId, String packageName) throws RemoteException {
        }

        @Override
        public long[] getRegisteredExperimentIds() throws RemoteException {
            return null;
        }

        @Override
        public byte[] getMetadata(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public byte[] getData(long key, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void addConfiguration(long configId, byte[] config, String packageName) throws RemoteException {
        }

        @Override
        public void removeConfiguration(long configId, String packageName) throws RemoteException {
        }

        @Override
        public void registerPullAtomCallback(int atomTag, long coolDownMillis, long timeoutMillis, int[] additiveFields, IPullAtomCallback pullerCallback) throws RemoteException {
        }

        @Override
        public void unregisterPullAtomCallback(int atomTag) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

