/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IIncidentDumpCallback;
import android.os.IIncidentReportStatusListener;
import android.os.IInterface;
import android.os.IncidentManager;
import android.os.IncidentReportArgs;
import android.os.Parcel;
import android.os.RemoteException;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;

public interface IIncidentManager
extends IInterface {
    public void reportIncident(IncidentReportArgs var1) throws RemoteException;

    public void reportIncidentToStream(IncidentReportArgs var1, IIncidentReportStatusListener var2, FileDescriptor var3) throws RemoteException;

    public void reportIncidentToDumpstate(FileDescriptor var1, IIncidentReportStatusListener var2) throws RemoteException;

    public void registerSection(int var1, String var2, IIncidentDumpCallback var3) throws RemoteException;

    public void unregisterSection(int var1) throws RemoteException;

    public void systemRunning() throws RemoteException;

    public List<String> getIncidentReportList(String var1, String var2) throws RemoteException;

    public IncidentManager.IncidentReport getIncidentReport(String var1, String var2, String var3) throws RemoteException;

    public void deleteIncidentReports(String var1, String var2, String var3) throws RemoteException;

    public void deleteAllIncidentReports(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIncidentManager {
        private static final String DESCRIPTOR = "android.os.IIncidentManager";
        static final int TRANSACTION_reportIncident = 1;
        static final int TRANSACTION_reportIncidentToStream = 2;
        static final int TRANSACTION_reportIncidentToDumpstate = 3;
        static final int TRANSACTION_registerSection = 4;
        static final int TRANSACTION_unregisterSection = 5;
        static final int TRANSACTION_systemRunning = 6;
        static final int TRANSACTION_getIncidentReportList = 7;
        static final int TRANSACTION_getIncidentReport = 8;
        static final int TRANSACTION_deleteIncidentReports = 9;
        static final int TRANSACTION_deleteAllIncidentReports = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIncidentManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIncidentManager) {
                return (IIncidentManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportIncident";
                }
                case 2: {
                    return "reportIncidentToStream";
                }
                case 3: {
                    return "reportIncidentToDumpstate";
                }
                case 4: {
                    return "registerSection";
                }
                case 5: {
                    return "unregisterSection";
                }
                case 6: {
                    return "systemRunning";
                }
                case 7: {
                    return "getIncidentReportList";
                }
                case 8: {
                    return "getIncidentReport";
                }
                case 9: {
                    return "deleteIncidentReports";
                }
                case 10: {
                    return "deleteAllIncidentReports";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IncidentReportArgs _arg0 = 0 != data.readInt() ? IncidentReportArgs.CREATOR.createFromParcel(data) : null;
                    this.reportIncident(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IncidentReportArgs _arg0 = 0 != data.readInt() ? IncidentReportArgs.CREATOR.createFromParcel(data) : null;
                    IIncidentReportStatusListener _arg1 = IIncidentReportStatusListener.Stub.asInterface(data.readStrongBinder());
                    FileDescriptor _arg2 = data.readRawFileDescriptor();
                    this.reportIncidentToStream(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    FileDescriptor _arg0 = data.readRawFileDescriptor();
                    IIncidentReportStatusListener _arg1 = IIncidentReportStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.reportIncidentToDumpstate(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IIncidentDumpCallback _arg2 = IIncidentDumpCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSection(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.unregisterSection(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.systemRunning();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<String> _result = this.getIncidentReportList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IncidentManager.IncidentReport _result = this.getIncidentReport(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.deleteIncidentReports(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.deleteAllIncidentReports(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IIncidentManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IIncidentManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IIncidentManager {
            private IBinder mRemote;
            public static IIncidentManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportIncident(IncidentReportArgs args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportIncident(args);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportIncidentToStream(IncidentReportArgs args, IIncidentReportStatusListener listener, FileDescriptor stream) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeRawFileDescriptor(stream);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportIncidentToStream(args, listener, stream);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportIncidentToDumpstate(FileDescriptor stream, IIncidentReportStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeRawFileDescriptor(stream);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().reportIncidentToDumpstate(stream, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSection(int id2, String name, IIncidentDumpCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeString(name);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSection(id2, name, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSection(int id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSection(id2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void systemRunning() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().systemRunning();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getIncidentReportList(String pkg, String cls) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(cls);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getIncidentReportList(pkg, cls);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IncidentManager.IncidentReport getIncidentReport(String pkg, String cls, String id2) throws RemoteException {
                IncidentManager.IncidentReport _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(cls);
                    _data.writeString(id2);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        IncidentManager.IncidentReport incidentReport = Stub.getDefaultImpl().getIncidentReport(pkg, cls, id2);
                        return incidentReport;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? IncidentManager.IncidentReport.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteIncidentReports(String pkg, String cls, String id2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(cls);
                    _data.writeString(id2);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteIncidentReports(pkg, cls, id2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteAllIncidentReports(String pkg) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deleteAllIncidentReports(pkg);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IIncidentManager {
        @Override
        public void reportIncident(IncidentReportArgs args) throws RemoteException {
        }

        @Override
        public void reportIncidentToStream(IncidentReportArgs args, IIncidentReportStatusListener listener, FileDescriptor stream) throws RemoteException {
        }

        @Override
        public void reportIncidentToDumpstate(FileDescriptor stream, IIncidentReportStatusListener listener) throws RemoteException {
        }

        @Override
        public void registerSection(int id2, String name, IIncidentDumpCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSection(int id2) throws RemoteException {
        }

        @Override
        public void systemRunning() throws RemoteException {
        }

        @Override
        public List<String> getIncidentReportList(String pkg, String cls) throws RemoteException {
            return null;
        }

        @Override
        public IncidentManager.IncidentReport getIncidentReport(String pkg, String cls, String id2) throws RemoteException {
            return null;
        }

        @Override
        public void deleteIncidentReports(String pkg, String cls, String id2) throws RemoteException {
        }

        @Override
        public void deleteAllIncidentReports(String pkg) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

